/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors.preference;

import java.text.DecimalFormat;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.ui.widgets.LabelFieldEditor;
import org.dawb.workbench.ui.Activator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.edna.workbench.editors.preferencePage";
    private StringFieldEditor formatFieldEditor;

    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Preferences for viewing data sets available in nexus and ascii data.");
    }

    protected void createFieldEditors() {
        BooleanFieldEditor booleanFieldEditor;
        Object object;
        BooleanFieldEditor booleanFieldEditor2;
        BooleanFieldEditor booleanFieldEditor3;
        String[][] stringArray = PlottingFactory.getPlottingPreferenceChoices();
        ComboFieldEditor comboFieldEditor = new ComboFieldEditor("org.dawb.plotting.system.choice", "Plotting Technology*", stringArray, this.getFieldEditorParent());
        this.addField((FieldEditor)comboFieldEditor);
        new LabelFieldEditor("(* Please close and reopen the part after changing plotting preference.)\n\n", this.getFieldEditorParent());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.diamond.scisoft.analysis.data.set.filter");
        if (iConfigurationElementArray != null && iConfigurationElementArray.length > 0) {
            booleanFieldEditor3 = new Label(this.getFieldEditorParent(), 0);
            booleanFieldEditor3.setLayoutData((Object)new GridData(4, 0, true, false, 1, 5));
            booleanFieldEditor2 = new BooleanFieldEditor("ignore.data.set.filters", "Show all possible data sets", this.getFieldEditorParent());
            this.addField((FieldEditor)booleanFieldEditor2);
            object = new StringBuilder("Current data set filters:\n");
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                booleanFieldEditor = iConfigurationElementArray2[n2];
                ((StringBuilder)object).append("\t-    ");
                String string = booleanFieldEditor.getAttribute("regularExpression");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("\n");
                ++n2;
            }
            ((StringBuilder)object).append("\nData set filters reduce the content available to plot and\ncompare for simplicity but can be turned off.\nAll data is shown in the nexus tree, filters are not applied.");
            booleanFieldEditor = new Label(this.getFieldEditorParent(), 64);
            booleanFieldEditor.setText(((StringBuilder)object).toString());
            booleanFieldEditor.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        booleanFieldEditor3 = new BooleanFieldEditor("show.xy.column.in.nexus.editor", "Show XY column.", this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor3);
        booleanFieldEditor2 = new BooleanFieldEditor("show.data.size.in.nexus.editor", "Show size column.", this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor2);
        object = new BooleanFieldEditor("show.dims.in.nexus.editor", "Show dimensions column.", this.getFieldEditorParent());
        this.addField((FieldEditor)object);
        booleanFieldEditor = new BooleanFieldEditor("show.shape.in.nexus.editor", "Show shape column.", this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor);
        BooleanFieldEditor booleanFieldEditor4 = new BooleanFieldEditor("show.variable.name.in.nexus.editor", "Show expression variable name.", this.getFieldEditorParent());
        this.addField((FieldEditor)booleanFieldEditor4);
        new LabelFieldEditor("\nEditors with a 'Data' tab, show the data of the current plot.\nThis option sets the number format for the table and the csv file, if the data is exported.", this.getFieldEditorParent());
        this.formatFieldEditor = new StringFieldEditor("data.format.editor.view", "Number format:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.formatFieldEditor);
        new LabelFieldEditor("Examples: #0.0000, 0.###E0, ##0.#####E0, 00.###E0", this.getFieldEditorParent());
        new LabelFieldEditor("\n", this.getFieldEditorParent());
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("data.format.slice.play.speed", "Speed of slice play for n-Dimensional data sets (ms):", this.getFieldEditorParent()){

            protected boolean checkState() {
                if (!super.checkState()) {
                    return false;
                }
                return this.getIntValue() >= 10 && this.getIntValue() <= 10000;
            }
        };
        this.addField((FieldEditor)integerFieldEditor);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 1;
    }

    protected void checkState() {
        super.checkState();
        try {
            DecimalFormat decimalFormat = new DecimalFormat(this.formatFieldEditor.getStringValue());
            decimalFormat.format(100.001);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setErrorMessage("The format '" + this.formatFieldEditor.getStringValue() + "' is not valid.");
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }
}

