/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import fable.imageviewer.editor.ImageEditor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystemSelection;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.slicing.ISlicablePlottingPart;
import org.dawb.common.ui.slicing.SliceComponent;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.workbench.ui.editors.CSVDataEditor;
import org.dawb.workbench.ui.editors.PlotDataComponent;
import org.dawb.workbench.ui.editors.PlotDataEditor;
import org.dawb.workbench.ui.editors.slicing.ZipUtils;
import org.dawb.workbench.ui.views.PlotDataPage;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.gda.util.io.FileUtils;

public class ZipEditor
extends MultiPageEditorPart
implements ISlicablePlottingPart,
IPlottingSystemSelection {
    public static final String ID = "org.dawb.workbench.editor.ZipEditor";
    private static final Logger logger = LoggerFactory.getLogger(ZipEditor.class);
    private CSVDataEditor dataEditor;
    private PlotDataEditor dataSetEditor;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        int n = 0;
        while (n < this.getPageCount()) {
            this.removePage(n);
            ++n;
        }
        this.createPages();
    }

    protected void createPages() {
        try {
            if (this.isOneDZipFile()) {
                this.dataSetEditor = new PlotDataEditor(true, PlotType.IMAGE);
                this.addPage(0, this.dataSetEditor, this.getUnzippedEditorInput());
                this.setPageText(0, "Plot");
                this.addPage(1, (IEditorPart)new TextEditor(), this.getUnzippedEditorInput());
                this.setPageText(1, "Text");
                this.dataEditor = new CSVDataEditor();
                this.dataEditor.setDataProvider(this.dataSetEditor);
                this.addPage(2, (IEditorPart)this.dataEditor, this.getUnzippedEditorInput());
                this.setPageText(2, "Data");
                this.addPageChangedListener(this.dataEditor);
            } else {
                IEditorInput[] iEditorInputArray = this.getImageEditorInput();
                int n = 0;
                while (n < iEditorInputArray.length) {
                    this.addPage(n, (IEditorPart)new ImageEditor(), iEditorInputArray[n]);
                    this.setPageText(n, "Image " + (n + 1));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            logger.error("Cannot initiate " + ((Object)((Object)this)).getClass().getName() + "!", (Throwable)exception);
        }
    }

    public void dispose() {
        if (this.dataEditor != null) {
            this.removePageChangedListener(this.dataEditor);
        }
        this.dataEditor = null;
        super.dispose();
    }

    private IEditorInput getUnzippedEditorInput() throws Exception {
        InputStream inputStream = ZipUtils.getStreamForFile(EclipseUtils.getFile((IEditorInput)this.getEditorInput()));
        String string = this.getEditorInput().getName();
        String string2 = FileUtils.getFileExtension((String)string);
        String string3 = FileUtils.getFileExtension((String)string.substring(0, string.length() - string2.length() - 1));
        File file = File.createTempFile(string, "." + string3);
        file.deleteOnExit();
        FileUtils.write((BufferedInputStream)new BufferedInputStream(inputStream), (File)file);
        IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        return new FileStoreEditorInput(iFileStore);
    }

    private IEditorInput[] getImageEditorInput() throws Exception {
        return new IEditorInput[]{this.getUnzippedEditorInput()};
    }

    private boolean isOneDZipFile() {
        if (this.getEditorInput() == null) {
            return false;
        }
        String string = this.getEditorInput().getName();
        if (string.toLowerCase().endsWith(".dat.gz")) {
            return true;
        }
        if (string.toLowerCase().endsWith(".dat.bz2")) {
            return true;
        }
        if (string.toLowerCase().endsWith(".dat.zip")) {
            return true;
        }
        if (string.toLowerCase().endsWith(".srs.gz")) {
            return true;
        }
        if (string.toLowerCase().endsWith(".srs.bz2")) {
            return true;
        }
        return string.toLowerCase().endsWith(".srs.zip");
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.getActiveEditor().isDirty()) {
            this.getActiveEditor().doSave(iProgressMonitor);
        }
    }

    public void doSaveAs() {
        if (this.getActiveEditor().isDirty()) {
            this.getActiveEditor().doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public PlotDataComponent getDataSetComponent() {
        return ((PlotDataEditor)this.getEditor(0)).getDataSetComponent();
    }

    public SliceComponent getSliceComponent() {
        return ((PlotDataEditor)this.getEditor(0)).getSliceComponent();
    }

    public void setActivePage(int n) {
        super.setActivePage(n);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public IPlottingSystem getPlotWindow() {
        return ((PlotDataEditor)this.getEditor(0)).getPlotWindow();
    }

    public PlotDataEditor getDataSetEditor() {
        return this.dataSetEditor;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            PlotDataEditor plotDataEditor = this.getDataSetEditor();
            return new PlotDataPage(plotDataEditor);
        }
        if (clazz == IToolPageSystem.class) {
            return this.dataSetEditor.getPlottingSystem();
        }
        return super.getAdapter(clazz);
    }

    public AbstractDataset setDatasetSelected(String string, boolean bl) {
        return this.getDataSetComponent().setDatasetSelected(string, bl);
    }

    public void setAll1DSelected(boolean bl) {
        this.getDataSetComponent().setAll1DSelected(bl);
    }
}

