/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.dawb.common.services.ILoaderService;
import org.dawb.common.services.ServiceManager;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.slicing.SliceUtils;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.common.ui.views.HeaderTablePage;
import org.dawb.common.ui.widgets.ActionBarWrapper;
import org.dawb.workbench.ui.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public class PlotImageEditor
extends EditorPart
implements IReusableEditor {
    public static final String ID = "org.dawb.workbench.editors.plotImageEditor";
    private static Logger logger = LoggerFactory.getLogger(PlotImageEditor.class);
    private AbstractPlottingSystem plottingSystem;
    private Composite tools;

    public PlotImageEditor() {
        try {
            this.plottingSystem = PlottingFactory.getPlottingSystem();
            this.plottingSystem.setColorOption(AbstractPlottingSystem.ColorOption.NONE);
        }
        catch (Exception exception) {
            logger.error("Cannot locate any plotting systems!", (Throwable)exception);
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        this.createPlot();
    }

    public boolean isDirty() {
        return false;
    }

    public void setToolbarsVisible(boolean bl) {
        GridUtils.setVisible((Control)this.tools, (boolean)bl);
        this.tools.getParent().layout(new Control[]{this.tools});
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.tools = new Composite(composite2, 131072);
        this.tools.setLayout((Layout)new GridLayout(4, false));
        GridUtils.removeMargins((Composite)this.tools);
        this.tools.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text text = new Text(this.tools, 16384);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setEditable(false);
        text.setBackground(this.tools.getBackground());
        this.plottingSystem.setPointControls(text);
        GridUtils.setVisible((Control)text, (boolean)false);
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        final ToolBar toolBar = toolBarManager.createControl(this.tools);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        ToolBarManager toolBarManager2 = new ToolBarManager(0x820000);
        ToolBar toolBar2 = toolBarManager2.createControl(this.tools);
        toolBar2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final MenuManager menuManager = new MenuManager();
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        ActionBarWrapper actionBarWrapper = new ActionBarWrapper((IToolBarManager)toolBarManager, (IMenuManager)menuManager, null, (IActionBars2)iActionBars);
        String string = this.getEditorInput().getName();
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new FillLayout());
        this.plottingSystem.createPlotPart(composite3, string, (IActionBars)actionBarWrapper, PlotType.IMAGE, (IWorkbenchPart)this);
        Action action = new Action("", Activator.getImageDescriptor("/icons/DropDown.png")){

            public void run() {
                Menu menu = menuManager.createContextMenu((Control)toolBar);
                menu.setVisible(true);
            }
        };
        toolBarManager2.add((IAction)action);
        if (toolBarManager != null) {
            toolBarManager.update(true);
        }
        if (toolBarManager2 != null) {
            toolBarManager2.update(true);
        }
        this.createPlot();
        this.getEditorSite().setSelectionProvider(this.plottingSystem.getSelectionProvider());
    }

    private void createPlot() {
        Job job = new Job("Read image data"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                AbstractDataset abstractDataset;
                Object object;
                String string = EclipseUtils.getFilePath((IEditorInput)PlotImageEditor.this.getEditorInput());
                try {
                    object = (ILoaderService)ServiceManager.getService(ILoaderService.class);
                    abstractDataset = object.getDataset(string);
                }
                catch (Throwable throwable) {
                    logger.error("Cannot load file " + string, throwable);
                    return Status.CANCEL_STATUS;
                }
                object = new ArrayList(2);
                if (abstractDataset == null || abstractDataset.getShape() == null) {
                    logger.error("Cannot read file " + PlotImageEditor.this.getEditorInput().getName());
                    return Status.CANCEL_STATUS;
                }
                object.add(SliceUtils.createAxisDataset((int)abstractDataset.getShape()[0]));
                object.add(SliceUtils.createAxisDataset((int)abstractDataset.getShape()[1]));
                abstractDataset.setName("");
                PlotImageEditor.this.plottingSystem.createPlot2D(abstractDataset, (List)object, iProgressMonitor);
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setPriority(40);
        job.schedule();
    }

    protected void createCustomToolbarActionsRight(ToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator(String.valueOf(((Object)((Object)this)).getClass().getName()) + "Separator1"));
        Action action = new Action("Open editor preferences.", 1){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.edna.workbench.editors.preferencePage", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        action.setChecked(false);
        action.setImageDescriptor(Activator.getImageDescriptor("icons/application_view_columns.png"));
        toolBarManager.add((IAction)action);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.plottingSystem != null) {
            this.plottingSystem.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            return new HeaderTablePage(EclipseUtils.getFilePath((IEditorInput)this.getEditorInput()));
        }
        if (clazz == IToolPageSystem.class) {
            return this.plottingSystem;
        }
        return super.getAdapter(clazz);
    }

    public AbstractPlottingSystem getPlottingSystem() {
        return this.plottingSystem;
    }
}

