/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.ui.monitor.ProgressMonitorWrapper;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.slicing.SliceComponent;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.common.ui.views.PlotDataView;
import org.dawb.common.ui.widgets.ActionBarWrapper;
import org.dawb.workbench.ui.Activator;
import org.dawb.workbench.ui.editors.CheckableObject;
import org.dawb.workbench.ui.editors.IDatasetEditor;
import org.dawb.workbench.ui.editors.IPlotUpdateParticipant;
import org.dawb.workbench.ui.editors.PlotDataComponent;
import org.dawb.workbench.ui.editors.slicing.ExpressionObject;
import org.dawb.workbench.ui.views.PlotDataPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.monitor.IMonitor;

public class PlotDataEditor
extends EditorPart
implements IReusableEditor,
IDatasetEditor {
    private static Logger logger = LoggerFactory.getLogger(PlotDataEditor.class);
    private AbstractPlottingSystem plottingSystem;
    private Collection<String> dataNames;
    private Map<String, ILazyDataset> dataCache;
    private Composite tools;
    private IMetaData metaData;
    private PlotType defaultPlotType;
    private boolean doingUpdate = false;
    private boolean extractingMetaData;

    public PlotDataEditor(boolean bl, PlotType plotType) {
        try {
            this.defaultPlotType = plotType;
            this.plottingSystem = PlottingFactory.getPlottingSystem();
        }
        catch (Exception exception) {
            logger.error("Cannot locate any plotting systems!", (Throwable)exception);
        }
        if (bl) {
            this.dataCache = new HashMap<String, ILazyDataset>(7);
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
    }

    @Override
    public Map<String, IDataset> getSelected() {
        PlotDataComponent plotDataComponent = this.getDataSetComponent();
        HashMap<String, IDataset> hashMap = new HashMap<String, IDataset>(3);
        if (plotDataComponent == null) {
            return hashMap;
        }
        List<CheckableObject> list = plotDataComponent.getSelections();
        for (CheckableObject checkableObject : list) {
            AbstractDataset abstractDataset = this.getDataSet(checkableObject, null);
            hashMap.put(abstractDataset.getName(), (IDataset)abstractDataset);
        }
        return hashMap;
    }

    public boolean isDirty() {
        return false;
    }

    public void setToolbarsVisible(boolean bl) {
        GridUtils.setVisible((Control)this.tools, (boolean)bl);
        this.tools.getParent().layout(new Control[]{this.tools});
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite2.setLayout((Layout)gridLayout);
        GridUtils.removeMargins((Composite)composite2);
        this.tools = new Composite(composite2, 131072);
        this.tools.setLayout((Layout)new GridLayout(4, false));
        GridUtils.removeMargins((Composite)this.tools);
        this.tools.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text text = new Text(this.tools, 16384);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setEditable(false);
        GridUtils.setVisible((Control)text, (boolean)true);
        text.setBackground(this.tools.getBackground());
        this.plottingSystem.setPointControls(text);
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        final ToolBar toolBar = toolBarManager.createControl(this.tools);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        ToolBarManager toolBarManager2 = new ToolBarManager(0x820000);
        ToolBar toolBar2 = toolBarManager2.createControl(this.tools);
        toolBar2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final MenuManager menuManager = new MenuManager();
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        ActionBarWrapper actionBarWrapper = new ActionBarWrapper((IToolBarManager)toolBarManager, (IMenuManager)menuManager, null, (IActionBars2)iActionBars);
        String string = this.getEditorInput().getName();
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new FillLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.plottingSystem.createPlotPart(composite3, string, (IActionBars)actionBarWrapper, this.defaultPlotType, (IWorkbenchPart)this);
        if (toolBarManager2 != null) {
            Action action = new Action("", Activator.getImageDescriptor("/icons/DropDown.png")){

                public void run() {
                    Menu menu = menuManager.createContextMenu((Control)toolBar);
                    menu.setVisible(true);
                }
            };
            toolBarManager2.add((IAction)action);
        }
        if (toolBarManager != null) {
            toolBarManager.update(true);
        }
        if (toolBarManager2 != null) {
            toolBarManager2.update(true);
        }
        this.createData(this.getEditorInput());
        if (EclipseUtils.getActivePage() != null) {
            try {
                EclipseUtils.getActivePage().showView("org.dawb.workbench.views.dataSetView", null, 1);
            }
            catch (PartInitException partInitException) {
                logger.error("Cannot open org.dawb.workbench.views.dataSetView");
            }
        }
        this.getEditorSite().setSelectionProvider(this.plottingSystem.getSelectionProvider());
    }

    public void createPlotTypeDefaultFromData() {
        boolean bl = false;
        PlotDataComponent plotDataComponent = this.getDataSetComponent();
        if (plotDataComponent != null) {
            for (CheckableObject checkableObject : plotDataComponent.getData()) {
                if (plotDataComponent.getDimensionCount(checkableObject) != 1) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.getPlottingSystem().setDefaultPlotType(PlotType.IMAGE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updatePlot(final CheckableObject[] checkableObjectArray, final IPlotUpdateParticipant iPlotUpdateParticipant, boolean bl) {
        if (this.doingUpdate) {
            return;
        }
        if ((checkableObjectArray == null || checkableObjectArray.length < 1) && iPlotUpdateParticipant != null) {
            iPlotUpdateParticipant.setSlicerVisible(false);
        }
        try {
            this.doingUpdate = true;
            if (checkableObjectArray == null || checkableObjectArray.length < 1) {
                this.plottingSystem.reset();
                return;
            }
            if (checkableObjectArray.length == 1 && iPlotUpdateParticipant.getDimensionCount(checkableObjectArray[0]) != 1) {
                iPlotUpdateParticipant.setSlicerVisible(true);
                iPlotUpdateParticipant.setSlicerData(checkableObjectArray[0].toString(), EclipseUtils.getFilePath((IEditorInput)this.getEditorInput()), (int[])iPlotUpdateParticipant.getMetaData().getDataShapes().get(checkableObjectArray[0].toString()), this.plottingSystem);
                return;
            }
            iPlotUpdateParticipant.setSlicerVisible(false);
            if (bl) {
                IProgressService iProgressService = this.getEditorSite() != null ? (IProgressService)this.getSite().getService(IProgressService.class) : (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
                try {
                    iProgressService.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            iProgressMonitor.beginTask("Updating selected DataSets", 100);
                            PlotDataEditor.this.createPlot(checkableObjectArray, iPlotUpdateParticipant, iProgressMonitor);
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    logger.error("Cannot create plot required.", (Throwable)exception);
                }
                return;
            } else {
                this.createPlot(checkableObjectArray, iPlotUpdateParticipant, (IProgressMonitor)new NullProgressMonitor());
            }
            return;
        }
        finally {
            this.doingUpdate = false;
        }
    }

    private void createPlot(Object[] objectArray, IPlotUpdateParticipant iPlotUpdateParticipant, IProgressMonitor iProgressMonitor) {
        AbstractDataset abstractDataset = this.getDataSet(objectArray[0], iProgressMonitor);
        ArrayList<AbstractDataset> arrayList = null;
        if (objectArray.length > 1) {
            arrayList = new ArrayList<AbstractDataset>(3);
            int n = 1;
            while (n < objectArray.length) {
                arrayList.add(this.getDataSet(objectArray[n], iProgressMonitor));
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                iProgressMonitor.worked(1);
                ++n;
            }
        }
        this.plottingSystem.clear();
        if (iPlotUpdateParticipant.getPlotMode() == PlotType.IMAGE) {
            this.plottingSystem.createPlot2D(abstractDataset, arrayList, iProgressMonitor);
        } else {
            this.plottingSystem.createPlot1D(abstractDataset, arrayList, iProgressMonitor);
        }
        iProgressMonitor.done();
    }

    public AbstractDataset getDataSet(String string, IMonitor iMonitor) {
        try {
            AbstractDataset abstractDataset;
            if (this.dataCache != null && this.dataCache.containsKey(string)) {
                return (AbstractDataset)this.dataCache.get(string);
            }
            if (this.dataCache != null) {
                if (this.dataCache.isEmpty()) {
                    DataHolder dataHolder = LoaderFactory.getData((String)EclipseUtils.getFilePath((IEditorInput)this.getEditorInput()), (IMonitor)iMonitor);
                    this.dataCache.putAll(dataHolder.getMap());
                }
                abstractDataset = (AbstractDataset)this.dataCache.get(string);
            } else {
                abstractDataset = LoaderFactory.getDataSet((String)EclipseUtils.getFilePath((IEditorInput)this.getEditorInput()), (String)string, (IMonitor)iMonitor);
            }
            if (abstractDataset != null) {
                abstractDataset.setName(string);
            }
            return abstractDataset;
        }
        catch (Exception exception) {
            logger.error("Cannot read " + string);
            return null;
        }
    }

    public AbstractDataset getExpressionSet(String string, IMonitor iMonitor) {
        throw new NullPointerException("Expressions are not supported by " + this.getClass().getName());
    }

    public boolean isDataSetName(String string, IMonitor iMonitor) {
        if (this.dataNames == null) {
            return false;
        }
        return this.dataNames.contains(string);
    }

    public boolean isExpressionSetName(String string, IMonitor iMonitor) {
        throw new NullPointerException("Expressions are not supported by " + this.getClass().getName());
    }

    private AbstractDataset getDataSet(Object object, IProgressMonitor iProgressMonitor) {
        Object object2 = object;
        if (object instanceof CheckableObject) {
            CheckableObject checkableObject = (CheckableObject)object;
            Object object3 = object2 = checkableObject.isExpression() ? checkableObject.getExpression() : checkableObject.getName();
        }
        if (object2 instanceof ExpressionObject) {
            try {
                return ((ExpressionObject)object2).getDataSet(iProgressMonitor);
            }
            catch (Exception exception) {
                return new DoubleDataset();
            }
        }
        return this.getDataSet((String)object2, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
    }

    @Override
    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        if (this.dataCache != null) {
            this.dataCache.clear();
        }
        this.extractingMetaData = true;
        Job job = new Job("Extract Meta Data"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                String string = EclipseUtils.getFilePath((IEditorInput)PlotDataEditor.this.getEditorInput());
                try {
                    try {
                        PlotDataEditor.this.metaData = LoaderFactory.getMetaData((String)string, null);
                        if (PlotDataEditor.this.metaData == null || PlotDataEditor.this.metaData.getDataNames() == null) {
                            DataHolder dataHolder = LoaderFactory.getData((String)string, null);
                            if (dataHolder == null) {
                                dataHolder = new DataHolder();
                            }
                            PlotDataEditor.this.dataNames = dataHolder.getMap().keySet();
                        } else {
                            PlotDataEditor.this.dataNames = PlotDataEditor.this.metaData.getDataNames();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Cannot generate meta data!", (Throwable)exception);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        PlotDataEditor.this.extractingMetaData = false;
                        return iStatus;
                    }
                }
                finally {
                    PlotDataEditor.this.extractingMetaData = false;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        this.createData(iEditorInput);
    }

    public void setAll1DSelected(boolean bl) {
        PlotDataComponent plotDataComponent = this.getDataSetComponent();
        plotDataComponent.setAll1DSelected(bl);
    }

    private void createData(IEditorInput iEditorInput) {
        UIJob uIJob = new UIJob("Update data"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                PlotDataComponent plotDataComponent = PlotDataEditor.this.getDataSetComponent();
                if (plotDataComponent == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    int n = 0;
                    while (PlotDataEditor.this.extractingMetaData) {
                        Thread.sleep(100L);
                        if ((n += 100) < 240000) continue;
                        System.out.println("Cannot extract meta data from " + EclipseUtils.getFilePath((IEditorInput)PlotDataEditor.this.getEditorInput()));
                        return Status.CANCEL_STATUS;
                    }
                    plotDataComponent.setMetaData(PlotDataEditor.this.metaData);
                    plotDataComponent.refresh();
                    PlotDataEditor.this.plottingSystem.setRootName(plotDataComponent.getRootName());
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    logger.error("Cannot open nexus", (Throwable)exception);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        uIJob.setUser(false);
        uIJob.schedule(10L);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.plottingSystem != null) {
            this.plottingSystem.dispose();
        }
        super.dispose();
    }

    public PlotDataComponent getDataSetComponent() {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        PlotDataView plotDataView = (PlotDataView)iWorkbenchPage.findView("org.dawb.workbench.views.dataSetView");
        if (plotDataView == null) {
            return null;
        }
        IPage iPage = plotDataView.getCurrentPage();
        if (!(iPage instanceof PlotDataPage)) {
            return null;
        }
        return ((PlotDataPage)iPage).getDataSetComponent();
    }

    public SliceComponent getSliceComponent() {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        PlotDataView plotDataView = (PlotDataView)iWorkbenchPage.findView("org.dawb.workbench.views.dataSetView");
        if (plotDataView == null) {
            return null;
        }
        IPage iPage = plotDataView.getCurrentPage();
        if (!(iPage instanceof PlotDataPage)) {
            return null;
        }
        return ((PlotDataPage)iPage).getSliceComponent();
    }

    public IPlottingSystem getPlotWindow() {
        return this.plottingSystem;
    }

    public AbstractPlottingSystem getPlottingSystem() {
        return this.plottingSystem;
    }

    public PlotDataEditor getDataSetEditor() {
        return this;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            PlotDataEditor plotDataEditor = this.getDataSetEditor();
            return new PlotDataPage(plotDataEditor);
        }
        if (clazz == IToolPageSystem.class) {
            return this.getPlottingSystem();
        }
        return super.getAdapter(clazz);
    }

    public void deleteExpression() {
        this.getDataSetComponent().deleteExpression();
    }

    public void addExpression() {
        this.getDataSetComponent().addExpression();
    }

    public String toString() {
        if (this.getEditorInput() != null) {
            return this.getEditorInput().getName();
        }
        return super.toString();
    }
}

