/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.dawb.common.ui.DawbUtils;
import org.dawb.common.ui.monitor.ProgressMonitorWrapper;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystemData;
import org.dawb.common.ui.plot.IPlottingSystemSelection;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.trace.ITraceListener;
import org.dawb.common.ui.plot.trace.TraceEvent;
import org.dawb.common.ui.widgets.DoubleClickModifier;
import org.dawb.common.util.io.PropUtils;
import org.dawb.common.util.io.SortingUtils;
import org.dawb.common.util.list.SortNatural;
import org.dawb.gda.extensions.util.DatasetTitleUtils;
import org.dawb.workbench.ui.Activator;
import org.dawb.workbench.ui.editors.CheckableObject;
import org.dawb.workbench.ui.editors.DataFilter;
import org.dawb.workbench.ui.editors.slicing.ExpressionObject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.monitor.IMonitor;

public class PlotDataComponent
implements IPlottingSystemData,
MouseListener,
KeyListener,
IPlottingSystemSelection {
    private static final Logger logger = LoggerFactory.getLogger(PlotDataComponent.class);
    public static final String ID = "uk.ac.gda.views.nexus.NexusPlotView";
    protected TableViewer dataViewer;
    protected List<CheckableObject> data;
    protected String filePath;
    protected String fileName;
    private String rootName;
    private boolean staggerSupported = false;
    protected IMetaData metaData;
    protected final IPlottingSystemData providerDeligate;
    private IPropertyChangeListener propListener;
    private ArrayList<IAction> dataComponentActions;
    private Composite container;
    private DataFilter dataFilter;
    private List<CheckableObject> selections = new ArrayList<CheckableObject>(7);
    private List<ISelectionChangedListener> listeners;
    private PlotType plotMode = PlotType.PT1D;
    private List<PlotModeListener> plotModeListeners;
    private AbstractDataset datasetSelection = null;

    public PlotDataComponent(IPlottingSystemData iPlottingSystemData) {
        this.data = new ArrayList<CheckableObject>(7);
        this.providerDeligate = iPlottingSystemData;
        this.propListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("ignore.data.set.filters")) {
                    if (PlotDataComponent.this.filePath == null) {
                        return;
                    }
                    IProgressService iProgressService = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
                    try {
                        iProgressService.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    PlotDataComponent.this.setFile((this).PlotDataComponent.this.filePath, iProgressMonitor);
                                }
                                catch (Exception exception) {
                                    throw new InvocationTargetException(exception);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        logger.error("Unable to refresh data set list", (Throwable)exception);
                    }
                } else if (propertyChangeEvent.getProperty().equals("show.xy.column.in.nexus.editor")) {
                    PlotDataComponent.this.setColumnVisible(1, 24, (Boolean)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getProperty().equals("show.data.size.in.nexus.editor")) {
                    PlotDataComponent.this.setColumnVisible(2, 100, (Boolean)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getProperty().equals("show.dims.in.nexus.editor")) {
                    PlotDataComponent.this.setColumnVisible(3, 100, (Boolean)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getProperty().equals("show.shape.in.nexus.editor")) {
                    PlotDataComponent.this.setColumnVisible(4, 100, (Boolean)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getProperty().equals("show.variable.name.in.nexus.editor")) {
                    PlotDataComponent.this.setColumnVisible(5, 100, (Boolean)propertyChangeEvent.getNewValue());
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propListener);
    }

    public Composite getControl() {
        return this.container;
    }

    protected void setColumnVisible(int n, int n2, boolean bl) {
        if (this.dataViewer == null || this.dataViewer.getControl().isDisposed()) {
            return;
        }
        this.dataViewer.getTable().getColumn(n).setWidth(bl ? n2 : 0);
        this.dataViewer.getTable().getColumn(n).setResizable(bl);
    }

    public void createPartControl(final Composite composite) {
        this.container = new Composite(composite, 0);
        if (composite.getLayout() instanceof GridLayout) {
            this.container.setLayoutData((Object)new GridData(1808));
        }
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.container.setLayout((Layout)gridLayout);
        final Text text = new Text(this.container, 2436);
        text.setLayoutData((Object)new GridData(768));
        text.setToolTipText("Search on data set name or expression value.");
        this.dataViewer = new TableViewer(this.container, 268503812);
        this.dataViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.dataViewer.getTable().addMouseListener((MouseListener)this);
        this.dataViewer.getTable().addKeyListener((KeyListener)this);
        this.dataViewer.getTable().setLinesVisible(true);
        this.dataViewer.getTable().setHeaderVisible(true);
        this.createColumns();
        this.dataViewer.setColumnProperties(new String[]{"Data", "Length"});
        this.dataViewer.setCellEditors(this.createCellEditors(this.dataViewer));
        this.dataViewer.setCellModifier(this.createModifier(this.dataViewer));
        this.dataViewer.getTable().setItemCount(this.data.size());
        this.dataViewer.setUseHashlookup(true);
        this.dataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return PlotDataComponent.this.data.toArray(new Object[PlotDataComponent.this.data.size()]);
            }
        });
        this.dataViewer.setInput((Object)new String());
        this.createRightClickMenu();
        this.setColumnVisible(1, 24, Activator.getDefault().getPreferenceStore().getBoolean("show.xy.column.in.nexus.editor"));
        this.setColumnVisible(2, 100, Activator.getDefault().getPreferenceStore().getBoolean("show.data.size.in.nexus.editor"));
        this.setColumnVisible(3, 100, Activator.getDefault().getPreferenceStore().getBoolean("show.dims.in.nexus.editor"));
        this.setColumnVisible(4, 100, Activator.getDefault().getPreferenceStore().getBoolean("show.shape.in.nexus.editor"));
        this.setColumnVisible(5, 100, Activator.getDefault().getPreferenceStore().getBoolean("show.variable.name.in.nexus.editor"));
        this.getPlottingSystem().addTraceListener((ITraceListener)new ITraceListener.Stub(){

            public void tracesAltered(TraceEvent traceEvent) {
                PlotDataComponent.this.updateSelection();
            }
        });
        this.dataFilter = new DataFilter();
        this.dataViewer.addFilter((ViewerFilter)this.dataFilter);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (composite.isDisposed()) {
                    return;
                }
                PlotDataComponent.this.dataFilter.setSearchText(text.getText());
                PlotDataComponent.this.dataViewer.refresh();
            }
        });
    }

    public void setFocus() {
        if (this.dataViewer != null && !this.dataViewer.getControl().isDisposed()) {
            this.dataViewer.getControl().setFocus();
        }
    }

    private void saveExpressions() {
        try {
            Properties properties = new Properties();
            for (CheckableObject object2 : this.data) {
                if (!object2.isExpression()) continue;
                ExpressionObject expressionObject = object2.getExpression();
                properties.setProperty(expressionObject.getMementoKey(), expressionObject.getExpression());
            }
            String string = String.valueOf(DawbUtils.getDawbHome()) + this.getFileName() + ".properties";
            PropUtils.storeProperties((Properties)properties, (String)string);
        }
        catch (Exception exception) {
            logger.error("Cannot save expression", (Throwable)exception);
        }
    }

    private void readExpressions() throws Exception {
        String string = String.valueOf(DawbUtils.getDawbHome()) + this.getFileName() + ".properties";
        Properties properties = PropUtils.loadProperties((String)string);
        if (properties != null) {
            try {
                for (Object object : properties.keySet()) {
                    String string2 = object.toString();
                    if (!ExpressionObject.isExpressionKey(string2)) continue;
                    CheckableObject checkableObject = new CheckableObject();
                    checkableObject.setExpression(new ExpressionObject(this, properties.getProperty(string2), string2));
                    this.data.add(checkableObject);
                }
            }
            catch (Exception exception) {
                throw new PartInitException(exception.getMessage());
            }
        }
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.dataViewer.getControl().setMenu(menuManager.createContextMenu(this.dataViewer.getControl()));
        this.createDimensionalActions((IContributionManager)menuManager, false);
        menuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "sep1"));
        menuManager.add((IAction)new Action("Preferences..."){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.edna.workbench.editors.preferencePage", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        });
    }

    private void createColumns() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dataViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.dataViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Name");
        tableViewerColumn.getColumn().setWidth(180);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(0));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.dataViewer, 16384, 1);
        tableViewerColumn2.getColumn().setText(" ");
        tableViewerColumn2.getColumn().setWidth(24);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(1));
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(this.dataViewer, 16384, 2);
        tableViewerColumn3.getColumn().setText("Size");
        tableViewerColumn3.getColumn().setWidth(150);
        tableViewerColumn3.getColumn().setResizable(true);
        tableViewerColumn3.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(2));
        TableViewerColumn tableViewerColumn4 = new TableViewerColumn(this.dataViewer, 16384, 3);
        tableViewerColumn4.getColumn().setText("Dimensions");
        tableViewerColumn4.getColumn().setWidth(150);
        tableViewerColumn4.getColumn().setResizable(true);
        tableViewerColumn4.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(3));
        TableViewerColumn tableViewerColumn5 = new TableViewerColumn(this.dataViewer, 16384, 4);
        tableViewerColumn5.getColumn().setText("Shape");
        tableViewerColumn5.getColumn().setWidth(150);
        tableViewerColumn5.getColumn().setResizable(true);
        tableViewerColumn5.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(4));
        TableViewerColumn tableViewerColumn6 = new TableViewerColumn(this.dataViewer, 16384, 5);
        tableViewerColumn6.getColumn().setText("Variable");
        tableViewerColumn6.getColumn().setWidth(150);
        tableViewerColumn6.getColumn().setResizable(true);
        tableViewerColumn6.setLabelProvider((CellLabelProvider)new DataSetColumnLabelProvider(5));
    }

    private CellEditor[] createCellEditors(TableViewer tableViewer) {
        CellEditor[] cellEditorArray = new CellEditor[1];
        TextCellEditor textCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        ((Text)textCellEditor.getControl()).setTextLimit(60);
        cellEditorArray[0] = textCellEditor;
        return cellEditorArray;
    }

    private ICellModifier createModifier(TableViewer tableViewer) {
        return new DoubleClickModifier((ColumnViewer)tableViewer){

            public boolean canModify(Object object, String string) {
                if (!this.enabled) {
                    return false;
                }
                return object instanceof CheckableObject && ((CheckableObject)object).isExpression() && "Data".equalsIgnoreCase(string);
            }

            public Object getValue(Object object, String string) {
                String string2 = ((CheckableObject)object).getExpression().getExpression();
                return string2 != null ? string2 : "";
            }

            public void modify(Object object, String string, Object object2) {
                try {
                    try {
                        CheckableObject checkableObject = (CheckableObject)((IStructuredSelection)PlotDataComponent.this.dataViewer.getSelection()).getFirstElement();
                        ExpressionObject expressionObject = checkableObject.getExpression();
                        expressionObject.setExpression((String)object2);
                        checkableObject.setChecked(true);
                        PlotDataComponent.this.dataViewer.refresh();
                        PlotDataComponent.this.saveExpressions();
                    }
                    catch (Exception exception) {
                        logger.error("Cannot set " + string, (Throwable)exception);
                        this.setEnabled(false);
                    }
                }
                finally {
                    this.setEnabled(false);
                }
            }
        };
    }

    private void createDimensionalActions(IContributionManager iContributionManager, boolean bl) {
        Action action;
        Action action2;
        Action action3;
        this.dataComponentActions = new ArrayList(11);
        Action action4 = new Action("Configure column preferences...", Activator.getImageDescriptor("icons/application_view_columns.png")){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.edna.workbench.editors.preferencePage", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        if (this.staggerSupported) {
            action3 = new Action("XY Plot", 2){

                public void run() {
                    PlotDataComponent.this.setPlotMode(PlotType.PT1D);
                }
            };
            action3.setImageDescriptor(Activator.getImageDescriptor("/icons/chart_curve.png"));
            action3.setToolTipText("XY Graph of Data, overlayed for multiple data.");
            this.dataComponentActions.add((IAction)action3);
            action2 = new Action("XY Staggered in Z", 2){

                public void run() {
                    PlotDataComponent.this.setPlotMode(PlotType.PT1D_STACKED);
                }
            };
            action2.setImageDescriptor(Activator.getImageDescriptor("/icons/chart_curve_staggered.png"));
            action2.setToolTipText("XY Graph of Data, staggered in Z for multiple data.");
            this.dataComponentActions.add((IAction)action2);
            action = new Action("XYZ", 2){

                public void run() {
                    PlotDataComponent.this.setPlotMode(PlotType.PT1D_3D);
                }
            };
            action.setImageDescriptor(Activator.getImageDescriptor("/icons/chart_curve_3D.png"));
            action.setToolTipText("XYZ, X is the first chosen data and Z the last.");
            this.dataComponentActions.add((IAction)action);
            iContributionManager.add((IContributionItem)new Separator());
            iContributionManager.add((IAction)action3);
            iContributionManager.add((IAction)action2);
            iContributionManager.add((IAction)action);
            iContributionManager.add((IContributionItem)new Separator());
            this.addPlotModeListener(new PlotModeListener(){

                @Override
                public void plotChangePerformed(PlotType plotType) {
                    PlotDataComponent.this.updatePlotDimenionsSelected(action3, action2, action, plotType);
                    PlotDataComponent.this.updateSelection();
                }
            });
            final Display display = PlatformUI.getWorkbench().getDisplay();
            if (bl) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlotDataComponent.this.updatePlotDimenionsSelected(action3, action2, action, PlotDataComponent.this.getPlotMode());
                    }
                });
            } else {
                MenuManager menuManager = (MenuManager)iContributionManager;
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager iMenuManager) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PlotDataComponent.this.updatePlotDimenionsSelected(action3, action2, action, PlotDataComponent.this.getPlotMode());
                            }
                        });
                    }
                });
            }
        }
        action3 = new Action("Set Selected Set as X-Axis"){

            public void run() {
                CheckableObject checkableObject = (CheckableObject)((IStructuredSelection)PlotDataComponent.this.dataViewer.getSelection()).getFirstElement();
                if (checkableObject == null) {
                    return;
                }
                if (PlotDataComponent.this.getDimensionCount(checkableObject) != 1) {
                    return;
                }
                checkableObject.setChecked(true);
                if (PlotDataComponent.this.selections.contains(checkableObject)) {
                    PlotDataComponent.this.selections.remove(checkableObject);
                }
                PlotDataComponent.this.selections.add(0, checkableObject);
                PlotDataComponent.this.getPlottingSystem().setXfirst(true);
                PlotDataComponent.this.updateSelection();
                PlotDataComponent.this.dataViewer.refresh((Object)checkableObject);
            }
        };
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/to_x.png"));
        action3.setToolTipText("Changes the plot to use selected data set as the x-axis.");
        this.dataComponentActions.add((IAction)action3);
        iContributionManager.add((IAction)action3);
        iContributionManager.add((IContributionItem)new Separator());
        action2 = new Action("Add Expression"){

            public void run() {
                ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                try {
                    iCommandService.getCommand("org.dawb.workbench.editors.addExpression").executeWithChecks(new ExecutionEvent());
                }
                catch (Exception exception) {
                    logger.error("Cannot run action", (Throwable)exception);
                }
            }
        };
        action2.setImageDescriptor(Activator.getImageDescriptor("/icons/add_expression.png"));
        action2.setToolTipText("Adds an expression which can be plotted. Must be function of other data sets.");
        this.dataComponentActions.add((IAction)action2);
        iContributionManager.add((IAction)action2);
        action = new Action("Delete Expression"){

            public void run() {
                ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                try {
                    iCommandService.getCommand("org.dawb.workbench.editors.deleteExpression").executeWithChecks(new ExecutionEvent());
                }
                catch (Exception exception) {
                    logger.error("Cannot run action", (Throwable)exception);
                }
            }
        };
        action.setImageDescriptor(Activator.getImageDescriptor("/icons/delete_expression.png"));
        action.setToolTipText("Deletes an expression.");
        this.dataComponentActions.add((IAction)action);
        iContributionManager.add((IAction)action);
        this.dataComponentActions.add((IAction)action4);
    }

    public List<IAction> getDimensionalActions() {
        return this.dataComponentActions;
    }

    protected void updatePlotDimenionsSelected(Action action, Action action2, Action action3, PlotType plotType) {
        action.setChecked(PlotType.PT1D.equals((Object)plotType));
        action2.setChecked(PlotType.PT1D_STACKED.equals((Object)plotType));
        action3.setChecked(PlotType.PT1D_3D.equals((Object)plotType));
    }

    public void setFile(String string, IProgressMonitor iProgressMonitor) throws Exception {
        Object object2;
        iProgressMonitor.beginTask("Opening file " + string, 10);
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        IMetaData iMetaData = LoaderFactory.getMetaData((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        ArrayList arrayList = new ArrayList(iMetaData.getDataNames());
        SortingUtils.removeIgnoredNames(arrayList, PlotDataComponent.getIgnored());
        Collections.sort(arrayList, new SortNatural(true));
        this.metaData = iMetaData;
        if (this.dataFilter != null) {
            this.dataFilter.setMetaData(this.metaData);
        }
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        Iterator<CheckableObject> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!((CheckableObject)object2).isExpression()) {
                iterator.remove();
                continue;
            }
            ((CheckableObject)object2).getExpression().clear();
        }
        int n = 0;
        for (Object object2 : arrayList) {
            this.data.add(n, new CheckableObject((String)object2));
            ++n;
        }
        this.filePath = string;
        try {
            this.readExpressions();
        }
        catch (Exception exception) {
            logger.error("Cannot read expressions for file.", (Throwable)exception);
        }
        object2 = PlatformUI.getWorkbench().getDisplay();
        object2.asyncExec(new Runnable(){

            @Override
            public void run() {
                PlotDataComponent.this.dataViewer.refresh();
            }
        });
    }

    public List<CheckableObject> getSelections() {
        return this.selections;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 13) {
            this.selectionChanged((CheckableObject)((IStructuredSelection)this.dataViewer.getSelection()).getFirstElement());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        TableItem tableItem;
        if (mouseEvent.button == 1 && (tableItem = this.dataViewer.getTable().getItem(new Point(mouseEvent.x, mouseEvent.y))) != null) {
            this.selectionChanged((CheckableObject)tableItem.getData());
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    protected void selectionChanged(CheckableObject checkableObject) {
        if (this.selections == null) {
            this.selections = new ArrayList<CheckableObject>(7);
        }
        if (checkableObject != null) {
            int n;
            checkableObject.setChecked(!checkableObject.isChecked());
            if (!checkableObject.isChecked()) {
                this.selections.remove(checkableObject);
            } else {
                n = this.getDimensionCount(checkableObject);
                if (n != 1) {
                    this.setAllChecked(false);
                    checkableObject.setChecked(true);
                    this.selections.clear();
                }
                if (!this.selections.contains(checkableObject)) {
                    this.selections.add(checkableObject);
                }
            }
            n = 0;
            for (CheckableObject object : this.selections) {
                if (this.getDimensionCount(object) != 1) continue;
                n = 1;
            }
            if (n != 0) {
                Iterator<CheckableObject> iterator = this.selections.iterator();
                while (iterator.hasNext()) {
                    CheckableObject checkableObject2 = iterator.next();
                    if (this.getDimensionCount(checkableObject2) == 1) continue;
                    checkableObject2.setChecked(false);
                    iterator.remove();
                }
            }
        } else {
            this.selections.clear();
        }
        this.updateSelection();
        this.dataViewer.refresh();
    }

    private synchronized void updateSelection() {
        if (this.selections == null) {
            return;
        }
        this.fireSelectionListeners(this.selections);
    }

    public void setAll1DSelected(boolean bl) {
        if (!bl && this.getSelections() != null && this.getSelections().size() > 0) {
            return;
        }
        this.selections.clear();
        for (CheckableObject checkableObject : this.data) {
            if (this.getDimensionCount(checkableObject) != 1) continue;
            this.selections.add(checkableObject);
            checkableObject.setChecked(true);
        }
        this.updateSelection();
        this.dataViewer.refresh();
    }

    public void addSelectionListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionChangedListener>(7);
        }
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(iSelectionChangedListener);
    }

    private void fireSelectionListeners(List<CheckableObject> list) {
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this.dataViewer, (ISelection)new StructuredSelection(list));
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public String getRootName() {
        return this.rootName;
    }

    public PlotType getPlotMode() {
        return this.plotMode;
    }

    public void setPlotMode(PlotType plotType) {
        this.plotMode = plotType;
        if (this.plotModeListeners != null) {
            for (PlotModeListener plotModeListener : this.plotModeListeners) {
                plotModeListener.plotChangePerformed(plotType);
            }
        }
    }

    protected void addPlotModeListener(PlotModeListener plotModeListener) {
        if (this.plotModeListeners == null) {
            this.plotModeListeners = new ArrayList<PlotModeListener>(7);
        }
        this.plotModeListeners.add(plotModeListener);
    }

    protected void removePlotModeListener(PlotModeListener plotModeListener) {
        if (this.plotModeListeners == null) {
            return;
        }
        this.plotModeListeners.remove(plotModeListener);
    }

    private List<String> getStringSelections(List<CheckableObject> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (CheckableObject checkableObject : list) {
            if (checkableObject.isExpression()) continue;
            arrayList.add(checkableObject.getName());
        }
        return arrayList;
    }

    public AbstractDataset getDataSet(String string, IMonitor iMonitor) {
        block5: {
            if (this.providerDeligate != null) {
                return this.providerDeligate.getDataSet(string, iMonitor);
            }
            if (this.filePath != null) break block5;
            return null;
        }
        try {
            return LoaderFactory.getDataSet((String)this.filePath, (String)string, (IMonitor)iMonitor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (Exception exception) {
            logger.error("Cannot get data set " + string + " from " + this.filePath + ". Currently expressions can only contain existing Data Sets.", (Throwable)exception);
            return null;
        }
    }

    public AbstractDataset getExpressionSet(String string, IMonitor iMonitor) {
        AbstractDataset abstractDataset = this.getDataSet(string, iMonitor);
        if (abstractDataset == null) {
            List<String> list = this.getStringSelections(this.data);
            for (String string2 : list) {
                if (!ExpressionObject.getSafeName(string2).equals(string)) continue;
                abstractDataset = this.getDataSet(string2, iMonitor);
            }
        }
        return abstractDataset;
    }

    public boolean isDataSetName(String string, IMonitor iMonitor) {
        List<String> list = this.getStringSelections(this.data);
        return list.contains(string);
    }

    public boolean isExpressionSetName(String string, IMonitor iMonitor) {
        if (this.isDataSetName(string, iMonitor)) {
            return true;
        }
        List<String> list = this.getStringSelections(this.data);
        for (String string2 : list) {
            if (!ExpressionObject.getSafeName(string2).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propListener);
        this.datasetSelection = null;
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.data != null) {
            this.data.clear();
        }
        if (this.plotModeListeners != null) {
            this.plotModeListeners.clear();
        }
        if (this.dataViewer != null && !this.dataViewer.getControl().isDisposed()) {
            this.dataViewer.getTable().removeMouseListener((MouseListener)this);
            this.dataViewer.getTable().removeKeyListener((KeyListener)this);
        }
    }

    public int getDimensionCount(CheckableObject checkableObject) {
        if (!checkableObject.isExpression()) {
            String string = checkableObject.getName();
            if (this.metaData.getDataShapes() == null) {
                AbstractDataset abstractDataset = this.getDataSet(string, null);
                if (abstractDataset != null) {
                    return abstractDataset.getShape().length;
                }
                return 1;
            }
            if (this.metaData.getDataShapes().get(string) != null) {
                return ((int[])this.metaData.getDataShapes().get(string)).length;
            }
        }
        return 1;
    }

    public void addExpression() {
        CheckableObject checkableObject = new CheckableObject(new ExpressionObject(this));
        this.data.add(checkableObject);
        this.dataViewer.refresh();
        ((DoubleClickModifier)this.dataViewer.getCellModifier()).setEnabled(true);
        this.dataViewer.editElement((Object)checkableObject, 0);
    }

    protected void addExpression(ExpressionObject expressionObject) {
        this.data.add(new CheckableObject(expressionObject));
        this.dataViewer.refresh();
    }

    public void deleteExpression() {
        Object object = ((IStructuredSelection)this.dataViewer.getSelection()).getFirstElement();
        if (object == null || !(object instanceof CheckableObject)) {
            return;
        }
        if (!((CheckableObject)object).isExpression()) {
            return;
        }
        this.data.remove(object);
        this.dataViewer.refresh();
        this.saveExpressions();
    }

    public static List<Pattern> getIgnored() {
        IConfigurationElement[] iConfigurationElementArray;
        if (Activator.getDefault().getPreferenceStore().getBoolean("ignore.data.set.filters")) {
            return null;
        }
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>(5);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.diamond.scisoft.analysis.data.set.filter");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            String string = iConfigurationElement.getAttribute("regularExpression");
            arrayList.add(Pattern.compile(string));
            ++n2;
        }
        return arrayList;
    }

    public void setMetaData(IMetaData iMetaData) {
        if (iMetaData == null) {
            return;
        }
        this.data.clear();
        Collection collection = iMetaData.getDataNames();
        for (String string : collection) {
            this.data.add(new CheckableObject(string));
        }
        this.rootName = DatasetTitleUtils.getRootName((Collection)collection);
        iMetaData.getUserObjects();
        this.metaData = iMetaData;
        if (this.dataFilter != null) {
            this.dataFilter.setMetaData(this.metaData);
        }
        try {
            this.readExpressions();
        }
        catch (Exception exception) {
            logger.error("Cannot read expressions for file.", (Throwable)exception);
        }
    }

    public void refresh() {
        this.dataViewer.refresh();
    }

    public List<Object> getExpressions(IPlottingSystemData iPlottingSystemData) {
        if (this.data == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        for (CheckableObject checkableObject : this.data) {
            if (!(checkableObject instanceof ExpressionObject)) continue;
            ExpressionObject expressionObject = (ExpressionObject)((Object)checkableObject);
            expressionObject = new ExpressionObject(iPlottingSystemData, expressionObject.getExpression(), expressionObject.getMementoKey());
            arrayList.add(expressionObject);
        }
        return arrayList;
    }

    public String getFileName() {
        if (this.filePath != null) {
            return new File(this.filePath).getName();
        }
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public AbstractDataset setDatasetSelected(final String string, final boolean bl) {
        this.datasetSelection = null;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    PlotDataComponent.this.setAllChecked(false);
                    PlotDataComponent.this.selectionChanged(null);
                }
                CheckableObject checkableObject = PlotDataComponent.this.getObjectByName(string);
                checkableObject.setChecked(false);
                PlotDataComponent.this.selectionChanged(checkableObject);
                PlotDataComponent.this.datasetSelection = PlotDataComponent.this.getDataSet(string, null);
            }
        });
        return this.datasetSelection;
    }

    protected void setAllChecked(boolean bl) {
        for (CheckableObject checkableObject : this.data) {
            checkableObject.setChecked(bl);
        }
    }

    protected CheckableObject getObjectByName(String string) {
        for (CheckableObject checkableObject : this.data) {
            if (!string.equals(checkableObject.getName())) continue;
            return checkableObject;
        }
        return null;
    }

    public IMetaData getMetaData() {
        return this.metaData;
    }

    public AbstractPlottingSystem getPlottingSystem() {
        return this.providerDeligate != null ? this.providerDeligate.getPlottingSystem() : null;
    }

    public boolean isStaggerSupported() {
        return this.staggerSupported;
    }

    public void setStaggerSupported(boolean bl) {
        this.staggerSupported = bl;
    }

    public List<CheckableObject> getData() {
        return this.data;
    }

    public ISelectionProvider getViewer() {
        return this.dataViewer;
    }

    private class DataSetColumnLabelProvider
    extends ColumnLabelProvider {
        private Color RED = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
        private Color BLUE = PlatformUI.getWorkbench().getDisplay().getSystemColor(9);
        private Color BLACK = PlatformUI.getWorkbench().getDisplay().getSystemColor(2);
        private Image checkedIcon;
        private Image uncheckedIcon;
        private int columnIndex;

        DataSetColumnLabelProvider(int n) {
            this.columnIndex = n;
            if (n == 0) {
                ImageDescriptor imageDescriptor = Activator.getImageDescriptor("icons/ticked.png");
                this.checkedIcon = imageDescriptor.createImage();
                imageDescriptor = Activator.getImageDescriptor("icons/unticked.gif");
                this.uncheckedIcon = imageDescriptor.createImage();
            }
        }

        public Image getImage(Object object) {
            if (this.columnIndex != 0) {
                return null;
            }
            CheckableObject checkableObject = (CheckableObject)object;
            return checkableObject.isChecked() ? this.checkedIcon : this.uncheckedIcon;
        }

        public String getText(Object object) {
            CheckableObject checkableObject = (CheckableObject)object;
            switch (this.columnIndex) {
                case 0: {
                    String string = checkableObject.toString();
                    if (!checkableObject.isExpression() && PlotDataComponent.this.rootName != null) {
                        string = string.substring(PlotDataComponent.this.rootName.length());
                    }
                    return string;
                }
                case 1: {
                    if (PlotDataComponent.this.selections != null && !PlotDataComponent.this.selections.isEmpty()) {
                        if (PlotDataComponent.this.selections.size() > 1 && PlotDataComponent.this.selections.contains(checkableObject)) {
                            if (PlotDataComponent.this.selections.indexOf(checkableObject) == 0) {
                                return "X";
                            }
                            if (PlotDataComponent.this.selections.size() > 2) {
                                return "Y" + PlotDataComponent.this.selections.indexOf(checkableObject);
                            }
                            return "Y";
                        }
                        if (PlotDataComponent.this.selections.size() == 1 && PlotDataComponent.this.selections.contains(checkableObject)) {
                            return "Y";
                        }
                    }
                    return "";
                }
                case 2: {
                    if (!checkableObject.isExpression()) {
                        String string = checkableObject.toString();
                        if (PlotDataComponent.this.metaData.getDataSizes() == null) {
                            AbstractDataset abstractDataset = PlotDataComponent.this.getDataSet(string, null);
                            if (abstractDataset != null) {
                                return String.valueOf(abstractDataset.getSize());
                            }
                            return "Unknown";
                        }
                        return "" + PlotDataComponent.this.metaData.getDataSizes().get(string);
                    }
                    return String.valueOf(checkableObject.getExpression().getSize((IProgressMonitor)new NullProgressMonitor()));
                }
                case 3: {
                    return String.valueOf(PlotDataComponent.this.getDimensionCount(checkableObject));
                }
                case 4: {
                    if (!checkableObject.isExpression()) {
                        String string = checkableObject.toString();
                        if (PlotDataComponent.this.metaData.getDataShapes() == null) {
                            AbstractDataset abstractDataset = PlotDataComponent.this.getDataSet(string, null);
                            if (abstractDataset != null) {
                                return Arrays.toString(abstractDataset.getShape());
                            }
                            return "Unknown";
                        }
                        return Arrays.toString((int[])PlotDataComponent.this.metaData.getDataShapes().get(string));
                    }
                    return "[" + checkableObject.getExpression().getSize((IProgressMonitor)new NullProgressMonitor()) + "]";
                }
                case 5: {
                    if (!checkableObject.isExpression()) {
                        return ExpressionObject.getSafeName(checkableObject.getName());
                    }
                    return "";
                }
            }
            return checkableObject.toString();
        }

        public Color getForeground(Object object) {
            CheckableObject checkableObject = (CheckableObject)object;
            switch (this.columnIndex) {
                case 0: {
                    if (!checkableObject.isExpression()) {
                        String string = checkableObject.toString();
                        if (PlotDataComponent.this.getPlottingSystem() != null) {
                            Color color = PlotDataComponent.this.getPlottingSystem().get1DPlotColor((Object)string);
                            return color;
                        }
                    } else {
                        ExpressionObject expressionObject = checkableObject.getExpression();
                        return expressionObject.isValid((IProgressMonitor)new NullProgressMonitor()) ? this.BLUE : this.RED;
                    }
                    return this.BLACK;
                }
                case 5: {
                    return this.BLUE;
                }
            }
            return this.BLACK;
        }
    }

    protected static interface PlotModeListener
    extends EventListener {
        public void plotChangePerformed(PlotType var1);
    }
}

