/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.views.HeaderTablePage;
import org.dawb.workbench.ui.editors.PlotImageEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageEditor
extends MultiPageEditorPart
implements IReusableEditor {
    public static final String ID = "org.dawb.workbench.editors.ImageEditor";
    private static final Logger logger = LoggerFactory.getLogger(ImageEditor.class);
    private PlotImageEditor plotImageEditor;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (this.plotImageEditor != null) {
            this.plotImageEditor.setInput(iEditorInput);
        }
    }

    protected void createPages() {
        try {
            this.plotImageEditor = new PlotImageEditor();
            this.addPage(0, (IEditorPart)this.plotImageEditor, this.getEditorInput());
            this.setPageText(0, "Image");
            if (System.getProperty("org.dawb.editor.ascii.hide.diamond.image.editor") == null) {
                uk.ac.diamond.scisoft.analysis.rcp.editors.ImageEditor imageEditor = new uk.ac.diamond.scisoft.analysis.rcp.editors.ImageEditor();
                this.addPage(1, (IEditorPart)imageEditor, this.getEditorInput());
                this.setPageText(1, "Info");
            }
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (EclipseUtils.getPage().findView("uk.ac.diamond.scisoft.analysis.rcp.views.DatasetInspectorView") != null && ImageEditor.this.getPageCount() >= 2) {
                        ImageEditor.this.setActivePage(1);
                    }
                }
            });
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot initiate " + ((Object)((Object)this)).getClass().getName() + "!", (Throwable)partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.getActiveEditor().isDirty()) {
            this.getActiveEditor().doSave(iProgressMonitor);
        }
    }

    public void doSaveAs() {
        if (this.getActiveEditor().isDirty()) {
            this.getActiveEditor().doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            return new HeaderTablePage(EclipseUtils.getFilePath((IEditorInput)this.getEditorInput()));
        }
        if (clazz == IToolPageSystem.class) {
            return this.plotImageEditor.getPlottingSystem();
        }
        return super.getAdapter(clazz);
    }

    public String toString() {
        if (this.getEditorInput() != null) {
            return this.getEditorInput().getName();
        }
        return super.toString();
    }
}

