/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystemSelection;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.slicing.ISlicablePlottingPart;
import org.dawb.common.ui.slicing.SliceComponent;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.hdf5.editor.H5Editor;
import org.dawb.hdf5.editor.H5ValuePage;
import org.dawb.hdf5.editor.IH5Editor;
import org.dawb.workbench.ui.editors.PlotDataComponent;
import org.dawb.workbench.ui.editors.PlotDataEditor;
import org.dawb.workbench.ui.views.PlotDataPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.editors.HDF5TreeEditor;

public class H5MultiEditor
extends MultiPageEditorPart
implements ISlicablePlottingPart,
IReusableEditor,
IPlottingSystemSelection,
IH5Editor {
    private static final Logger logger = LoggerFactory.getLogger(H5MultiEditor.class);
    private PlotDataEditor dataSetEditor;
    private IReusableEditor treePage;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        if (this.dataSetEditor != null) {
            this.dataSetEditor.setInput(iEditorInput);
        }
        if (this.treePage != null) {
            this.treePage.setInput(iEditorInput);
        }
    }

    protected void createPages() {
        try {
            this.dataSetEditor = new PlotDataEditor(false, PlotType.PT1D);
            this.dataSetEditor.getPlottingSystem().setColorOption(AbstractPlottingSystem.ColorOption.BY_NAME);
            this.addPage(0, this.dataSetEditor, this.getEditorInput());
            this.setPageText(0, "Plot");
            this.treePage = System.getProperty("org.dawb.editor.h5.use.default") != null ? new H5Editor() : new HDF5TreeEditor();
            this.addPage(1, (IEditorPart)this.treePage, this.getEditorInput());
            this.setPageText(1, "Tree");
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot initiate " + ((Object)((Object)this)).getClass().getName() + "!", (Throwable)partInitException);
        }
        try {
            EclipseUtils.getActivePage().showView("org.dawb.passerelle.views.ValueView");
        }
        catch (Throwable throwable) {}
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (H5MultiEditor.this.getDataSetComponent() != null && H5MultiEditor.this.getDataSetComponent().getMetaData() != null) {
                    if (H5MultiEditor.this.getDataSetComponent().getMetaData().getDataNames() == null || H5MultiEditor.this.getDataSetComponent().getMetaData().getDataNames().size() < 1) {
                        H5MultiEditor.this.setActivePage(1);
                    } else if (EclipseUtils.getPage().findView("uk.ac.diamond.scisoft.analysis.rcp.views.DatasetInspectorView") != null) {
                        H5MultiEditor.this.setActivePage(1);
                    }
                }
            }
        });
    }

    public void dispose() {
        this.dataSetEditor = null;
        this.treePage = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public PlotDataComponent getDataSetComponent() {
        return ((PlotDataEditor)this.getEditor(0)).getDataSetComponent();
    }

    public SliceComponent getSliceComponent() {
        return ((PlotDataEditor)this.getEditor(0)).getSliceComponent();
    }

    public void setActivePage(int n) {
        super.setActivePage(n);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public PlotDataEditor getDataSetEditor() {
        return this.dataSetEditor;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            PlotDataEditor plotDataEditor = this.getDataSetEditor();
            return new PlotDataPage(plotDataEditor);
        }
        if (clazz == IContentProvider.class) {
            return new H5ValuePage();
        }
        if (clazz == IToolPageSystem.class) {
            return this.dataSetEditor.getPlottingSystem();
        }
        return super.getAdapter(clazz);
    }

    public AbstractDataset setDatasetSelected(String string, boolean bl) {
        return this.getDataSetComponent().setDatasetSelected(string, bl);
    }

    public void setAll1DSelected(boolean bl) {
        this.getDataSetComponent().setAll1DSelected(bl);
    }

    public String getFilePath() {
        return EclipseUtils.getFilePath((IEditorInput)this.getEditorInput());
    }
}

