/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dawb.common.ui.util.CSVUtils;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.workbench.ui.Activator;
import org.dawb.workbench.ui.editors.IDatasetEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public class CSVDataEditor
extends EditorPart
implements IReusableEditor,
IPageChangedListener {
    private static Logger logger = LoggerFactory.getLogger(CSVDataEditor.class);
    private TableViewer tableViewer;
    private CLabel errorLabel;
    private Composite main;
    private Map<String, IDataset> data;
    private IDatasetEditor dataProvider;
    private IPropertyChangeListener propListener;

    public void setDataProvider(IDatasetEditor iDatasetEditor) {
        this.dataProvider = iDatasetEditor;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public void createPartControl(Composite composite) {
        this.main = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.main.setLayout((Layout)gridLayout);
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        ToolBar toolBar = toolBarManager.createControl(this.main);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.createActions((ContributionManager)toolBarManager);
        this.errorLabel = new CLabel(this.main, 0);
        this.errorLabel.setImage(Activator.getImage("icons/error.png"));
        this.errorLabel.setText("This editor shows the data plotted. Please plot at least one data set and view the data here.");
        this.errorLabel.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
        this.errorLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        toolBarManager.update(false);
        this.main.layout();
        this.propListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("data.format.editor.view") && CSVDataEditor.this.tableViewer != null) {
                    CSVDataEditor.this.tableViewer.refresh();
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propListener);
    }

    private void createActions(ContributionManager contributionManager) {
        Action action = new Action("Export current plotted data to csv file", 1){

            public void run() {
                CSVUtils.createCSV((IFile)EclipseUtils.getIFile((IEditorInput)CSVDataEditor.this.getEditorInput()), (Map)CSVDataEditor.this.data, (String)"_plot");
            }
        };
        action.setImageDescriptor(Activator.getImageDescriptor("icons/page_white_excel.png"));
        contributionManager.add((IAction)action);
        contributionManager.add((IContributionItem)new Separator(String.valueOf(((Object)((Object)this)).getClass().getName()) + "Sep1"));
        Action action2 = new Action("Preferences...", 1){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"uk.ac.diamond.scisoft.analysis.rcp.preferencePage", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        action2.setImageDescriptor(Activator.getImageDescriptor("icons/application_view_list.png"));
        contributionManager.add((IAction)action2);
    }

    private void update() {
        String string2;
        if (this.tableViewer != null) {
            GridUtils.setVisible((Control)this.tableViewer.getTable(), (boolean)false);
            this.tableViewer.getTable().dispose();
        }
        this.data = this.dataProvider.getSelected();
        if (this.data == null || this.data.isEmpty()) {
            GridUtils.setVisible((Control)this.errorLabel, (boolean)true);
            this.main.layout();
            return;
        }
        Table table = new Table(this.main, 2818);
        this.tableViewer = new TableViewer(table);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        GridUtils.setVisible((Control)this.errorLabel, (boolean)false);
        this.main.layout();
        boolean bl = this.data.size() == 1 && this.data.values().iterator().next().getShape().length == 2;
        int n = 0;
        for (String string2 : this.data.keySet()) {
            AbstractDataset abstractDataset = (AbstractDataset)this.data.get(string2);
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 131072, n);
            String string3 = abstractDataset.getName() != null ? abstractDataset.getName() : "";
            tableViewerColumn.getColumn().setText(string3);
            if (bl) {
                tableViewerColumn.setLabelProvider((CellLabelProvider)new BufferColumnProvider());
                tableViewerColumn.getColumn().setWidth(3000);
            } else {
                tableViewerColumn.setLabelProvider((CellLabelProvider)new ValueColumnProvider(n));
                tableViewerColumn.getColumn().setWidth(150);
            }
            ++n;
        }
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.data.keySet().toArray(new String[this.data.size()]));
        string2 = new MenuManager();
        this.tableViewer.getControl().setMenu(string2.createContextMenu(this.tableViewer.getControl()));
        this.createActions((ContributionManager)string2);
        final RowObject[] rowObjectArray = this.getRowData(this.data.values());
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return rowObjectArray;
            }
        });
        this.tableViewer.setInput((Object)rowObjectArray);
        this.main.layout();
    }

    protected RowObject[] getRowData(Collection<IDataset> collection) {
        if (collection.size() == 1 && collection.iterator().next().getShape().length == 2) {
            AbstractDataset abstractDataset = (AbstractDataset)collection.iterator().next();
            int[] nArray = abstractDataset.getShape();
            ArrayList<RowObject> arrayList = new ArrayList<RowObject>(nArray[0]);
            int rowObject = 0;
            while (rowObject < nArray[0]) {
                RowObject iDataset = new RowObject(rowObject);
                arrayList.add(iDataset);
                int n = 0;
                while (n < nArray[1]) {
                    iDataset.add(abstractDataset.getDouble(new int[]{rowObject, n++}));
                }
                ++rowObject;
            }
            return arrayList.toArray(new RowObject[arrayList.size()]);
        }
        int n = Integer.MIN_VALUE;
        for (IDataset object2 : collection) {
            n = Math.max(n, object2.getSize());
        }
        ArrayList<RowObject> arrayList = new ArrayList<RowObject>(n);
        int n2 = 0;
        while (n2 < n) {
            RowObject rowObject = new RowObject(n2);
            arrayList.add(rowObject);
            for (IDataset iDataset : collection) {
                try {
                    rowObject.add(iDataset.getDouble(new int[]{n2}));
                }
                catch (Exception exception) {
                    rowObject.add(Double.NaN);
                }
            }
            ++n2;
        }
        return arrayList.toArray(new RowObject[arrayList.size()]);
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setFocus() {
        if (this.tableViewer != null) {
            this.tableViewer.getControl().setFocus();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propListener);
        if (this.tableViewer != null) {
            this.tableViewer.getControl().dispose();
        }
        if (this.main != null) {
            this.main.dispose();
        }
        if (this.data != null) {
            this.data.clear();
        }
        this.dataProvider = null;
        super.dispose();
    }

    public void pageChanged(PageChangedEvent pageChangedEvent) {
        if (pageChangedEvent.getSelectedPage() == this) {
            this.update();
        }
    }

    private class BufferColumnProvider
    extends ColumnLabelProvider {
        private BufferColumnProvider() {
        }

        public String getText(Object object) {
            RowObject rowObject = (RowObject)object;
            return rowObject.toString();
        }
    }

    private class RowObject {
        private List<Float> rowValues = new ArrayList<Float>(31);
        private int row;

        RowObject(int n) {
            this.row = n;
        }

        public void add(float f) {
            this.rowValues.add(Float.valueOf(f));
        }

        public void add(double d) {
            this.rowValues.add(Float.valueOf((float)d));
        }

        public Float get(int n) {
            return this.rowValues.get(n);
        }

        public int getRow() {
            return this.row;
        }

        public String toString() {
            return this.rowValues.toString();
        }
    }

    private class ValueColumnProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        ValueColumnProvider(int n) {
            this.columnIndex = n;
        }

        public String getText(Object object) {
            RowObject rowObject = (RowObject)object;
            double d = rowObject.get(this.columnIndex).floatValue();
            if (Double.isNaN(d)) {
                return "";
            }
            return this.formatValue(d);
        }

        private String formatValue(double d) {
            String string = Activator.getDefault().getPreferenceStore().getString("data.format.editor.view");
            try {
                DecimalFormat decimalFormat = new DecimalFormat(string);
                return decimalFormat.format(d);
            }
            catch (Exception exception) {
                logger.debug("Format does not work: " + string, (Throwable)exception);
                return String.valueOf(d);
            }
        }
    }
}

