/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors;

import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystemSelection;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.slicing.ISlicablePlottingPart;
import org.dawb.common.ui.slicing.SliceComponent;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.workbench.ui.editors.CSVDataEditor;
import org.dawb.workbench.ui.editors.PlotDataComponent;
import org.dawb.workbench.ui.editors.PlotDataEditor;
import org.dawb.workbench.ui.views.PlotDataPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.editors.SRSEditor;

public class AsciiEditor
extends MultiPageEditorPart
implements ISlicablePlottingPart,
IPlottingSystemSelection {
    public static final String ID = "org.dawb.workbench.editors.AsciiEditor";
    private static final Logger logger = LoggerFactory.getLogger(AsciiEditor.class);
    private PlotDataEditor dataSetEditor;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    protected void createPages() {
        try {
            this.dataSetEditor = new PlotDataEditor(true, PlotType.PT1D);
            this.dataSetEditor.getPlottingSystem().setColorOption(AbstractPlottingSystem.ColorOption.BY_NAME);
            this.addPage(0, this.dataSetEditor, this.getEditorInput());
            this.setPageText(0, "Plot");
            TextEditor textEditor = new TextEditor();
            this.addPage(1, (IEditorPart)textEditor, this.getEditorInput());
            this.setPageText(1, "Text");
            CSVDataEditor cSVDataEditor = new CSVDataEditor();
            cSVDataEditor.setDataProvider(this.dataSetEditor);
            this.addPage(2, (IEditorPart)cSVDataEditor, this.getEditorInput());
            this.setPageText(2, "Data");
            this.addPageChangedListener(cSVDataEditor);
            if (System.getProperty("org.dawb.editor.ascii.hide.diamond.srs") == null) {
                SRSEditor sRSEditor = new SRSEditor();
                this.addPage(3, (IEditorPart)sRSEditor, this.getEditorInput());
                this.setPageText(3, "Info");
            }
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (EclipseUtils.getPage().findView("uk.ac.diamond.scisoft.analysis.rcp.views.DatasetInspectorView") != null && AsciiEditor.this.getPageCount() >= 4) {
                        AsciiEditor.this.setActivePage(3);
                    }
                }
            });
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot initiate " + ((Object)((Object)this)).getClass().getName() + "!", (Throwable)partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.getActiveEditor().isDirty()) {
            this.getActiveEditor().doSave(iProgressMonitor);
        }
    }

    public void doSaveAs() {
        if (this.getActiveEditor().isDirty()) {
            this.getActiveEditor().doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public PlotDataComponent getDataSetComponent() {
        return ((PlotDataEditor)this.getEditor(0)).getDataSetComponent();
    }

    public SliceComponent getSliceComponent() {
        return ((PlotDataEditor)this.getEditor(0)).getSliceComponent();
    }

    public void setActivePage(int n) {
        super.setActivePage(n);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public IPlottingSystem getPlotWindow() {
        return ((PlotDataEditor)this.getEditor(0)).getPlotWindow();
    }

    public PlotDataEditor getDataSetEditor() {
        return this.dataSetEditor;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            PlotDataEditor plotDataEditor = this.getDataSetEditor();
            return new PlotDataPage(plotDataEditor);
        }
        if (clazz == IToolPageSystem.class) {
            return this.dataSetEditor.getPlottingSystem();
        }
        return super.getAdapter(clazz);
    }

    public AbstractDataset setDatasetSelected(String string, boolean bl) {
        return this.getDataSetComponent().setDatasetSelected(string, bl);
    }

    public void setAll1DSelected(boolean bl) {
        this.getDataSetComponent().setAll1DSelected(bl);
    }

    public String toString() {
        if (this.getEditorInput() != null) {
            return this.getEditorInput().getName();
        }
        return super.toString();
    }
}

