/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.fabio;

import java.io.File;
import org.dawb.fabio.FableJep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonInfo {
    private static Logger logger = LoggerFactory.getLogger(PythonInfo.class);
    private static final String[] checkCommands = new String[]{"import matplotlib", "import numpy", "import numpy.oldnumeric", "import PIL", "import OpenGL", "import FitAllB", "import Fabric", "from ImageD11 import peaksearcher", "import fabio.openimage", "import polyxsim"};

    public static String getPythonInfo() {
        String string = "";
        string = String.valueOf(string) + "Python: \n";
        string = String.valueOf(string) + "  sys.executable: " + PythonInfo.getPythonSysValue("  ", "executable") + "\n";
        string = String.valueOf(string) + "  sys.prefix: " + PythonInfo.getPythonSysValue("  ", "prefix") + "\n";
        string = String.valueOf(string) + "  sys.exec_prefix: " + PythonInfo.getPythonSysValue("  ", "exec_prefix") + "\n";
        string = String.valueOf(string) + "  sys.version: " + PythonInfo.getPythonSysValue("  ", "version") + "\n";
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + "PYTHONPATH from Environment:\n";
        string = String.valueOf(string) + PythonInfo.getPythonPathFromEnvironment("  ");
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + "PYTHONPATH from Python:\n";
        string = String.valueOf(string) + PythonInfo.getPythonPathFromPython("  ");
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + "PATH:\n";
        string = String.valueOf(string) + PythonInfo.getPathFromEnvironment("  ");
        String[] stringArray = checkCommands;
        int n = checkCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + "Check '" + string2 + "':\n";
            string = String.valueOf(string) + "  " + (PythonInfo.checkCommand(string2) != false ? "Succeeded" : "Failed") + "\n";
            ++n2;
        }
        return string;
    }

    public static String getPythonSysValue(String string, String string2) {
        String string3;
        block12: {
            string3 = "";
            FableJep fableJep = null;
            try {
                try {
                    fableJep = FableJep.getFableJep();
                    string3 = String.valueOf(string) + (String)fableJep.getValue("sys." + string2);
                }
                catch (Throwable throwable) {
                    string3 = String.valueOf(string3) + string + "Error running Jep:\n\n" + string + throwable.getMessage();
                    if (fableJep == null) break block12;
                    try {
                        fableJep.close();
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
            finally {
                if (fableJep != null) {
                    try {
                        fableJep.close();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        return string3;
    }

    public static String getPythonPathFromEnvironment() {
        return PythonInfo.getPythonPathFromEnvironment("");
    }

    public static String getPythonPathFromEnvironment(String string) {
        String string2 = "";
        String string3 = System.getenv("PYTHONPATH");
        if (string3 != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string3.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray2[n2];
                string2 = String.valueOf(string2) + string + string4 + "\n";
                ++n2;
            }
        } else {
            string2 = String.valueOf(string2) + string + "Not Found" + "\n";
        }
        return string2;
    }

    public static String getPathFromEnvironment() {
        return PythonInfo.getPathFromEnvironment("");
    }

    public static String getPathFromEnvironment(String string) {
        String string2 = "";
        String string3 = System.getenv("PATH");
        if (string3 != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string3.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray2[n2];
                string2 = String.valueOf(string2) + string + string4 + "\n";
                ++n2;
            }
        } else {
            string2 = String.valueOf(string2) + string + "Not Found" + "\n";
        }
        return string2;
    }

    public static String getPythonPathFromPython() {
        return PythonInfo.getPythonPathFromEnvironment("");
    }

    private static String getPythonPathFromPython(String string) {
        String string2;
        block14: {
            string2 = "";
            FableJep fableJep = null;
            try {
                try {
                    fableJep = FableJep.getFableJep();
                    fableJep.eval("import sys");
                    fableJep.set("linePrefix", string);
                    fableJep.set("delimiter", "\n" + string);
                    string2 = (String)fableJep.getValue("linePrefix + delimiter.join(sys.path)");
                }
                catch (Throwable throwable) {
                    string2 = String.valueOf(string2) + string + "Error running Jep:\n\n" + string + throwable.getMessage();
                    if (fableJep != null) {
                        try {
                            fableJep.close();
                        }
                        catch (Throwable throwable2) {
                            throwable2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fableJep != null) {
                    try {
                        fableJep.close();
                    }
                    catch (Throwable throwable3) {
                        throwable3.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (fableJep != null) {
                try {
                    fableJep.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return String.valueOf(string2) + "\n";
    }

    private static Boolean checkCommand(String string) {
        Boolean bl;
        block12: {
            bl = true;
            FableJep fableJep = null;
            try {
                try {
                    fableJep = FableJep.getFableJep();
                    fableJep.eval(string);
                }
                catch (Throwable throwable) {
                    logger.error("Checking Python command \"" + string + "\" failed: " + throwable.getMessage());
                    bl = false;
                    if (fableJep == null) break block12;
                    try {
                        fableJep.close();
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
            finally {
                if (fableJep != null) {
                    try {
                        fableJep.close();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        return bl;
    }
}

