/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.fabio;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jep.Jep;
import jep.JepException;
import org.dawb.fabio.PythonInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FableJep {
    private static String pythonPath = "";
    private Jep jep;
    private String jepError;
    private long jepLastError;
    private Logger logger;
    private String filename;
    private boolean requireErrorMessage;
    private static boolean bRecord = false;
    private static Map<Long, FableJep> threadCache;

    public Jep getJep() {
        return this.jep;
    }

    public static synchronized FableJep getFableJep() throws Throwable {
        long l;
        if (threadCache == null) {
            threadCache = new HashMap<Long, FableJep>(7);
        }
        if (threadCache.containsKey(l = Thread.currentThread().getId())) {
            return threadCache.get(l);
        }
        FableJep fableJep = new FableJep(false);
        threadCache.put(l, fableJep);
        return fableJep;
    }

    public static synchronized void closeFableJep() throws Throwable {
        if (threadCache == null) {
            return;
        }
        long l = Thread.currentThread().getId();
        if (threadCache.containsKey(l)) {
            FableJep fableJep = threadCache.get(l);
            fableJep.close();
        }
    }

    public void close() throws Throwable {
        if (this.jep != null) {
            this.jep.isValidThread();
            this.jep.close();
            this.jep = null;
        }
        threadCache.remove(Thread.currentThread().getId());
    }

    private FableJep(boolean bl) throws Throwable {
        block8: {
            this.jep = null;
            this.jepLastError = 0L;
            this.filename = "";
            try {
                this.requireErrorMessage = bl;
                this.jep = new Jep(true, null, Thread.currentThread().getContextClassLoader());
                this.jepImportModules("sys", bl);
                this.jep.eval("if not hasattr(sys,'argv'):\n\tsys.argv = ['fable']");
                this.jepSetPythonPath(this.jep);
                this.logger = LoggerFactory.getLogger(FableJep.class);
            }
            catch (JepException jepException) {
                throw jepException;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (System.currentTimeMillis() - this.jepLastError <= 5000L) break block8;
                this.jepLastError = System.currentTimeMillis();
                String string = System.getProperty("os.name");
                if (string.toLowerCase().contains("windows")) {
                    this.jepError = "Failed to create the Java embedded Python interpreter (jep).";
                    this.jepError = String.valueOf(this.jepError) + "The error was :\n\n";
                    this.jepError = String.valueOf(this.jepError) + unsatisfiedLinkError.getMessage() + "\n\n";
                    this.jepError = String.valueOf(this.jepError) + "Make sure Python is installed. ";
                    this.jepError = String.valueOf(this.jepError) + "You can (partially) test your environment by typing python";
                } else if (string.toLowerCase().contains("mac")) {
                    this.jepError = "Failed to create the Java embedded Python interpreter (jep).";
                    this.jepError = String.valueOf(this.jepError) + "The error was :\n\n";
                    this.jepError = String.valueOf(this.jepError) + unsatisfiedLinkError.getMessage() + "\n\n";
                    this.jepError = String.valueOf(this.jepError) + "Make sure Python is installed and and that you have a ";
                    this.jepError = String.valueOf(this.jepError) + "symbolic link from $IMAGEVIEWER_HOME/plugins/jep_2.0.1/lib.macosx ";
                    this.jepError = String.valueOf(this.jepError) + "to /Library/Java/Extensions e.g.\n\n";
                    this.jepError = String.valueOf(this.jepError) + "sudo ln -s $IMAGEVIEWER_HOME/plugins/jep_2.0.1/lib/macosx/libjep.dylib   /Library/Java/Extensions/libjep.jnilib";
                } else {
                    this.jepError = "Failed to create the Java embedded Python interpreter (jep). ";
                    this.jepError = String.valueOf(this.jepError) + "The error was :\n\n";
                    this.jepError = String.valueOf(this.jepError) + unsatisfiedLinkError.getMessage() + "\n\n";
                    this.jepError = String.valueOf(this.jepError) + "Make sure Python is installed and that the environment ";
                    this.jepError = String.valueOf(this.jepError) + "variable LD_PRELOAD is pointing to your Python shared object interpreter ";
                    this.jepError = String.valueOf(this.jepError) + "e.g. LD_PRELOAD=/usr/lib/libpython2.6.so.1.0. ";
                    this.jepError = String.valueOf(this.jepError) + "Your current LD_PRELOAD is :\n\n" + System.getenv("LD_PRELOAD") + "\n\n";
                    this.jepError = String.valueOf(this.jepError) + "You can (partially) test your environment by typing python ";
                }
                if (!bl) {
                    throw new Exception(this.jepError, unsatisfiedLinkError);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)FableJep.this.jepError);
                    }
                });
                this.jepLastError = System.currentTimeMillis();
            }
        }
    }

    public void jepSetPythonPath(Jep jep) throws JepException {
        String string = System.getProperty("path.separator", "|");
        String string2 = pythonPath.replace("\\", "\\\\");
        String[] stringArray = string2.split(string);
        int n = stringArray.length - 1;
        while (n >= 0) {
            String string3 = "sys.path.insert(0, '" + stringArray[n] + "')";
            jep.eval(string3);
            --n;
        }
    }

    public void jepImportModules(String string) throws JepException {
        this.jepImportModules(string, true);
    }

    public void jepImportModules(String string, boolean bl) throws JepException {
        try {
            Jep jep = this.getJep();
            jep.eval("import " + string);
            this.writeScript("import " + string);
        }
        catch (JepException jepException) {
            if (System.currentTimeMillis() - this.jepLastError > 5000L) {
                this.jepLastError = System.currentTimeMillis();
                String string2 = System.getProperty("os.name");
                this.jepError = "Failed to import the modules " + string + " into " + "the Java embedded Python interpreter (jep). ";
                this.jepError = String.valueOf(this.jepError) + "The error was :\n\n";
                this.jepError = String.valueOf(this.jepError) + jepException.getMessage() + "\n\n";
                if (string2.toLowerCase().contains("windows")) {
                    this.jepError = String.valueOf(this.jepError) + "Make sure Python is installed and jep.dll is in your PATH ";
                } else {
                    this.jepError = String.valueOf(this.jepError) + "Make sure Python is installed and that the environment ";
                    this.jepError = String.valueOf(this.jepError) + "variable LD_PRELOAD is pointing to your Python shared object interpreter ";
                    this.jepError = String.valueOf(this.jepError) + "e.g. LD_PRELOAD=/usr/lib/libpython2.6.so.1.0. ";
                    this.jepError = String.valueOf(this.jepError) + "Your current LD_PRELOAD is :\n\n" + System.getenv("LD_PRELOAD") + "\n\n";
                }
                this.jepError = String.valueOf(this.jepError) + "and that the Python modules " + string + " are installed and in your PYTHONPATH. ";
                this.jepError = String.valueOf(this.jepError) + "Your current PYTHONPATH is :\n\n" + PythonInfo.getPythonPathFromEnvironment("  ") + "\n";
                this.jepError = String.valueOf(this.jepError) + "You can test your environment by starting python and then typing :\n\nimport " + string;
                if (bl) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)FableJep.this.jepError);
                            FableJep.this.jepLastError = System.currentTimeMillis();
                        }
                    });
                } else {
                    throw new JepException(this.jepError);
                }
            }
            throw jepException;
        }
    }

    public void jepImportSpecificDefinition(String string, String string2) throws JepException {
        this.jepImportSpecificDefinition(string, string2, true);
    }

    public void jepImportSpecificDefinition(String string, String string2, boolean bl) throws JepException {
        try {
            Jep jep = this.getJep();
            jep.eval("from " + string + " import " + string2);
            this.writeScript("from " + string + " import " + string2);
        }
        catch (JepException jepException) {
            if (System.currentTimeMillis() - this.jepLastError > 5000L) {
                this.jepLastError = System.currentTimeMillis();
                this.jepError = "Failed to import the modules " + string + " into the" + " Java embedded Python interpreter (jep).";
                this.jepError = String.valueOf(this.jepError) + "The error was :\n\n";
                this.jepError = String.valueOf(this.jepError) + jepException.getMessage() + "\n\n";
                this.jepError = String.valueOf(this.jepError) + "Make sure Python is installed and jep.dll is in your PATH and that the Python modules " + string + " are installed and in your PYTHONPATH. ";
                this.jepError = String.valueOf(this.jepError) + "Your current PYTHONPATH is :\n\n" + PythonInfo.getPythonPathFromEnvironment("  ") + "\n";
                this.jepError = String.valueOf(this.jepError) + "You can test your environment by starting python and then typing :\n\nimport " + string;
                if (!bl) {
                    throw new JepException(this.jepError);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)FableJep.this.jepError);
                        FableJep.this.jepLastError = System.currentTimeMillis();
                    }
                });
                this.jepLastError = System.currentTimeMillis();
            }
            throw jepException;
        }
    }

    public boolean eval(String string) throws JepException {
        this.logger.info(string);
        this.writeScript(string);
        return this.jep.eval(string);
    }

    public void set(String string, String string2) throws JepException {
        this.logger.info(String.valueOf(string) + "= " + string2);
        this.writeScript(String.valueOf(string) + "= \"" + string2 + "\"");
        this.jep.set(string, string2);
    }

    public void set(String string, double d) throws JepException {
        this.logger.info(String.valueOf(string) + "= " + d);
        this.writeScript(String.valueOf(string) + "= " + d);
        this.jep.set(string, d);
    }

    public void set(String string, int n) throws JepException {
        this.logger.info(String.valueOf(string) + "= \"" + n + "\"");
        this.writeScript(String.valueOf(string) + "= " + n);
        this.jep.set(string, n);
    }

    public void set(String string, float f) throws JepException {
        this.logger.info(String.valueOf(string) + "= " + f);
        this.writeScript(String.valueOf(string) + "= " + f);
        this.jep.set(string, f);
    }

    public Object getValue(String string) throws JepException {
        this.logger.info(string);
        Object object = null;
        try {
            object = this.jep.getValue(string);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return object;
    }

    public Boolean getBooleanValue(String string) {
        Boolean bl = false;
        try {
            bl = (Boolean)this.jep.getValue(string);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return bl;
    }

    public Integer getIntegerValue(String string) {
        Integer n = null;
        try {
            n = (Integer)this.jep.getValue("int(" + string + ")");
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return n;
    }

    public Float getFloatValue(String string) {
        Float f = null;
        try {
            f = (Float)this.jep.getValue("float(" + string + ")");
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return f;
    }

    public String getStringValue(String string) {
        String string2 = null;
        try {
            string2 = (String)this.jep.getValue(string);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return string2;
    }

    public float[] getValue_floatarray(String string) throws JepException {
        this.logger.info("getValue_floatarray");
        return this.jep.getValue_floatarray(string);
    }

    public void redirectStdout(String string) throws JepException {
        this.set("filename", string);
        this.jep.eval("logstdout=open(filename, 'w')");
        this.jep.eval("sys.stdout=logstdout");
        this.flushStdout();
    }

    public void redirectStderr(String string) throws JepException {
        this.set("filename", string);
        this.jep.eval("logstderr=open(filename, 'w')");
        this.jep.eval("sys.stderr=logstderr");
        this.flushStdout();
    }

    public void flushStdout() throws JepException {
        this.jep.eval("sys.stdout.flush()");
    }

    private void writeScript(String string) {
        if (bRecord) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.filename, true));
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                this.logger.error("Error writing script", (Throwable)iOException);
            }
        }
    }

    public static void record(boolean bl) {
        bRecord = bl;
    }

    public void setScriptFileName(String string) {
        this.filename = string;
    }

    public static String getPythonPath() {
        return pythonPath;
    }

    public static void setPythonPath(String string) {
        pythonPath = string;
    }

    public static String replaceEscapeSequences(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = string2.replaceAll("\t", "\\\\t");
        string2 = string2.replaceAll("\b", "\\\\b");
        string2 = string2.replaceAll("\n", "\\\\n");
        string2 = string2.replaceAll("\r", "\\\\r");
        string2 = string2.replaceAll("\f", "\\\\f");
        string2 = string2.replaceAll("'", "\\\\'");
        string2 = string2.replaceAll("\"", "\\\\\"");
        return string2;
    }

    public boolean isRequireErrorMessage() {
        return this.requireErrorMessage;
    }

    public void setRequireErrorMessage(boolean bl) {
        this.requireErrorMessage = bl;
    }
}

