/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.fabio;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.dawb.fabio.FabioFileException;
import org.dawb.fabio.FableJep;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabioFile
implements Comparable<Object>,
IPropertyChangeListener {
    private Semaphore semaphore = new Semaphore(1);
    public boolean headerRead = false;
    public boolean imageRead = false;
    private HashMap<String, String> header;
    private String fullFileName;
    private String fileName;
    private Vector<String> vKeysInHeader;
    private int width;
    private int height;
    private float minimum = Float.MAX_VALUE;
    private float maximum = Float.MIN_VALUE;
    private float sum = 0.0f;
    private float mean = Float.MIN_VALUE;
    private int floatImageBufferI = 0;
    private long timeToReadImage = 0L;
    private String stem;
    private String fileNumber;
    ImageLoader loader;
    ImageData[] imageDataArray;
    Logger logger = LoggerFactory.getLogger(FabioFile.class);
    private int index;
    private boolean flag = true;
    private static float[][] floatImageBuffer = null;
    private static int floatImageBufferPointer = 0;
    private static String[] fileImageBuffer = null;
    private String comparatorKey = "filename";
    private int comparatorDir = 1024;
    private int comparedResult;

    public FabioFile(String string) throws FabioFileException {
        if (floatImageBuffer == null) {
            floatImageBuffer = new float[10][];
            fileImageBuffer = new String[10];
            int n = 0;
            while (n < 10) {
                FabioFile.floatImageBuffer[n] = null;
                FabioFile.fileImageBuffer[n] = new String();
                ++n;
            }
        }
        if (!new File(string).exists()) {
            throw new FabioFileException(this.getClass().getName(), "FabioFile", "File not found: " + string);
        }
        this.headerRead = false;
        this.header = new HashMap();
        this.vKeysInHeader = new Vector();
        this.fullFileName = string;
        String[] stringArray = this.fullFileName.split("[\\\\/]");
        this.fileName = this.fullFileName;
        if (stringArray.length > 1) {
            this.fileName = stringArray[stringArray.length - 1];
        }
    }

    public synchronized void acquire() {
        this.semaphore.acquireUninterruptibly();
    }

    public synchronized void release() {
        this.semaphore.release();
    }

    private void importFabioModules(FableJep fableJep) throws Throwable {
        boolean bl = fableJep.isRequireErrorMessage();
        fableJep.jepImportModules("sys", bl);
        fableJep.jepImportModules("numpy", bl);
        fableJep.jepImportModules("PIL", bl);
        fableJep.jepImportModules("fabio.openimage", bl);
    }

    public void setFullFileName(String string) {
        this.fullFileName = string;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public String toString() {
        if (!this.headerRead) {
            try {
                this.loadHeader();
            }
            catch (FabioFileException fabioFileException) {}
        }
        String string = "{ \\n";
        Set<Map.Entry<String, String>> set = this.header.entrySet();
        for (Map.Entry<String, String> entry : set) {
            string = String.valueOf(string) + entry.getKey() + "=" + entry.getValue() + ";\\n";
        }
        string = String.valueOf(string) + "} \\n";
        return string;
    }

    public void loadHeader() throws FabioFileException {
        if (!this.headerRead) {
            try {
                this.loadHeader(this.getFableJep());
            }
            catch (Throwable throwable) {
                throw new FabioFileException(this.getClass().getName(), "loadHeader" + this.fullFileName, throwable.getMessage());
            }
        }
    }

    public synchronized void loadHeader(FableJep fableJep) throws FabioFileException {
        if (!this.headerRead) {
            this.acquire();
            File file = new File(this.fullFileName);
            if (file.exists()) {
                try {
                    this.importFabioModules(fableJep);
                    fableJep.set("filename", this.fullFileName);
                    fableJep.eval("im = fabio.openimage.openheader(filename)");
                    fableJep.eval("keys = im.header.keys()");
                    fableJep.eval("vals = im.header.values()");
                    fableJep.eval("res = len(keys)");
                    int n = (Integer)fableJep.getValue("res");
                    String string = "";
                    this.header = new HashMap();
                    int n2 = 0;
                    while (n2 < n) {
                        String string2;
                        fableJep.set("i", n2);
                        fableJep.eval("res = str(keys[i])");
                        string = (String)fableJep.getValue("res");
                        try {
                            fableJep.eval("res = str(vals[i])");
                            string2 = (String)fableJep.getValue("res");
                        }
                        catch (Throwable throwable) {
                            string2 = "-1";
                        }
                        this.header.put(string, string2);
                        this.vKeysInHeader.add(string);
                        ++n2;
                    }
                    this.addHeaderInfo("name", this.fileName);
                    this.addHeaderInfo("#", "" + this.index);
                    this.headerRead = true;
                }
                catch (Throwable throwable) {
                    this.release();
                    this.logger.error(throwable.getMessage());
                    throw new FabioFileException(this.getClass().getName(), "loadHeader" + this.fullFileName, throwable.getMessage());
                }
            }
            this.release();
            throw new FabioFileException(this.getClass().getName(), "loadHeader", "File not found" + this.fullFileName);
            this.release();
        }
    }

    public void addHeaderInfo(String string, String string2) {
        this.header.put(string, string2);
    }

    public String[] getKeys() throws FabioFileException, Throwable {
        if (!this.headerRead) {
            this.loadHeader();
        }
        Set<String> set = this.header.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        FabioFile.quicksort(stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static void quicksort(String[] stringArray, int n, int n2) {
        if (n2 > n) {
            int n3 = FabioFile.partition(stringArray, n, n2);
            FabioFile.quicksort(stringArray, n, n3);
            FabioFile.quicksort(stringArray, n3 + 1, n2);
        }
    }

    private static int partition(String[] stringArray, int n, int n2) {
        String string;
        int n3 = n + (n2 - n) / 2;
        String string2 = stringArray[n3];
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            if (stringArray[n5].compareTo(string2) < 0) {
                string = stringArray[n5];
                stringArray[n5] = stringArray[n4];
                stringArray[n4] = string;
                if (n4 == n3) {
                    n3 = n5;
                }
                ++n4;
            }
            ++n5;
        }
        if (n4 < n2) {
            string = stringArray[n4];
            stringArray[n4] = string2;
            stringArray[n3] = string;
        }
        return n4;
    }

    public Vector<String> getKeysAsListedInHeader() throws FabioFileException, Throwable {
        if (!this.headerRead) {
            this.loadHeader();
        }
        return this.vKeysInHeader;
    }

    public String getValue(String string) throws FabioFileException {
        if (!this.headerRead) {
            this.loadHeader();
        }
        String string2 = "";
        if (!this.header.containsKey(string)) {
            throw new FabioFileException(this.getClass().getName(), "getValue()", "The key " + string + " has not be found in the header for the file " + this.fileName);
        }
        string2 = this.header.get(string);
        return string2;
    }

    public void addIndex(int n) {
        this.index = n;
    }

    public String getFullFilename() {
        return this.fullFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getTimeToReadImage() {
        return this.timeToReadImage;
    }

    /*
     * Unable to fully structure code
     */
    public String getStems() {
        if (this.stem == null) {
            block7: {
                var1_1 = null;
                var2_2 = this.fileName.split("\\.");
                var1_1 = this.fileName;
                if (var2_2 != null && var2_2.length >= 2) {
                    var3_3 = var2_2[1];
                    try {
                        Integer.valueOf(var3_3);
                        var4_4 = this.fileName.indexOf(".");
                        var1_1 = this.fileName.substring(0, var4_4);
                        break block7;
                    }
                    catch (NumberFormatException v0) {
                        var4_5 = var2_2[0].length() - 1;
                        ** while (var4_5 > 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Integer.valueOf(var2_2[0].substring(var4_5 - 1, var4_5));
                            --var4_5;
                        }
                        catch (NumberFormatException v1) {
                            var1_1 = var2_2[0].substring(0, var4_5);
                            var4_5 = 0;
                        }
                        continue;
                    }
                }
            }
            this.stem = var1_1;
        }
        return this.stem;
    }

    /*
     * Unable to fully structure code
     */
    public String getFileNumber() {
        if (this.fileNumber == null) {
            block7: {
                var1_1 = null;
                var2_2 = this.fileName.split("\\.");
                var1_1 = this.fileName;
                if (var2_2 != null && var2_2.length >= 2) {
                    var3_3 = var2_2[1];
                    try {
                        Integer.valueOf(var3_3);
                        var1_1 = var3_3;
                        break block7;
                    }
                    catch (NumberFormatException v0) {
                        var4_4 = var2_2[0].length() - 1;
                        ** while (var4_4 > 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Integer.valueOf(var2_2[0].substring(var4_4 - 1, var4_4));
                            --var4_4;
                        }
                        catch (NumberFormatException v1) {
                            var1_1 = var2_2[0].substring(var4_4, var2_2[0].length());
                            var4_4 = 0;
                        }
                        continue;
                    }
                }
            }
            this.fileNumber = var1_1;
        }
        return this.fileNumber;
    }

    public int getWidth() throws Throwable {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.width;
    }

    public int getHeight() throws Throwable {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.height;
    }

    public int getBytesPerPixel() {
        return 2;
    }

    public void readImage() throws Throwable {
        this.readImageAsFloat();
    }

    public void readImageAsFloat() throws Throwable {
        this.readImageAsFloat(this.getFableJep());
    }

    public synchronized void readImageAsFloat(FableJep fableJep) throws Throwable {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!this.imageRead || !bl) {
            this.logger.debug("read file " + this.fileName);
            long l = System.currentTimeMillis();
            this.importFabioModules(fableJep);
            fableJep.set("filename", this.fullFileName);
            fableJep.eval("im = fabio.openimage.openimage(filename)");
            fableJep.eval("res = im.data.astype(numpy.float32).tostring()");
            FabioFile.floatImageBuffer[FabioFile.floatImageBufferPointer] = fableJep.getValue_floatarray("res");
            this.floatImageBufferI = floatImageBufferPointer;
            FabioFile.fileImageBuffer[FabioFile.floatImageBufferPointer] = this.fullFileName;
            this.incrementBufferPointer();
            fableJep.eval("res = im.dim1");
            this.width = (Integer)fableJep.getValue("res");
            fableJep.eval("res = im.dim2");
            this.height = (Integer)fableJep.getValue("res");
            if (this.minimum == Float.MAX_VALUE || this.maximum == Float.MIN_VALUE) {
                this.sum = 0.0f;
                int n = 0;
                while (n < floatImageBuffer[this.floatImageBufferI].length) {
                    this.sum += floatImageBuffer[this.floatImageBufferI][n];
                    if (floatImageBuffer[this.floatImageBufferI][n] < this.minimum) {
                        this.minimum = floatImageBuffer[this.floatImageBufferI][n];
                    }
                    if (floatImageBuffer[this.floatImageBufferI][n] > this.maximum) {
                        this.maximum = floatImageBuffer[this.floatImageBufferI][n];
                    }
                    ++n;
                }
                this.mean = this.sum / (float)floatImageBuffer[this.floatImageBufferI].length;
            }
            this.timeToReadImage = System.currentTimeMillis() - l;
            this.imageRead = true;
        }
    }

    private void incrementBufferPointer() {
        if (++floatImageBufferPointer >= floatImageBuffer.length) {
            floatImageBufferPointer = 0;
        }
    }

    public float[] getImageAsFloat() throws Throwable {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!bl) {
            this.readImageAsFloat();
        }
        return floatImageBuffer[this.floatImageBufferI];
    }

    public float[] getImageAsFloat(FableJep fableJep) {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!bl) {
            try {
                this.readImageAsFloat(fableJep);
                bl = true;
            }
            catch (Throwable throwable) {}
        }
        return floatImageBuffer[this.floatImageBufferI];
    }

    public int[] getImageAsInt() throws Throwable {
        boolean bl = false;
        if (this.floatImageBufferI > -1 && fileImageBuffer[this.floatImageBufferI] != null && fileImageBuffer[this.floatImageBufferI].equalsIgnoreCase(this.fullFileName)) {
            bl = true;
        }
        this.timeToReadImage = 0L;
        if (!bl) {
            this.readImageAsFloat();
        }
        int[] nArray = new int[this.getWidth() * this.getHeight()];
        int n = 0;
        while (n < floatImageBuffer[this.floatImageBufferI].length) {
            nArray[n] = (int)floatImageBuffer[this.floatImageBufferI][n];
            ++n;
        }
        return nArray;
    }

    public float getMinimum() throws Throwable {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.minimum;
    }

    public float getMaximum() throws Throwable {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.maximum;
    }

    public float getMean() throws Throwable {
        if (!this.imageRead) {
            this.readImage();
        }
        return this.mean;
    }

    public void setFlag(boolean bl) {
        this.flag = bl;
    }

    public boolean getFlag() {
        return this.flag;
    }

    @Override
    public int compareTo(Object object) {
        try {
            String string = ((FabioFile)object).getValue(this.comparatorKey);
            String string2 = this.getValue(this.comparatorKey);
            this.comparedResult = this.comparatorDir == 128 ? string.compareTo(string2) : string2.compareTo(string);
        }
        catch (FabioFileException fabioFileException) {
            this.logger.error(fabioFileException.getMessage());
        }
        return this.comparedResult;
    }

    public int compareTo(String string, Object object) {
        this.comparatorKey = string;
        return this.compareTo(object);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("comparator")) {
            this.comparatorKey = (String)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getProperty().equals("dir")) {
            this.comparatorDir = (Integer)propertyChangeEvent.getNewValue();
        }
    }

    private FableJep getFableJep() throws Throwable {
        return FableJep.getFableJep();
    }
}

