/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.hardware;

import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import org.dawb.common.ui.views.monitor.HardwareObject;
import org.dawb.common.ui.views.monitor.HardwareObjectEvent;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.dawb.tango.extensions.factory.TangoConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TangoHardwareObject
extends HardwareObject
implements TangoConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(TangoHardwareObject.class);
    private transient TangoConnection tangoConnection;

    protected void connect() throws Exception {
        this.label = this.getHardwareName();
        if (this.hardwareName == null) {
            this.value = "-";
            return;
        }
        int n = this.getHardwareName().lastIndexOf(":");
        String string = n > -1 ? this.getHardwareName().substring(n + 1) : "Position";
        String string2 = n > -1 ? this.getHardwareName().substring(0, n) : this.getHardwareName();
        String string3 = TangoUtils.getHardwareAddress(string2);
        try {
            try {
                this.tangoConnection = TangoConnectionFactory.openMonitoredConnection(string3, string);
                this.label = this.tangoConnection.getName();
                this.tangoConnection.addTangoConnectionListener(this);
            }
            catch (ConnectionFailed connectionFailed) {
                this.value = connectionFailed.errors != null && connectionFailed.errors.length > 0 ? connectionFailed.errors[0].desc : connectionFailed.getMessage();
                this.description = this.tooltip = "Address '" + string3 + "' does not resolve. Go to 'Tango Preferences' or change name.";
                logger.error("Failed to connect to motor " + string3, (Throwable)connectionFailed);
                return;
            }
        }
        catch (Throwable throwable) {
            this.value = throwable.getMessage();
            this.description = this.tooltip = "Address '" + string3 + "' does not resolve. Go to 'Tango Preferences' or change name.";
            logger.error("Failed to connect to motor " + string3, throwable);
            return;
        }
        this.description = "Tango motor";
        this.updateValue(null);
        this.maximum = -20000.0;
        this.minimum = 20000.0;
        if (TangoConnectionFactory.isMockMode()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    TangoHardwareObject.this.updateValue(null);
                    TangoHardwareObject.this.notifyServerObjectListeners(new HardwareObjectEvent((Object)TangoHardwareObject.this));
                }
            }, "Refresh " + this.getHardwareName());
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void updateValue(TangoConnectionEvent tangoConnectionEvent) {
        try {
            DeviceAttribute deviceAttribute = tangoConnectionEvent != null ? tangoConnectionEvent.getValue() : this.tangoConnection.getValue();
            this.value = deviceAttribute.extractDouble();
        }
        catch (Throwable throwable) {
            this.value = throwable.getMessage();
            logger.trace("Error processing tango event " + tangoConnectionEvent, throwable);
        }
    }

    protected void disconnect() {
        if (this.tangoConnection == null) {
            return;
        }
        try {
            this.tangoConnection.removeTangoConnectionListener(this);
            this.tangoConnection.dispose();
        }
        catch (Exception exception) {
            logger.error("Cannot unsubscribe stop tango event listening", (Throwable)exception);
        }
        this.tangoConnection = null;
    }

    @Override
    public void tangoEventPerformed(TangoConnectionEvent tangoConnectionEvent) {
        this.updateValue(tangoConnectionEvent);
        this.notifyServerObjectListeners(new HardwareObjectEvent((Object)this));
    }
}

