/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.factory;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import java.util.EventObject;
import org.dawb.common.ui.Activator;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.AbstractTangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionListener;
import org.dawb.tango.extensions.factory.TangoMockEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TangoConnectionImpl
extends AbstractTangoConnection {
    private static final Logger logger = LoggerFactory.getLogger(TangoConnectionImpl.class);
    protected DeviceProxy tangoProxy;
    protected TangoEventsAdapter tangoEvents;
    protected ITangoChangeListener listener;
    protected long lastEvent = 0L;

    public TangoConnectionImpl(String string, String string2, boolean bl) throws Exception {
        super(string, string2);
        this.createTangoHost();
        this.tangoProxy = new DeviceProxy(string);
        if (bl) {
            this.tangoEvents = new TangoEventsAdapter(this.tangoProxy);
            this.listener = new ITangoChangeListener(){

                public void change(TangoChangeEvent tangoChangeEvent) {
                    TangoConnectionImpl.this.fireTangoConnectionListeners((EventObject)tangoChangeEvent);
                    TangoConnectionImpl.this.lastEvent = System.currentTimeMillis();
                }
            };
            if (string2 != null) {
                this.tangoEvents.addTangoChangeListener(this.listener, string2, new String[0]);
            } else {
                this.attributeName = "Output";
                this.tangoEvents.addTangoChangeListener(this.listener, string2, new String[0]);
            }
        }
    }

    @Override
    public void addTangoConnectionListener(TangoConnectionListener tangoConnectionListener) {
        if (this.tangoEvents == null) {
            throw new RuntimeException("This tango connection, '" + this.getUri() + "', is not listening to events!");
        }
        super.addTangoConnectionListener(tangoConnectionListener);
    }

    private void createTangoHost() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iPreferenceStore.getString("org.dawb.server.name"));
        stringBuffer.append(":");
        stringBuffer.append(iPreferenceStore.getInt("org.dawb.server.port"));
        System.setProperty("TANGO_HOST", stringBuffer.toString());
    }

    @Override
    public synchronized void dispose() throws Exception {
        super.dispose();
        if (this.tangoEvents != null && this.listener != null) {
            this.tangoEvents.removeTangoChangeListener(this.listener, this.attributeName);
        }
        this.tangoProxy = null;
        this.tangoEvents = null;
        this.listener = null;
    }

    @Override
    public DeviceAttribute getValue() throws Exception {
        if (this.attributeName == null) {
            throw new NullPointerException("Cannot read attribute " + null);
        }
        return this.tangoProxy.read_attribute(this.attributeName);
    }

    @Override
    public void setValue(DeviceAttribute deviceAttribute) throws Exception {
        if (this.attributeName == null) {
            throw new NullPointerException("Cannot read attribute " + null);
        }
        this.tangoProxy.write_attribute(deviceAttribute);
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {}
        try {
            double d = this.getValue().extractDouble();
            double d2 = deviceAttribute.extractDouble();
            double d3 = 0.001;
            int n = 0;
            while (d > d2 + d3 || d < d2 - d3) {
                if (n > 5000) {
                    logger.error("TIMEOUT: Cannot set motor value " + this.getUri() + " synchronously!");
                    return;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    break;
                }
                n += 200;
                d = this.getValue().extractDouble();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void executeCommand(String string, String string2, boolean bl) throws Exception {
        String string3 = TangoUtils.getBracketedCommand(string2);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string3});
        this.executeCommand(string, string2, deviceData, bl);
    }

    @Override
    public DeviceData executeCommand(String string, DeviceData deviceData, boolean bl) throws Exception {
        return this.executeCommand(string, deviceData.toString(), deviceData, bl);
    }

    private DeviceData executeCommand(final String string, final String string2, final DeviceData deviceData, boolean bl) throws Exception {
        if (bl) {
            Job job = new Job(string2){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    TangoConnectionImpl.this.executeCommand(string, string2, deviceData);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(40);
            job.schedule();
            return null;
        }
        return this.executeCommand(string, string2, deviceData);
    }

    private DeviceData executeCommand(String string, String string2, DeviceData deviceData) {
        try {
            String string3 = System.getProperty("org.dawb.tango.spec.command.timeout");
            this.tangoProxy.set_timeout_millis(string3 != null ? Integer.parseInt(string3) : Integer.MAX_VALUE);
            DeviceData deviceData2 = this.tangoProxy.command_inout(string, deviceData);
            while (System.currentTimeMillis() - this.lastEvent < 1000L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent(this, new TangoMockEvent(), "Finished '" + string2 + "'");
            tangoConnectionEvent.setFinished(true);
            this.fireTangoConnectionListeners(tangoConnectionEvent);
            return deviceData2;
        }
        catch (DevFailed devFailed) {
            TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent(this, new TangoMockEvent(), "Failed '" + string2 + "'");
            if (devFailed.errors != null && devFailed.errors.length > 0) {
                tangoConnectionEvent.setErrorMessage(devFailed.errors[devFailed.errors.length - 1].desc);
            } else {
                tangoConnectionEvent.setErrorMessage(devFailed.getLocalizedMessage());
            }
            tangoConnectionEvent.setFinished(true);
            this.fireTangoConnectionListeners(tangoConnectionEvent);
            return null;
        }
    }

    public static void clear() {
    }
}

