/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.factory;

import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dawb.tango.extensions.factory.AbstractTangoConnection;
import org.dawb.tango.extensions.factory.MockTangoConnection;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionImpl;
import org.dawb.tango.extensions.factory.TangoMockEvent;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TangoConnectionFactory {
    private static Logger logger = LoggerFactory.getLogger(TangoConnectionFactory.class);
    private static Map<String, AbstractTangoConnection> cachedTangoConnections;
    private static Object LOCK;

    static {
        LOCK = new Object();
    }

    public static TangoConnection openConnection(String string, String string2) throws Exception {
        return TangoConnectionFactory.getTangoConnection(string, string2, false);
    }

    public static TangoConnection openMonitoredConnection(String string, String string2) throws Exception {
        return TangoConnectionFactory.getTangoConnection(string, string2, true);
    }

    public static TangoConnection openCommandConnection(String string) throws Exception {
        return TangoConnectionFactory.getTangoConnection(string, "Output", false);
    }

    public static TangoConnection openMonitoredCommandConnection(String string, String string2) throws Exception {
        return TangoConnectionFactory.getTangoConnection(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TangoConnection getTangoConnection(String string, String string2, boolean bl) throws Exception {
        boolean bl2 = TangoConnectionFactory.isMockMode();
        if (!bl && !bl2) {
            return new TangoConnectionImpl(string, string2, false);
        }
        if (cachedTangoConnections == null) {
            cachedTangoConnections = new ConcurrentHashMap<String, AbstractTangoConnection>(7);
        }
        Object object = LOCK;
        synchronized (object) {
            String string3 = String.valueOf(string) + ":" + string2;
            if (cachedTangoConnections.containsKey(string3)) {
                AbstractTangoConnection abstractTangoConnection = cachedTangoConnections.get(string3);
                abstractTangoConnection.incrementCount();
                return abstractTangoConnection;
            }
            AbstractTangoConnection abstractTangoConnection = bl2 ? new MockTangoConnection(string, string2) : new TangoConnectionImpl(string, string2, true);
            cachedTangoConnections.put(string3, abstractTangoConnection);
            return abstractTangoConnection;
        }
    }

    protected static void clearConnection(AbstractTangoConnection abstractTangoConnection) {
        if (cachedTangoConnections == null) {
            return;
        }
        String string = String.valueOf(abstractTangoConnection.getUri()) + ":" + abstractTangoConnection.getAttributeName();
        cachedTangoConnections.remove(string);
    }

    public static void clear() {
        TangoConnectionImpl.clear();
        cachedTangoConnections.clear();
    }

    public static DeviceProxy openDirectConnection(String string) throws Exception {
        return new DeviceProxy(string);
    }

    public static boolean isMockMode() {
        boolean bl = true;
        String string = "by default";
        if (System.getProperty("org.dawb.test.session") == null) {
            ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
            if (scopedPreferenceStore.contains("org.dawb.remote.session.mock")) {
                bl = scopedPreferenceStore.getBoolean("org.dawb.remote.session.mock");
                string = "from workspace store (.metadata)";
            }
        } else {
            string = "from system property org.dawb.test.session";
            if (System.getProperty("org.dawb.test.session").equals("false")) {
                bl = false;
            }
        }
        logger.debug("TANGO Spec Mock Mode set to " + bl + " " + string);
        return bl;
    }

    public static void setMockMode(boolean bl) {
        System.setProperty("org.dawb.test.session", new Boolean(bl).toString());
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.common.ui");
        scopedPreferenceStore.setValue("org.dawb.remote.session.mock", bl);
    }

    public static Object getMockValue(String string) {
        return MockTangoConnection.getMockValue(string);
    }

    public static void setMockValue(String string, Object object) {
        string = string.trim();
        MockTangoConnection.putMockValue(string, object);
        if (MockTangoConnection.isMockMotor(string)) {
            DeviceAttribute deviceAttribute = object instanceof Number ? new DeviceAttribute("Position", ((Number)object).doubleValue()) : new DeviceAttribute("Position", object.toString());
            AbstractTangoConnection abstractTangoConnection = MockTangoConnection.getMockMotor(string);
            TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent((TangoConnection)abstractTangoConnection, deviceAttribute);
            abstractTangoConnection.fireTangoConnectionListeners(tangoConnectionEvent);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void notifyMockCommand(String string, String string2, String string3) {
        if (MockTangoConnection.isMockMotor(string = string.trim())) {
            AbstractTangoConnection abstractTangoConnection = MockTangoConnection.getMockMotor(string);
            if (string2 == null && string3 == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent(abstractTangoConnection, new TangoMockEvent(), "End");
                tangoConnectionEvent.setFinished(true);
                abstractTangoConnection.fireTangoConnectionListeners(tangoConnectionEvent);
            } else {
                abstractTangoConnection.fireTangoConnectionListeners(new TangoMockEvent(string2), string3);
            }
        }
    }
}

