/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.factory;

import fr.esrf.TangoApi.AttrReadEvent;
import fr.esrf.TangoApi.AttrWrittenEvent;
import fr.esrf.TangoApi.CmdDoneEvent;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import java.util.EventObject;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoMockEvent;

public class TangoConnectionEvent
extends EventObject {
    private static final long serialVersionUID = 4784933927171042199L;
    private Object tangoEvent;
    private String command;
    private boolean finished = false;
    private DeviceAttribute value;
    private String errorMessage;

    public TangoConnectionEvent(TangoConnection tangoConnection, DeviceAttribute deviceAttribute) {
        super(tangoConnection);
        this.value = deviceAttribute;
    }

    public TangoConnectionEvent(TangoConnection tangoConnection, Object object, String string) {
        super(tangoConnection);
        this.tangoEvent = object;
        this.command = string;
    }

    public TangoConnectionEvent(TangoConnection tangoConnection, EventObject eventObject) {
        super(tangoConnection);
        this.tangoEvent = eventObject;
    }

    public Object getOriginalEvent() {
        return this.tangoEvent;
    }

    public DeviceAttribute getValue() throws Exception {
        if (this.value != null) {
            return this.value;
        }
        if (this.tangoEvent instanceof TangoMockEvent) {
            return ((TangoMockEvent)this.tangoEvent).getValue();
        }
        if (this.tangoEvent instanceof TangoChangeEvent) {
            return ((TangoChangeEvent)this.tangoEvent).getValue();
        }
        if (this.tangoEvent instanceof EventData) {
            return ((EventData)this.tangoEvent).attr_value;
        }
        return null;
    }

    public DeviceAttribute[] getValues() throws Exception {
        if (this.value != null) {
            return new DeviceAttribute[]{this.value};
        }
        if (this.tangoEvent instanceof TangoMockEvent) {
            return ((TangoMockEvent)this.tangoEvent).getValues();
        }
        if (this.tangoEvent instanceof AttrReadEvent) {
            return ((AttrReadEvent)this.tangoEvent).argout;
        }
        if (this.tangoEvent instanceof AttrWrittenEvent) {
            return null;
        }
        return null;
    }

    public boolean isFinishedEvent() {
        if (this.finished) {
            return true;
        }
        return this.tangoEvent instanceof CmdDoneEvent;
    }

    public void setFinished(boolean bl) {
        this.finished = bl;
    }

    public String getCommand() {
        return this.command;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }
}

