/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.factory;

import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import javax.management.MBeanServerConnection;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.AbstractTangoConnection;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockTangoConnection
extends AbstractTangoConnection {
    private static final Logger logger = LoggerFactory.getLogger(MockTangoConnection.class);
    private static Map<String, Object> mockValues = new ConcurrentHashMap<String, Object>(17);
    private static Map<String, AbstractTangoConnection> mockListeners;
    private static Map<String, IMockCommand> commandMap;
    private String hardwareName;
    private static MBeanServerConnection remoteClientConnection;

    protected MockTangoConnection(String string) {
        this(string, null);
    }

    public MockTangoConnection(String string, String string2) {
        super(string, string2);
        if (commandMap == null) {
            MockTangoConnection.createCommandMap();
        }
        this.hardwareName = string.substring(string.lastIndexOf("/") + 1);
        if (string2 != null) {
            if (mockListeners == null) {
                mockListeners = new ConcurrentHashMap<String, AbstractTangoConnection>();
            }
            mockListeners.put(this.getHardwareName(), this);
            if (mockValues.get(this.getHardwareName()) == null) {
                mockValues.put(this.getHardwareName(), 0.0);
            }
        }
    }

    public void fireTangoConnectionListeners() throws Exception {
        TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent((TangoConnection)this, this.getValue());
        this.fireTangoConnectionListeners(tangoConnectionEvent);
    }

    @Override
    public DeviceAttribute getValue() throws Exception {
        if (!mockValues.containsKey(this.getHardwareName())) {
            this.setValue(this.getHardwareName(), new Double(0.0));
        }
        return new DeviceAttribute(this.attributeName, ((Number)this.getRemoteValue()).doubleValue());
    }

    private Object getRemoteValue() throws Exception {
        if (TangoConnectionFactory.isMockMode()) {
            MBeanServerConnection mBeanServerConnection = this.getRemoteClient();
            return mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "getMockMotorValue", new Object[]{this.getName()}, new String[]{String.class.getName()});
        }
        throw new Exception("Cannot set Mock Values when not in mock mode!");
    }

    private MBeanServerConnection getRemoteClient() throws Exception {
        if (remoteClientConnection == null) {
            remoteClientConnection = RemoteWorkbenchAgent.getServerConnection((long)1000L);
        }
        return remoteClientConnection;
    }

    @Override
    public void setValue(DeviceAttribute deviceAttribute) throws Exception {
        this.setValue(this.getHardwareName(), deviceAttribute.extractDouble());
    }

    @Override
    public synchronized DeviceData executeCommand(String string, DeviceData deviceData, boolean bl) throws Exception {
        this.executeCommand(string, deviceData, bl);
        return new DeviceData();
    }

    @Override
    public synchronized void executeCommand(String string, final String string2, boolean bl) throws Exception {
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MockTangoConnection.this.executeCommand(string2);
                    }
                    catch (Exception exception) {
                        logger.error("Problem running command " + string2, (Throwable)exception);
                    }
                }
            }, "Mock Command '" + string2 + "'");
            thread.start();
        } else {
            this.executeCommand(string2);
        }
    }

    private void executeCommand(String string) throws Exception {
        Matcher matcher = TangoUtils.getBracketedMatcher(string);
        if (matcher == null) {
            this.notifyCommand("Command '" + string + "' not implemented in mock mode.", string);
            this.notifyEndCommand();
            return;
        }
        String string2 = matcher.group(1);
        if (commandMap.containsKey(string2)) {
            commandMap.get(string2).processCommand(matcher, this);
        } else {
            this.notifyCommand("Command '" + string + "' not implemented in mock mode.", string);
            this.notifyEndCommand();
        }
    }

    private static void createCommandMap() {
        commandMap = new ConcurrentHashMap<String, IMockCommand>();
        commandMap.put("mv", new MVMockCommand());
        commandMap.put("ascan", new ScanMockCommand());
    }

    private void notifyEndCommand() throws Exception {
        this.notifyCommand(null, null);
    }

    private void notifyCommand(String string, String string2) throws Exception {
        if (TangoConnectionFactory.isMockMode()) {
            MBeanServerConnection mBeanServerConnection = this.getRemoteClient();
            mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "notifyMockCommand", new Object[]{this.getName(), string, string2}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
            if (System.getProperty("eclipse.debug.session") == null) {
                TangoConnectionFactory.notifyMockCommand(this.getName(), string, string2);
            }
        } else {
            throw new Exception("Cannot set Mock Values when not in mock mode!");
        }
    }

    private void setValue(String string, Object object) throws Exception {
        if (TangoConnectionFactory.isMockMode()) {
            MBeanServerConnection mBeanServerConnection = this.getRemoteClient();
            mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setMockMotorValue", new Object[]{string, object}, new String[]{String.class.getName(), Object.class.getName()});
            if (System.getProperty("eclipse.debug.session") == null) {
                TangoConnectionFactory.setMockValue(string, object);
            }
        } else {
            throw new Exception("Cannot set Mock Values when not in mock mode!");
        }
    }

    private String getHardwareName() {
        return this.hardwareName;
    }

    public static void putMockValue(String string, Object object) {
        if (mockValues == null) {
            return;
        }
        mockValues.put(string, object);
    }

    public static boolean isMockMotor(String string) {
        if (mockListeners == null) {
            return false;
        }
        return mockListeners.containsKey(string);
    }

    public static AbstractTangoConnection getMockMotor(String string) {
        if (mockListeners == null) {
            return null;
        }
        return mockListeners.get(string);
    }

    public static Object getMockValue(String string) {
        if (!mockValues.containsKey(string)) {
            mockValues.put(string, new Double(0.0));
        }
        return mockValues.get(string);
    }

    private static interface IMockCommand {
        public void processCommand(Matcher var1, MockTangoConnection var2) throws Exception;
    }

    public static final class MVMockCommand
    implements IMockCommand {
        @Override
        public void processCommand(Matcher matcher, MockTangoConnection mockTangoConnection) throws Exception {
            mockTangoConnection.setValue(matcher.group(2), Double.parseDouble(matcher.group(3)));
            mockTangoConnection.notifyCommand(String.valueOf(matcher.group(2)) + " at " + matcher.group(3), matcher.group(0));
            mockTangoConnection.notifyEndCommand();
        }
    }

    public static final class ScanMockCommand
    implements IMockCommand {
        private NumberFormat format = new DecimalFormat("######0.0000");

        @Override
        public void processCommand(Matcher matcher, MockTangoConnection mockTangoConnection) throws Exception {
            if (!matcher.matches()) {
                mockTangoConnection.notifyCommand("Command '" + matcher.group(0) + "' not implemented in mock mode.", matcher.group(0));
                mockTangoConnection.notifyEndCommand();
                return;
            }
            double d = this.getDouble(matcher, 3);
            double d2 = this.getDouble(matcher, 5);
            double d3 = this.getDouble(matcher, 7);
            double d4 = this.getDouble(matcher, 9);
            double d5 = (d2 - d) / d3;
            mockTangoConnection.notifyCommand("  #\t" + matcher.group(2) + "\tDetector\tMonitor\tSeconds\tFlux I0", matcher.group(0));
            int n = 0;
            double d6 = d;
            while (d6 <= d2) {
                long l = System.currentTimeMillis();
                try {
                    Thread.sleep(Math.round(d4 * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
                long l2 = System.currentTimeMillis();
                double d7 = (double)(l2 - l) / 1000.0;
                mockTangoConnection.setValue(matcher.group(2), d6);
                mockTangoConnection.notifyCommand("  " + n + "\t" + this.format.format(d6) + "\t0\t\t0\t" + this.format.format(d7) + "\t0", matcher.group(0));
                ++n;
                d6 += d5;
            }
            mockTangoConnection.notifyEndCommand();
        }

        private double getDouble(Matcher matcher, int n) {
            try {
                return Double.parseDouble(matcher.group(n));
            }
            catch (Exception exception) {
                return Long.parseLong(matcher.group(n));
            }
        }
    }
}

