/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.factory;

import java.util.Collection;
import java.util.EventObject;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.dawb.tango.extensions.factory.TangoConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTangoConnection
implements TangoConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTangoConnection.class);
    private Collection<TangoConnectionListener> listeners;
    protected String attributeName;
    protected String hardwareUri;
    private int connectionCount;

    protected AbstractTangoConnection(String string, String string2) {
        this.attributeName = string2;
        this.hardwareUri = string;
        this.connectionCount = 1;
    }

    @Override
    public void addTangoConnectionListener(TangoConnectionListener tangoConnectionListener) {
        if (this.listeners == null) {
            this.listeners = new ConcurrentLinkedQueue<TangoConnectionListener>();
        }
        this.listeners.add(tangoConnectionListener);
    }

    @Override
    public void removeTangoConnectionListener(TangoConnectionListener tangoConnectionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(tangoConnectionListener);
    }

    protected boolean fireTangoConnectionListeners(TangoConnectionEvent tangoConnectionEvent) {
        if (this.listeners == null) {
            return false;
        }
        if (this.listeners.isEmpty()) {
            return false;
        }
        for (TangoConnectionListener tangoConnectionListener : this.listeners) {
            tangoConnectionListener.tangoEventPerformed(tangoConnectionEvent);
        }
        return true;
    }

    protected void fireTangoConnectionListeners(EventObject eventObject) {
        if (this.listeners == null) {
            return;
        }
        TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent((TangoConnection)this, eventObject);
        for (TangoConnectionListener tangoConnectionListener : this.listeners) {
            tangoConnectionListener.tangoEventPerformed(tangoConnectionEvent);
        }
    }

    protected void fireTangoConnectionListeners(Object object, String string) {
        if (this.listeners == null) {
            return;
        }
        try {
            TangoConnectionEvent tangoConnectionEvent = new TangoConnectionEvent(this, object, string);
            this.fireTangoConnectionListeners(tangoConnectionEvent);
        }
        catch (Exception exception) {
            logger.error("Cannot fire listeners!", (Throwable)exception);
        }
    }

    @Override
    public void dispose() throws Exception {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.connectionCount > 1) {
            --this.connectionCount;
            return;
        }
        TangoConnectionFactory.clearConnection(this);
    }

    @Override
    public String getUri() {
        return this.hardwareUri;
    }

    @Override
    public String getName() {
        return this.getUri().substring(this.getUri().lastIndexOf("/") + 1);
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public void incrementCount() {
        ++this.connectionCount;
    }
}

