/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors.spec;

import org.dawb.tango.extensions.editors.spec.ColorManager;
import org.dawb.tango.extensions.editors.spec.ISpecColorConstants;
import org.dawb.tango.extensions.editors.spec.NonRuleBasedDamagerRepairer;
import org.dawb.tango.extensions.editors.spec.SpecDoubleClickStrategy;
import org.dawb.tango.extensions.editors.spec.SpecScanner;
import org.dawb.tango.extensions.editors.spec.SpecTagScanner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SpecConfiguration
extends SourceViewerConfiguration {
    private SpecDoubleClickStrategy doubleClickStrategy;
    private SpecTagScanner tagScanner;
    private SpecScanner scanner;
    private ColorManager colorManager;

    public SpecConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__spec_comment", "__spec_scan"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new SpecDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected SpecScanner getDefaultScanner() {
        if (this.scanner == null) {
            this.scanner = new SpecScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ISpecColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected SpecTagScanner getSpecScanScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new SpecTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ISpecColorConstants.SPEC_SCAN))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getSpecScanScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__spec_scan");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__spec_scan");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer nonRuleBasedDamagerRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(ISpecColorConstants.SPEC_COMMENT)));
        presentationReconciler.setDamager((IPresentationDamager)nonRuleBasedDamagerRepairer, "__spec_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)nonRuleBasedDamagerRepairer, "__spec_comment");
        return presentationReconciler;
    }
}

