/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors.preferences;

import java.util.ArrayList;
import java.util.List;
import org.dawb.common.ui.widgets.LabelFieldEditor;
import org.dawb.common.util.ExpressionUtils;
import org.dawb.tango.extensions.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CalibrationPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.dawb.tango.extensions.calibration.preferences";
    private List<StringFieldEditor> editors;
    private BooleanFieldEditor use;

    public CalibrationPreferences() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.editors = new ArrayList<StringFieldEditor>(7);
        this.use = new BooleanFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.on", "Use calibration", this.getFieldEditorParent());
        this.addField((FieldEditor)this.use);
        StringFieldEditor stringFieldEditor = new StringFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.expression", "Calibration Expression", this.getFieldEditorParent());
        stringFieldEditor.getLabelControl(this.getFieldEditorParent()).setToolTipText("Expression to use in calibration, the variable p is used for pixel value and p0 for the first pixel.");
        this.addField((FieldEditor)stringFieldEditor);
        this.editors.add(stringFieldEditor);
        stringFieldEditor.getTextControl(this.getFieldEditorParent()).setForeground(Display.getCurrent().getSystemColor(9));
        new Label(this.getFieldEditorParent(), 258);
        new Label(this.getFieldEditorParent(), 258);
        this.addField((FieldEditor)new LabelFieldEditor("Coefficients:", this.getFieldEditorParent()));
        StringFieldEditor stringFieldEditor2 = new StringFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.a", "a", this.getFieldEditorParent());
        stringFieldEditor2.getLabelControl(this.getFieldEditorParent()).setToolTipText("Coefficient a used in the calibration expression.");
        this.addField((FieldEditor)stringFieldEditor2);
        this.editors.add(stringFieldEditor2);
        StringFieldEditor stringFieldEditor3 = new StringFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.b", "b", this.getFieldEditorParent());
        stringFieldEditor3.getLabelControl(this.getFieldEditorParent()).setToolTipText("Coefficient b used in the calibration expression.");
        this.addField((FieldEditor)stringFieldEditor3);
        this.editors.add(stringFieldEditor3);
        StringFieldEditor stringFieldEditor4 = new StringFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.c", "c", this.getFieldEditorParent());
        stringFieldEditor4.getLabelControl(this.getFieldEditorParent()).setToolTipText("Coefficient c used in the calibration expression.");
        this.addField((FieldEditor)stringFieldEditor4);
        this.editors.add(stringFieldEditor4);
        StringFieldEditor stringFieldEditor5 = new StringFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.d", "d", this.getFieldEditorParent());
        stringFieldEditor5.getLabelControl(this.getFieldEditorParent()).setToolTipText("Coefficient d used in the calibration expression.");
        this.addField((FieldEditor)stringFieldEditor5);
        this.editors.add(stringFieldEditor5);
        this.updateEnabled(Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.editors.preferences.calibration.on"));
        new Label(this.getFieldEditorParent(), 258);
        new Label(this.getFieldEditorParent(), 258);
        this.addField((FieldEditor)new LabelFieldEditor("", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("org.dawb.tango.extensions.editors.preferences.calibration.x.label", "X-axis label", this.getFieldEditorParent()));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (((FieldEditor)propertyChangeEvent.getSource()).getPreferenceName().equals("org.dawb.tango.extensions.editors.preferences.calibration.on")) {
            this.updateEnabled((Boolean)propertyChangeEvent.getNewValue());
        }
        this.checkState();
    }

    protected void checkState() {
        super.checkState();
        boolean bl = this.use.getBooleanValue();
        if (!bl) {
            this.setErrorMessage(null);
            this.setValid(true);
            return;
        }
        boolean bl2 = ExpressionUtils.isValidSyntax((String)this.editors.get(0).getStringValue());
        if (bl2) {
            this.editors.get(0).getTextControl(this.getFieldEditorParent()).setForeground(Display.getCurrent().getSystemColor(9));
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.editors.get(0).getTextControl(this.getFieldEditorParent()).setForeground(Display.getCurrent().getSystemColor(3));
            this.setErrorMessage("The expression '" + this.editors.get(0).getStringValue() + "' is not valid.");
            this.setValid(false);
        }
    }

    private void updateEnabled(boolean bl) {
        StringFieldEditor stringFieldEditor2;
        for (StringFieldEditor stringFieldEditor2 : this.editors) {
            stringFieldEditor2.setEnabled(bl, this.getFieldEditorParent());
        }
        stringFieldEditor2 = this.getFieldEditorParent().getChildren();
        int n = 0;
        while (n < ((StringFieldEditor)stringFieldEditor2).length) {
            if (stringFieldEditor2[n] instanceof Text) {
                stringFieldEditor2[n].setEnabled(bl);
            }
            ++n;
        }
        this.getFieldEditorParent().layout(true, true);
    }

    public void init(IWorkbench iWorkbench) {
    }
}

