/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors.actions;

import java.util.Arrays;
import java.util.List;
import org.dawb.common.ui.menu.CheckableActionGroup;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.editors.SharedMemoryEditor;
import org.dawb.tango.extensions.editors.SharedMemoryUtils;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedMemoryNamesAction
extends Action
implements IMenuCreator {
    private static final Logger logger = LoggerFactory.getLogger(SharedMemoryNamesAction.class);
    private Menu fMenu;
    private CheckableActionGroup group;

    SharedMemoryNamesAction() {
        super("Choose shared memory variable", 4);
        this.setMenuCreator(this);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin("icons/image_add.png"));
        this.setId(SharedMemoryNamesAction.class.getName());
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        this.group = new CheckableActionGroup();
        List<String> list = this.getSharedNames();
        for (String string : list) {
            this.addActionToMenu(this.fMenu, string);
        }
        return this.fMenu;
    }

    private List<String> getSharedNames() {
        SharedMemoryEditor sharedMemoryEditor = (SharedMemoryEditor)EclipseUtils.getActivePage().getActiveEditor();
        TangoConnection tangoConnection = sharedMemoryEditor.getTangoConnection();
        if (tangoConnection == null) {
            return Arrays.asList("Error - Tango Settings Invalid");
        }
        try {
            return SharedMemoryUtils.getSharedNames(tangoConnection);
        }
        catch (Exception exception) {
            logger.error("Cannot read shared names!", (Throwable)exception);
            sharedMemoryEditor.showOpenConfigurationMessage(exception.getMessage());
            return Arrays.asList("Error - Tango Settings Invalid");
        }
    }

    protected void addActionToMenu(Menu menu, String string) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)new SharedMemoryNameAction(string));
        actionContributionItem.fill(menu, -1);
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    public class SharedMemoryNameAction
    extends Action {
        public SharedMemoryNameAction(String string) {
            super(string, 2);
            SharedMemoryNamesAction.this.group.add((IAction)this);
        }

        public void run() {
            IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
            this.setChecked(true);
            if (iEditorPart instanceof SharedMemoryEditor) {
                try {
                    ((SharedMemoryEditor)iEditorPart).setMemoryName(this.getText());
                }
                catch (Exception exception) {
                    logger.error("Cannot change memory name!", (Throwable)exception);
                }
            }
        }
    }
}

