/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors.actions;

import org.dawb.common.ui.menu.CheckableActionGroup;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.editors.SharedMemoryEditor;
import org.dawb.tango.extensions.editors.actions.SharedMemoryNamesAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedMemoryActions {
    private static final Logger logger = LoggerFactory.getLogger(SharedMemoryActions.class);
    public static final Action monitoring;
    public static final Action sharedMemory;
    public static final Action history;
    public static final Action chunk;
    public static final Action oneD;
    public static final Action twoD;
    public static final Action tangoPrefs;
    public static final Action sharedPrefs;

    static {
        sharedMemory = new SharedMemoryNamesAction();
        monitoring = new Action("Start/Stop Monitoring", 2){

            public void run() {
                boolean bl;
                IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
                boolean bl2 = bl = !Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.monitoring.default.on");
                if (iEditorPart instanceof SharedMemoryEditor) {
                    try {
                        ((SharedMemoryEditor)iEditorPart).setMonitoring(bl);
                    }
                    catch (Exception exception) {
                        logger.error("Cannot change monitoring state shared memory", (Throwable)exception);
                    }
                }
                if (bl) {
                    monitoring.setImageDescriptor(Activator.getImageDescriptor("icons/control_stop_blue.png"));
                } else {
                    monitoring.setImageDescriptor(Activator.getImageDescriptor("icons/control_play_blue.png"));
                }
                Activator.getDefault().getPreferenceStore().setValue("org.dawb.tango.extensions.shared.mem.monitoring.default.on", bl);
            }
        };
        if (Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.monitoring.default.on")) {
            monitoring.setChecked(true);
            monitoring.setImageDescriptor(Activator.getImageDescriptor("icons/control_stop_blue.png"));
        } else {
            monitoring.setChecked(false);
            monitoring.setImageDescriptor(Activator.getImageDescriptor("icons/control_play_blue.png"));
        }
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        history = new Action("History mode, display 1 from N. See shared memory properties for settings.", 2){

            public void run() {
                Activator.getDefault().getPreferenceStore().setValue("org.dawb.tango.extensions.shared.mem.history.mode", true);
                IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
                if (iEditorPart instanceof SharedMemoryEditor) {
                    ((SharedMemoryEditor)iEditorPart).setHistoryMode(true);
                }
            }
        };
        checkableActionGroup.add((IAction)history);
        history.setImageDescriptor(Activator.getImageDescriptor("icons/history.gif"));
        chunk = new Action("Chunk mode, continously refresh the last chunk of spectra.", 2){

            public void run() {
                Activator.getDefault().getPreferenceStore().setValue("org.dawb.tango.extensions.shared.mem.history.mode", false);
                IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
                if (iEditorPart instanceof SharedMemoryEditor) {
                    ((SharedMemoryEditor)iEditorPart).setHistoryMode(false);
                }
            }
        };
        checkableActionGroup.add((IAction)chunk);
        chunk.setImageDescriptor(Activator.getImageDescriptor("icons/chunk.gif"));
        checkableActionGroup = new CheckableActionGroup();
        oneD = new Action("Plot memory in one dimension.", 2){

            public void run() {
                Activator.getDefault().getPreferenceStore().setValue("org.dawb.tango.extensions.shared.mem.image.mode", false);
                IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
                if (iEditorPart instanceof SharedMemoryEditor) {
                    ((SharedMemoryEditor)iEditorPart).setPlotType(PlotType.PT1D);
                }
            }
        };
        checkableActionGroup.add((IAction)oneD);
        oneD.setImageDescriptor(Activator.getImageDescriptor("icons/chart_line.png"));
        twoD = new Action("Plot memory as an image.", 2){

            public void run() {
                Activator.getDefault().getPreferenceStore().setValue("org.dawb.tango.extensions.shared.mem.image.mode", true);
                IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
                if (iEditorPart instanceof SharedMemoryEditor) {
                    ((SharedMemoryEditor)iEditorPart).setPlotType(PlotType.IMAGE);
                }
            }
        };
        checkableActionGroup.add((IAction)twoD);
        twoD.setImageDescriptor(Activator.getImageDescriptor("icons/picture.png"));
        tangoPrefs = new Action("Tango Preferences...", 1){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.dawb.common.ui.views.tangoPreferences", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        tangoPrefs.setImageDescriptor(Activator.getImageDescriptor("icons/tango_preferences.gif"));
        sharedPrefs = new Action("Shared Memory Preferences...", 1){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.dawb.tango.extensions.shared.preferences", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        sharedPrefs.setImageDescriptor(Activator.getImageDescriptor("icons/sharedprops.gif"));
    }

    public static void createActions(IContributionManager iContributionManager) {
        iContributionManager.add((IAction)sharedMemory);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(SharedMemoryActions.class.getName()) + ".sep0"));
        iContributionManager.add((IAction)monitoring);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(SharedMemoryActions.class.getName()) + ".sep1"));
        iContributionManager.add((IAction)history);
        iContributionManager.add((IAction)chunk);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(SharedMemoryActions.class.getName()) + ".sep2"));
        iContributionManager.add((IAction)oneD);
        iContributionManager.add((IAction)twoD);
        iContributionManager.add((IContributionItem)new Separator(String.valueOf(SharedMemoryActions.class.getName()) + ".sep3"));
        iContributionManager.add((IAction)sharedPrefs);
        iContributionManager.add((IAction)tangoPrefs);
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.image.mode");
        if (bl) {
            twoD.setChecked(true);
        } else {
            oneD.setChecked(true);
        }
        boolean bl2 = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.history.mode");
        if (bl2) {
            history.setChecked(true);
        } else {
            chunk.setChecked(true);
        }
    }
}

