/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors.actions;

import java.io.File;
import org.dawb.common.ui.util.EclipseUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSpecMonitorHandler
extends AbstractHandler
implements IWorkbenchWindowActionDelegate {
    private static final Logger logger = LoggerFactory.getLogger(OpenSpecMonitorHandler.class);

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        try {
            File file = File.createTempFile("sharedMemoryMonitor", "mon");
            file.createNewFile();
            IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
            IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(file);
            FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput(iFileStore);
            iWorkbenchPage.openEditor((IEditorInput)fileStoreEditorInput, "org.dawb.tango.extensions.sharedMemEditor", true);
        }
        catch (Exception exception) {
            throw new ExecutionException("Cannot open shared memory monitor!", (Throwable)exception);
        }
        return Boolean.TRUE;
    }

    public void run(IAction iAction) {
        try {
            this.execute(null);
        }
        catch (ExecutionException executionException) {
            logger.error("Cannot run action", (Throwable)executionException);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }
}

