/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors;

import fr.esrf.TangoApi.DeviceData;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.util.ExpressionFactory;
import org.dawb.common.util.IExpressionEvaluator;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.eclipse.jface.preference.IPreferenceStore;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class SharedMemoryUtils {
    public static List<AbstractDataset> getSharedMemoryValue(TangoConnection tangoConnection, String string, PlotType plotType) throws Exception {
        int n = Activator.getDefault().getPreferenceStore().getInt("org.dawb.tango.extensions.shared.mem.chunk.size");
        return SharedMemoryUtils.getSharedMemoryValue(tangoConnection, string, n, plotType);
    }

    public static List<AbstractDataset> getSharedMemoryValue(TangoConnection tangoConnection, String string, int n, PlotType plotType) throws Exception {
        if (tangoConnection == null) {
            return null;
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{TangoUtils.getSpecName().toLowerCase(), string});
        DeviceData deviceData2 = tangoConnection.executeCommand("GetArrayInfo", deviceData, false);
        int[] nArray = deviceData2.extractLongArray();
        if (plotType == PlotType.IMAGE) {
            deviceData = new DeviceData();
            deviceData.insert(new String[]{TangoUtils.getSpecName().toLowerCase(), string});
            if (nArray[2] == 1) {
                deviceData2 = tangoConnection.executeCommand(SharedMemoryUtils.getDoubleArrayCommand(), deviceData, false);
                double[] dArray = deviceData2.extractDoubleArray();
                return Arrays.asList(new DoubleDataset(dArray, new int[]{nArray[0], nArray[1]}));
            }
            deviceData2 = tangoConnection.executeCommand(SharedMemoryUtils.getLongArrayCommand(), deviceData, false);
            int[] nArray2 = deviceData2.extractLongArray();
            return Arrays.asList(new IntegerDataset(nArray2, new int[]{nArray[0], nArray[1]}));
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(n);
        String string2 = DateFormat.getDateTimeInstance().format(new Date());
        int n2 = 0;
        while (n2 < n) {
            DoubleDataset doubleDataset;
            Object[] objectArray;
            deviceData = new DeviceData();
            deviceData.insert(new String[]{TangoUtils.getSpecName().toLowerCase(), string, String.valueOf(n2)});
            if (nArray[2] == 1) {
                deviceData2 = tangoConnection.executeCommand(SharedMemoryUtils.getDoubleSliceCommand(), deviceData, false);
                objectArray = deviceData2.extractDoubleArray();
                doubleDataset = new DoubleDataset(objectArray, new int[]{objectArray.length});
            } else {
                deviceData2 = tangoConnection.executeCommand(SharedMemoryUtils.getLongSliceCommand(), deviceData, false);
                objectArray = deviceData2.extractLongArray();
                doubleDataset = new IntegerDataset((int[])objectArray, new int[]{objectArray.length});
            }
            doubleDataset.setName(String.valueOf(n2) + " (" + string2 + ")");
            arrayList.add((AbstractDataset)doubleDataset);
            ++n2;
        }
        return arrayList;
    }

    private static String getLongArrayCommand() {
        String string = System.getProperty("org.dawb.tango.extensions.shared.mem.long.array.cmd");
        if (string == null) {
            return "GetLongArray";
        }
        return string;
    }

    private static String getLongSliceCommand() {
        String string = System.getProperty("org.dawb.tango.extensions.shared.mem.long.slice.cmd");
        if (string == null) {
            return "GetLongRow";
        }
        return string;
    }

    private static String getDoubleArrayCommand() {
        String string = System.getProperty("org.dawb.tango.extensions.shared.mem.double.array.cmd");
        if (string == null) {
            return "GetDoubleArray";
        }
        return string;
    }

    private static String getDoubleSliceCommand() {
        String string = System.getProperty("org.dawb.tango.extensions.shared.mem.double.slice.cmd");
        if (string == null) {
            return "GetDoubleRow";
        }
        return string;
    }

    public static List<String> getSharedNames(TangoConnection tangoConnection) throws Exception {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(TangoUtils.getSpecName().toLowerCase());
        DeviceData deviceData2 = tangoConnection.executeCommand("GetArrayList", deviceData, false);
        List<String> list = Arrays.asList(deviceData2.extractStringArray());
        if (list.isEmpty()) {
            throw new Exception("Cannot get spec names from tango interface, perhaps the spec name of '" + TangoUtils.getSpecName().toLowerCase() + "' is incorrect or the uri of " + tangoConnection.getUri() + " is not connecting.");
        }
        return list;
    }

    public static IDataset getXAxis(AbstractDataset abstractDataset) throws Exception {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("org.dawb.tango.extensions.editors.preferences.calibration.on");
        if (!bl) {
            return AbstractDataset.arange((double)0.0, (int)abstractDataset.getSize());
        }
        return SharedMemoryUtils.getCalibrated((IDataset)abstractDataset, null, true);
    }

    public static IDataset getCalibrated(IDataset iDataset, Map<String, String> map, boolean bl) throws Exception {
        boolean bl2;
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        if (bl && !(bl2 = iPreferenceStore.getBoolean("org.dawb.tango.extensions.editors.preferences.calibration.on"))) {
            return AbstractDataset.arange((double)0.0, (double)iDataset.getSize(), (double)1.0, (int)3);
        }
        String string = iPreferenceStore.getString("org.dawb.tango.extensions.editors.preferences.calibration.expression");
        String string2 = iPreferenceStore.getString("org.dawb.tango.extensions.editors.preferences.calibration.x.label");
        double d = iPreferenceStore.getDouble("org.dawb.tango.extensions.editors.preferences.calibration.a");
        double d2 = iPreferenceStore.getDouble("org.dawb.tango.extensions.editors.preferences.calibration.b");
        double d3 = iPreferenceStore.getDouble("org.dawb.tango.extensions.editors.preferences.calibration.c");
        double d4 = iPreferenceStore.getDouble("org.dawb.tango.extensions.editors.preferences.calibration.d");
        double[] dArray = new double[iDataset.getSize()];
        IExpressionEvaluator iExpressionEvaluator = ExpressionFactory.createExpressionEvaluator();
        iExpressionEvaluator.setExpression(string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(7);
        int n = 0;
        while (n < dArray.length) {
            hashMap.clear();
            if (map != null) {
                hashMap.putAll(map);
            }
            hashMap.put("p", n);
            hashMap.put("p0", 0.0);
            hashMap.put("a", d);
            hashMap.put("b", d2);
            hashMap.put("c", d3);
            hashMap.put("d", d4);
            dArray[n] = iExpressionEvaluator.evaluate(hashMap);
            ++n;
        }
        DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[]{dArray.length});
        doubleDataset.setName(string2);
        return doubleDataset;
    }

    public static boolean isCalibrationUsed() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("org.dawb.tango.extensions.editors.preferences.calibration.on");
    }
}

