/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DeviceData;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.common.ui.widgets.ActionBarWrapper;
import org.dawb.common.util.io.FileUtils;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.editors.SharedMemoryUtils;
import org.dawb.tango.extensions.editors.actions.SharedMemoryActions;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class SharedMemoryEditor
extends EditorPart {
    private static Logger logger = LoggerFactory.getLogger(SharedMemoryEditor.class);
    private AbstractPlottingSystem plottingSystem;
    private Composite tools;
    private String memoryName;
    private boolean isMonitoring;
    private boolean isHistoryMode;
    private TangoConnection connection;
    private final BlockingDeque<List<AbstractDataset>> plotQueue = new LinkedBlockingDeque<List<AbstractDataset>>(7);
    private final List<AbstractDataset> history = new ArrayList<AbstractDataset>(31);
    private Thread monitoringThread;
    private PlotType plotType;

    public SharedMemoryEditor() {
        this.isMonitoring = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.monitoring.default.on");
        this.plotType = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.image.mode") ? PlotType.IMAGE : PlotType.PT1D;
        this.isHistoryMode = Activator.getDefault().getPreferenceStore().getBoolean("org.dawb.tango.extensions.shared.mem.history.mode");
        try {
            this.plottingSystem = PlottingFactory.getPlottingSystem();
            this.plottingSystem.setColorOption(AbstractPlottingSystem.ColorOption.NONE);
            this.plottingSystem.setDatasetChoosingRequired(false);
        }
        catch (Exception exception) {
            logger.error("Cannot locate any plotting systems!", (Throwable)exception);
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        super.setInput(iEditorInput);
        this.setPartName("Shared Memory");
    }

    public boolean isDirty() {
        return false;
    }

    public void setToolbarsVisible(final boolean bl) {
        if (this.tools == null || this.tools.isDisposed()) {
            return;
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SharedMemoryEditor.this.tools == null || SharedMemoryEditor.this.tools.isDisposed()) {
                    return;
                }
                GridUtils.setVisible((Control)SharedMemoryEditor.this.tools, (boolean)bl);
                SharedMemoryEditor.this.tools.getParent().layout(new Control[]{SharedMemoryEditor.this.tools});
                SharedMemoryEditor.this.tools.getParent().getParent().layout();
            }
        });
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridUtils.removeMargins((Composite)composite2);
        this.tools = new Composite(composite2, 0);
        this.tools.setLayout((Layout)new GridLayout(4, false));
        this.tools.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridUtils.removeMargins((Composite)this.tools);
        Text text = new Text(this.tools, 16384);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setEditable(false);
        GridUtils.setVisible((Control)text, (boolean)false);
        text.setBackground(this.tools.getBackground());
        this.plottingSystem.setPointControls(text);
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        ToolBar toolBar = toolBarManager.createControl(this.tools);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        SharedMemoryActions.createActions((IContributionManager)toolBarManager);
        ToolBarManager toolBarManager2 = new ToolBarManager(0x820000);
        ToolBar toolBar2 = toolBarManager2.createControl(this.tools);
        toolBar2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolBarManager toolBarManager3 = new ToolBarManager(0x820000);
        final ToolBar toolBar3 = toolBarManager3.createControl(this.tools);
        toolBar3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final MenuManager menuManager = new MenuManager();
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        ActionBarWrapper actionBarWrapper = new ActionBarWrapper((IToolBarManager)toolBarManager2, (IMenuManager)menuManager, null, (IActionBars2)iActionBars);
        String string = this.getEditorInput().getName();
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new FillLayout());
        this.plottingSystem.createPlotPart(composite3, string, (IActionBars)actionBarWrapper, PlotType.IMAGE, (IWorkbenchPart)this);
        Action action = new Action("", Activator.getImageDescriptor("/icons/DropDown.png")){

            public void run() {
                Menu menu = menuManager.createContextMenu((Control)toolBar3);
                menu.setVisible(true);
            }
        };
        toolBarManager3.add((IAction)action);
        toolBarManager.update(true);
        toolBarManager2.update(true);
        toolBarManager3.update(true);
        try {
            InputStream inputStream = EclipseUtils.getInputStream((IEditorInput)this.getEditorInput());
            StringBuffer stringBuffer = FileUtils.readFile((InputStream)inputStream);
            if (stringBuffer != null && stringBuffer.length() > 0) {
                this.setMemoryNameInternal(stringBuffer.toString());
            }
        }
        catch (Throwable throwable) {}
    }

    private void startMonitoring() throws Exception {
        this.plotQueue.clear();
        this.createConnection();
        this.createMonitoringThread();
        this.createPlotQueue();
        this.createFirstPlot();
    }

    private void createConnection() throws Exception {
        String string = TangoUtils.getHardwareAddress(Activator.getDefault().getPreferenceStore().getString("org.dawb.tango.extensions.shared.mem.uri"));
        try {
            this.connection = TangoConnectionFactory.openCommandConnection(string);
        }
        catch (ConnectionFailed connectionFailed) {
            this.showOpenConfigurationMessage(connectionFailed.getMessage());
        }
    }

    public void showOpenConfigurationMessage(String string) {
        boolean bl;
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.dawb.tango.extensions", string));
        if (this.getSite().getShell().isVisible() && (bl = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Cannot Connect to Tango", (String)"Cannot connect to the shared memory.\n\nWould you like to open the Tango Preferences?"))) {
            SharedMemoryActions.tangoPrefs.run();
        }
    }

    private void createFirstPlot() throws Exception {
        List<AbstractDataset> list = SharedMemoryUtils.getSharedMemoryValue(this.connection, this.getMemoryName(), this.plotType);
        if (list == null) {
            return;
        }
        this.addPlot(list);
    }

    private void stopMonitoring() throws Exception {
        if (this.connection != null) {
            this.connection.dispose();
        }
        this.connection = null;
        while (this.monitoringThread != null) {
            Thread.sleep(100L);
        }
        this.plotQueue.clear();
        this.plotQueue.add(Collections.EMPTY_LIST);
    }

    private synchronized void createMonitoringThread() {
        this.monitoringThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block7: {
                    while (true) {
                        if (SharedMemoryEditor.this.connection == null) break block7;
                        try {
                            DeviceData deviceData = new DeviceData();
                            String string = TangoUtils.getSpecName().toLowerCase();
                            String string2 = SharedMemoryEditor.this.getMemoryName();
                            deviceData.insert(new String[]{string, string2});
                            DeviceData deviceData2 = SharedMemoryEditor.this.connection.executeCommand("IsUpdated", deviceData, false);
                            if (deviceData2.extractLong() == 1) {
                                List<AbstractDataset> list = SharedMemoryUtils.getSharedMemoryValue(SharedMemoryEditor.this.connection, SharedMemoryEditor.this.getMemoryName(), SharedMemoryEditor.this.plotType);
                                if (list == null || list.isEmpty()) continue;
                                SharedMemoryEditor.this.plotQueue.clear();
                                SharedMemoryEditor.this.addPlot(list);
                            }
                            long l = Activator.getDefault().getPreferenceStore().getLong("org.dawb.tango.extensions.shared.mem.monitoring.frequency");
                            Thread.sleep(l);
                        }
                        catch (Exception exception) {
                            break block7;
                        }
                    }
                    finally {
                        SharedMemoryEditor.this.monitoringThread = null;
                    }
                }
            }
        }, "Thread for monitoring " + this.memoryName);
        this.monitoringThread.setDaemon(true);
        this.monitoringThread.setPriority(4);
        this.monitoringThread.start();
    }

    protected void addPlot(List<AbstractDataset> list) {
        if (this.isHistoryMode && this.plotType == PlotType.PT1D) {
            int n = Activator.getDefault().getPreferenceStore().getInt("org.dawb.tango.extensions.shared.mem.chunk.index");
            if (n > list.size() - 1 || n < 0) {
                n = list.size() - 1;
            }
            AbstractDataset abstractDataset = list.get(n);
            this.history.add(0, abstractDataset);
        } else {
            this.history.addAll(0, list);
        }
        while (this.history.size() > Activator.getDefault().getPreferenceStore().getInt("org.dawb.tango.extensions.shared.mem.history.size")) {
            this.history.remove(this.history.size() - 1);
        }
        this.plotQueue.add(this.history);
    }

    private void createPlotQueue() {
        Thread thread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 8[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "Plot Queue Job");
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    private static AbstractDataset createAxisDataset(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2;
            ++n2;
        }
        IntegerDataset integerDataset = new IntegerDataset(nArray, new int[]{n});
        return integerDataset;
    }

    protected void createCustomToolbarActionsRight(ToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator(String.valueOf(((Object)((Object)this)).getClass().getName()) + "Separator1"));
        Action action = new Action("Open editor preferences.", 1){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.edna.workbench.editors.preferencePage", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        action.setChecked(false);
        action.setImageDescriptor(Activator.getImageDescriptor("icons/application_view_columns.png"));
        toolBarManager.add((IAction)action);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.plotQueue.clear();
        this.plotQueue.add(Collections.EMPTY_LIST);
        if (this.connection != null) {
            try {
                this.connection.dispose();
            }
            catch (Exception exception) {
                logger.error("Cannot close connection " + this.connection, (Throwable)exception);
            }
        }
        if (this.plottingSystem != null) {
            this.plottingSystem.dispose();
        }
        this.plottingSystem = null;
        this.history.clear();
        super.dispose();
    }

    public String getMemoryName() {
        return this.memoryName;
    }

    public void setMemoryName(String string) throws Exception {
        this.memoryName = string;
        try {
            OutputStream outputStream = EclipseUtils.getOutputStream((IEditorInput)this.getEditorInput());
            FileUtils.write((OutputStream)outputStream, (String)string, (String)"UTF-8", (boolean)false);
        }
        catch (Throwable throwable) {}
        this.setMemoryNameInternal(string);
    }

    private void setMemoryNameInternal(String string) throws Exception {
        this.memoryName = string;
        this.setPartName("Monitor " + string);
        if (this.isMonitoring) {
            this.stopMonitoring();
            this.startMonitoring();
        }
    }

    public boolean isMonitoring() {
        return this.isMonitoring;
    }

    public void setMonitoring(boolean bl) throws Exception {
        this.isMonitoring = bl;
        if (!bl) {
            this.stopMonitoring();
        } else {
            this.startMonitoring();
        }
    }

    public void setPlotType(PlotType plotType) {
        this.plotType = plotType;
        try {
            this.createFirstPlot();
        }
        catch (Exception exception) {
            logger.error("Cannot do a plot", (Throwable)exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public TangoConnection getTangoConnection() {
        block6: {
            if (this.connection == null) {
                block5: {
                    try {
                        var1_1 = TangoUtils.getHardwareAddress(Activator.getDefault().getPreferenceStore().getString("org.dawb.tango.extensions.shared.mem.uri"));
                        this.connection = TangoConnectionFactory.openCommandConnection(var1_1);
                    }
                    catch (DevFailed var1_2) {
                        if (var1_2.errors == null || var1_2.errors.length <= 0) break block5;
                        var2_4 = 0;
                        ** while (var2_4 < var1_2.errors.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var3_5 = var1_2.errors[var2_4];
                        SharedMemoryEditor.logger.error(var3_5.desc);
                        ++var2_4;
                        continue;
                    }
                }
                SharedMemoryEditor.logger.error("Cannot create connection ", (Throwable)var1_2);
                break block6;
                catch (Exception var1_3) {
                    SharedMemoryEditor.logger.error("Cannot create connection ", (Throwable)var1_3);
                    return null;
                }
            }
        }
        return this.connection;
    }

    public boolean isHistoryMode() {
        return this.isHistoryMode;
    }

    public void setHistoryMode(boolean bl) {
        this.isHistoryMode = bl;
        if (!bl) {
            this.history.clear();
        }
    }

    static /* synthetic */ Logger access$5() {
        return logger;
    }

    static /* synthetic */ AbstractPlottingSystem access$6(SharedMemoryEditor sharedMemoryEditor) {
        return sharedMemoryEditor.plottingSystem;
    }

    static /* synthetic */ AbstractDataset access$7(int n) {
        return SharedMemoryEditor.createAxisDataset(n);
    }
}

