/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors;

import org.dawb.common.ui.util.GridUtils;
import org.dawb.tango.extensions.editors.DatasetChangedEvent;
import org.dawb.tango.extensions.editors.IDatasetListener;
import org.dawb.tango.extensions.editors.MultiScanComponent;
import org.dawb.tango.extensions.editors.MultiScanEditor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.Page;

public class MultiScanPage
extends Page
implements IAdaptable {
    private MultiScanComponent multiScanComponent;
    private final MultiScanEditor editor;
    private Composite content;

    public MultiScanPage(MultiScanEditor multiScanEditor) {
        this.editor = multiScanEditor;
    }

    public void createControl(Composite composite) {
        this.content = new Composite(composite, 0);
        this.content.setLayout((Layout)new GridLayout(1, false));
        GridUtils.removeMargins((Composite)this.content);
        this.multiScanComponent = new MultiScanComponent(this.editor.getPlottingSystem());
        this.multiScanComponent.createPartControl(this.content);
        this.multiScanComponent.addDatasetListener(new IDatasetListener(){

            @Override
            public void datasetSelectionChanged(DatasetChangedEvent datasetChangedEvent) {
                MultiScanPage.this.editor.updatePlot(datasetChangedEvent.getSelections());
            }
        });
        Control control = this.multiScanComponent.getViewer().getControl();
        Menu menu = this.editor.getMenuManager().createContextMenu(control);
        control.setMenu(menu);
        this.multiScanComponent.setData(this.editor.getData());
    }

    public Control getControl() {
        return this.content;
    }

    public void setFocus() {
        this.multiScanComponent.getViewer().getControl().setFocus();
    }

    public MultiScanComponent getMultiScanComponent() {
        return this.multiScanComponent;
    }

    public void dispose() {
        this.multiScanComponent.dispose();
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == String.class) {
            return "Data";
        }
        return null;
    }
}

