/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors;

import fr.esrf.TangoApi.ConnectionFailed;
import java.util.regex.Pattern;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.editors.MultiScanEditor;
import org.dawb.tango.extensions.editors.MultiScanPage;
import org.dawb.tango.extensions.editors.spec.SpecTextEditor;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.dawb.tango.extensions.factory.TangoConnectionListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiScanMultiEditor
extends MultiPageEditorPart
implements TangoConnectionListener {
    public static final String ID = "org.dawb.workbench.editors.AsciiEditor";
    private static final Logger logger = LoggerFactory.getLogger(MultiScanMultiEditor.class);
    private transient TangoConnection tangoConnection;
    private MultiScanEditor specEditor;
    private SpecTextEditor textEditor;
    private Pattern promptPattern;
    private boolean isConnected = false;
    private String specError = null;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    protected void createPages() {
        try {
            this.connect();
            this.specEditor = new MultiScanEditor(this.isConnected);
            this.addPage(0, (IEditorPart)this.specEditor, this.getEditorInput());
            this.setPageText(0, "Plot");
            this.textEditor = new SpecTextEditor();
            this.addPage(1, (IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(1, "Text");
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot initiate " + this.getClass().getName() + "!", (Throwable)partInitException);
        }
    }

    public void connect() {
        if (this.tangoConnection != null) {
            return;
        }
        this.promptPattern = Pattern.compile("\\d+\\." + TangoUtils.getSpecName() + ">");
        String string = TangoUtils.getSpecCommandAddress();
        try {
            this.tangoConnection = TangoConnectionFactory.openMonitoredCommandConnection(string, "Output");
            this.tangoConnection.addTangoConnectionListener(this);
            this.isConnected = true;
            this.specError = null;
        }
        catch (ConnectionFailed connectionFailed) {
            if (connectionFailed.errors != null && connectionFailed.errors.length > 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.dawb.tango.extensions", connectionFailed.errors[0].desc));
            }
            this.specError = "Cannot connect to tango session '" + string + "'";
            logger.error("Failed to connect to spec-tango " + string, (Throwable)connectionFailed);
        }
        catch (Throwable throwable) {
            this.specError = "Cannot connect to tango session '" + string + "'";
            logger.error("Failed to connect to spec-tango " + string, throwable);
            return;
        }
    }

    public void disconnect() {
        block6: {
            try {
                try {
                    if (this.tangoConnection != null) {
                        this.tangoConnection.removeTangoConnectionListener(this);
                        this.tangoConnection.dispose();
                    }
                    this.specError = null;
                }
                catch (Exception exception) {
                    this.specError = "Cannot disconnect to tango session '" + this.tangoConnection.getUri() + "'";
                    logger.error("Failed to disconnect from tango!", (Throwable)exception);
                    this.isConnected = false;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.isConnected = false;
                throw throwable;
            }
            this.isConnected = false;
        }
        this.tangoConnection = null;
    }

    public String getSpecError() {
        return this.specError;
    }

    public boolean toggleConnect() {
        if (this.isConnected) {
            this.disconnect();
        } else {
            this.connect();
        }
        return this.isConnected;
    }

    @Override
    public void tangoEventPerformed(final TangoConnectionEvent tangoConnectionEvent) {
        if (this.tangoConnection == null) {
            return;
        }
        if (this.promptPattern == null) {
            return;
        }
        if (tangoConnectionEvent.getErrorMessage() != null) {
            this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.dawb.tango.extensions", tangoConnectionEvent.getErrorMessage(), (Throwable)new Exception()));
                }
            });
            return;
        }
        try {
            String string = tangoConnectionEvent.getValue().extractString().trim();
            if (this.promptPattern.matcher(string).matches()) {
                return;
            }
            if (this.specEditor != null) {
                this.specEditor.addLine(string);
            }
            if (this.textEditor != null) {
                this.textEditor.addLine(string);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot update tango event " + tangoConnectionEvent, (Throwable)exception);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.textEditor.doSave(iProgressMonitor);
    }

    public void doSaveAs() {
        this.textEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setActivePage(int n) {
        super.setActivePage(n);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public void dispose() {
        super.dispose();
        this.disconnect();
        this.tangoConnection = null;
        this.specEditor = null;
        this.textEditor = null;
    }

    public String getSpecSessionName() {
        if (this.tangoConnection == null) {
            return null;
        }
        return this.tangoConnection.getName();
    }

    public MultiScanEditor getMultiScanEditor() {
        return this.specEditor;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == Page.class) {
            MultiScanEditor multiScanEditor = this.getMultiScanEditor();
            return new MultiScanPage(multiScanEditor);
        }
        return super.getAdapter(clazz);
    }
}

