/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.common.ui.views.monitor.actions.TangoPreferencesAction;
import org.dawb.common.ui.widgets.ActionBarWrapper;
import org.dawb.gda.extensions.spec.MultiScanDataParser;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.editors.MultiScanComponent;
import org.dawb.tango.extensions.editors.MultiScanMultiEditor;
import org.dawb.tango.extensions.editors.MultiScanPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public class MultiScanEditor
extends EditorPart
implements IReusableEditor {
    private static Logger logger = LoggerFactory.getLogger(MultiScanEditor.class);
    private AbstractPlottingSystem plottingSystem;
    private MultiScanDataParser data;
    private boolean isDefaultConnectedSpec;
    private Composite plot;
    private MenuManager menuMan;
    private boolean doingUpdate = false;

    public MultiScanEditor(boolean bl) {
        this.isDefaultConnectedSpec = bl;
        try {
            this.plottingSystem = PlottingFactory.getPlottingSystem();
            this.plottingSystem.setColorOption(AbstractPlottingSystem.ColorOption.BY_DATA);
        }
        catch (Exception exception) {
            logger.error("Cannot locate any plotting systems!", (Throwable)exception);
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite2.setLayout((Layout)gridLayout);
        GridUtils.removeMargins((Composite)composite2);
        Composite composite3 = new Composite(composite2, 131072);
        composite3.setLayout((Layout)new GridLayout(2, false));
        GridUtils.removeMargins((Composite)composite3);
        composite3.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        ToolBar toolBar = toolBarManager.createControl(composite3);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolBarManager toolBarManager2 = new ToolBarManager(0x820000);
        final ToolBar toolBar2 = toolBarManager2.createControl(composite3);
        toolBar2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.menuMan = new MenuManager();
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        ActionBarWrapper actionBarWrapper = new ActionBarWrapper((IToolBarManager)toolBarManager, null, null, (IActionBars2)iActionBars);
        this.createCustomMenuBarActionsRight(this.menuMan);
        this.createCustomToolbarActionsRight(toolBarManager2);
        Action action = new Action("", Activator.imageDescriptorFromPlugin("icons/DropDown.png")){

            public void run() {
                Menu menu = MultiScanEditor.this.menuMan.createContextMenu((Control)toolBar2);
                menu.setVisible(true);
            }
        };
        toolBarManager2.add((IAction)action);
        this.plot = new Composite(composite2, 2048);
        this.plot.setLayout((Layout)new FillLayout());
        this.plot.setLayoutData((Object)new GridData(4, 4, true, true));
        String string = this.getEditorInput().getName();
        this.plottingSystem.createPlotPart(this.plot, string, (IActionBars)actionBarWrapper, PlotType.PT1D, (IWorkbenchPart)this);
        if (toolBarManager != null) {
            toolBarManager.update(true);
        }
        if (toolBarManager2 != null) {
            toolBarManager2.update(true);
        }
    }

    private void createCustomMenuBarActionsRight(MenuManager menuManager) {
        menuManager.add((IAction)new Action("Unselect and collapse all"){

            public void run() {
                MultiScanEditor.this.plottingSystem.reset();
                MultiScanComponent multiScanComponent = MultiScanEditor.this.getMultiScanComponent(false);
                if (multiScanComponent == null) {
                    return;
                }
                multiScanComponent.clear();
            }
        });
        Action action = new Action("Preferences...", 1){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.edna.workbench.editors.preferencePage", null, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        };
        action.setImageDescriptor(Activator.imageDescriptorFromPlugin("icons/application_view_columns.png"));
        menuManager.add((IAction)action);
    }

    protected void createCustomToolbarActionsRight(ToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator(String.valueOf(((Object)((Object)this)).getClass().getName()) + "Separator1"));
        Action action = new Action("Disconnect from spec.", 2){

            public void run() {
                IEditorPart iEditorPart = EclipseUtils.getActiveEditor();
                if (iEditorPart instanceof MultiScanMultiEditor) {
                    boolean bl = ((MultiScanMultiEditor)iEditorPart).toggleConnect();
                    this.setChecked(bl);
                    if (bl) {
                        this.setText("Disconnect from spec.");
                    } else {
                        boolean bl2;
                        this.setText("Connect to spec.");
                        String string = ((MultiScanMultiEditor)iEditorPart).getSpecError();
                        if (string != null && (bl2 = MessageDialog.openQuestion((Shell)MultiScanEditor.this.getSite().getShell(), (String)"Cannot Connect", (String)(String.valueOf(string) + "\n\nWould you like to open the Tango Preferences and configure the connection?")))) {
                            try {
                                new TangoPreferencesAction().execute(null);
                            }
                            catch (Exception exception) {
                                logger.error("Cannot open Tango Preferences!", (Throwable)exception);
                            }
                        }
                    }
                }
            }
        };
        action.setChecked(this.isDefaultConnectedSpec);
        if (this.isDefaultConnectedSpec) {
            action.setText("Disconnect from spec.");
        } else {
            action.setText("Connect to spec.");
        }
        action.setImageDescriptor(Activator.imageDescriptorFromPlugin("icons/connect_spec.png"));
        toolBarManager.add((IAction)action);
    }

    protected void updatePlot(List<AbstractDataset> list) {
        if (this.doingUpdate) {
            return;
        }
        try {
            this.doingUpdate = true;
            if (list == null || list.size() < 1) {
                this.plottingSystem.reset();
                return;
            }
            final ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(list);
            IProgressService iProgressService = this.getEditorSite() != null ? (IProgressService)this.getSite().getService(IProgressService.class) : (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
            try {
                iProgressService.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        iProgressMonitor.beginTask("Updating selected DataSets", 100);
                        AbstractDataset abstractDataset = (AbstractDataset)arrayList.remove(0);
                        MultiScanEditor.this.plottingSystem.clear();
                        MultiScanEditor.this.plottingSystem.createPlot1D(abstractDataset, arrayList, iProgressMonitor);
                        iProgressMonitor.done();
                    }
                });
            }
            catch (Exception exception) {
                logger.error("Cannot create plot required.", (Throwable)exception);
            }
        }
        finally {
            this.doingUpdate = false;
        }
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        try {
            this.data = new MultiScanDataParser(EclipseUtils.getInputStream((IEditorInput)iEditorInput));
        }
        catch (Exception exception) {
            logger.error("Cannot read " + iEditorInput.getName(), (Throwable)exception);
        }
    }

    public void setFocus() {
        this.plot.setFocus();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.plottingSystem != null) {
            this.plottingSystem.dispose();
        }
        super.dispose();
    }

    public void addLine(String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        final MultiScanComponent multiScanComponent = this.getMultiScanComponent(false);
        if (multiScanComponent == null) {
            return;
        }
        final String string2 = this.data.processLine(string);
        if (string2 != null) {
            this.data.update(false);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    multiScanComponent.refresh(string2);
                }
            });
        }
    }

    public void setPlot(String string, String ... stringArray) {
        MultiScanComponent multiScanComponent = this.getMultiScanComponent(true);
        if (multiScanComponent == null) {
            return;
        }
        multiScanComponent.setPlot(string, stringArray);
    }

    private MultiScanComponent getMultiScanComponent(boolean bl) {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        PageBookView pageBookView = (PageBookView)iWorkbenchPage.findView("org.dawb.workbench.views.dataSetView");
        if (pageBookView == null && bl) {
            try {
                pageBookView = (PageBookView)iWorkbenchPage.showView("org.dawb.workbench.views.dataSetView");
            }
            catch (PartInitException partInitException) {
                return null;
            }
        }
        if (pageBookView == null) {
            return null;
        }
        IPage iPage = pageBookView.getCurrentPage();
        if (!(iPage instanceof MultiScanPage)) {
            return null;
        }
        return ((MultiScanPage)iPage).getMultiScanComponent();
    }

    public AbstractPlottingSystem getPlottingSystem() {
        return this.plottingSystem;
    }

    public MultiScanDataParser getData() {
        return this.data;
    }

    public MenuManager getMenuManager() {
        return this.menuMan;
    }
}

