/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.trace.ITraceListener;
import org.dawb.common.ui.plot.trace.TraceEvent;
import org.dawb.common.util.list.IdentityList;
import org.dawb.gda.extensions.spec.MultiScanDataParser;
import org.dawb.tango.extensions.editors.DatasetChangedEvent;
import org.dawb.tango.extensions.editors.IDatasetListener;
import org.dawb.tango.extensions.editors.MultiScanContentProvider;
import org.dawb.tango.extensions.editors.MultiScanLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public class MultiScanComponent
implements ICheckStateListener {
    private static final Logger logger = LoggerFactory.getLogger(MultiScanComponent.class);
    public static final String ID = "uk.ac.gda.views.nexus.NexusPlotView";
    protected CheckboxTreeViewer dataViewer;
    protected MultiScanDataParser data;
    protected AbstractPlottingSystem system;
    private Set<DefaultMutableTreeNode> checked;
    private List<AbstractDataset> selections;
    private List<IDatasetListener> listeners;

    public MultiScanComponent(AbstractPlottingSystem abstractPlottingSystem) {
        this.system = abstractPlottingSystem;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        if (composite.getLayout() instanceof GridLayout) {
            composite2.setLayoutData((Object)new GridData(1808));
        }
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.dataViewer = new CheckboxTreeViewer(composite2, 268503042);
        this.dataViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object object) {
                return false;
            }

            public boolean isChecked(Object object) {
                if (MultiScanComponent.this.checked == null) {
                    return false;
                }
                return MultiScanComponent.this.checked.contains(object);
            }
        });
        this.dataViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.dataViewer.addCheckStateListener((ICheckStateListener)this);
        this.dataViewer.setUseHashlookup(true);
        this.dataViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                Tree tree = (Tree)event.widget;
                TreeItem treeItem = (TreeItem)event.item;
                int n = tree.getClientArea().width;
                GC gC = event.gc;
                Color color = gC.getForeground();
                Color color2 = gC.getBackground();
                Object object = treeItem.getData();
                if (object == null) {
                    return;
                }
                Color color3 = ((ColumnLabelProvider)MultiScanComponent.this.dataViewer.getLabelProvider()).getBackground(object);
                if (color3 == null) {
                    color3 = Display.getCurrent().getSystemColor(1);
                }
                gC.setBackground(color3);
                Color color4 = ((ColumnLabelProvider)MultiScanComponent.this.dataViewer.getLabelProvider()).getForeground(object);
                if (color4 != null) {
                    String string = ((ColumnLabelProvider)MultiScanComponent.this.dataViewer.getLabelProvider()).getText(object);
                    gC.setForeground(color4);
                    gC.fillRectangle(0, event.y, n, event.height);
                    int n2 = 0;
                    if (event.index == 1) {
                        Point point = gC.textExtent(string);
                        n2 = Math.max(0, (event.height - point.y) / 2);
                    }
                    event.gc.drawText(string, event.x + treeItem.getBounds().x + 1, event.y + n2 + 3, false);
                    event.doit = false;
                }
                gC.setForeground(color);
                gC.setBackground(color2);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.createRightClickMenu();
        this.system.addTraceListener((ITraceListener)new ITraceListener.Stub(){

            public void tracesAltered(TraceEvent traceEvent) {
                MultiScanComponent.this.updateSelection();
            }
        });
    }

    public void setData(MultiScanDataParser multiScanDataParser) {
        this.data = multiScanDataParser;
        this.dataViewer.getTree().setItemCount(multiScanDataParser.getScanNames().size());
        this.dataViewer.setUseHashlookup(true);
        this.dataViewer.setContentProvider((IContentProvider)new MultiScanContentProvider());
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new MultiScanLabelProvider(this.system));
        this.dataViewer.setInput((Object)multiScanDataParser.getNode());
        this.dataViewer.refresh();
    }

    public void setFocus() {
        if (this.dataViewer != null && !this.dataViewer.getControl().isDisposed()) {
            this.dataViewer.getControl().setFocus();
        }
    }

    private void createRightClickMenu() {
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (this.checked == null) {
            this.checked = new HashSet<DefaultMutableTreeNode>(7);
        }
        if (this.selections == null) {
            this.selections = new IdentityList();
        }
        if (checkStateChangedEvent != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)checkStateChangedEvent.getElement();
            if (!checkStateChangedEvent.getChecked()) {
                this.checked.remove(defaultMutableTreeNode);
            } else {
                this.checked.add(defaultMutableTreeNode);
            }
            if (defaultMutableTreeNode.getUserObject() instanceof AbstractDataset) {
                AbstractDataset abstractDataset = (AbstractDataset)defaultMutableTreeNode.getUserObject();
                if (!checkStateChangedEvent.getChecked()) {
                    this.selections.remove(abstractDataset);
                } else if (!this.selections.contains(abstractDataset)) {
                    this.selections.add(abstractDataset);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof String) {
                int n = 0;
                while (n < defaultMutableTreeNode.getChildCount()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                    this.dataViewer.setChecked((Object)defaultMutableTreeNode2, checkStateChangedEvent.getChecked());
                    AbstractDataset abstractDataset = (AbstractDataset)defaultMutableTreeNode2.getUserObject();
                    if (checkStateChangedEvent.getChecked()) {
                        this.checked.add(defaultMutableTreeNode2);
                        if (!this.selections.contains(abstractDataset)) {
                            this.selections.add(abstractDataset);
                        }
                    } else {
                        this.checked.remove(defaultMutableTreeNode2);
                        this.selections.remove(abstractDataset);
                    }
                    ++n;
                }
            }
        } else {
            this.selections.clear();
        }
        this.updateSelection();
        this.dataViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MultiScanComponent.this.dataViewer.refresh();
            }
        });
    }

    private synchronized void updateSelection() {
        if (this.selections == null) {
            return;
        }
        this.fireDatasetListeners(this.selections);
    }

    public void addDatasetListener(IDatasetListener iDatasetListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IDatasetListener>(7);
        }
        this.listeners.add(iDatasetListener);
    }

    public void removeSelectionListener(IDatasetListener iDatasetListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(iDatasetListener);
    }

    private void fireDatasetListeners(List<AbstractDataset> list) {
        if (this.listeners == null) {
            return;
        }
        DatasetChangedEvent datasetChangedEvent = new DatasetChangedEvent(this.dataViewer, list);
        for (IDatasetListener iDatasetListener : this.listeners) {
            iDatasetListener.datasetSelectionChanged(datasetChangedEvent);
        }
    }

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.data != null) {
            this.data.clear();
        }
        this.data = null;
        if (this.dataViewer != null && !this.dataViewer.getControl().isDisposed()) {
            this.dataViewer.removeCheckStateListener((ICheckStateListener)this);
        }
        this.dataViewer = null;
    }

    public void refresh(String string) {
        if (this.dataViewer != null && !this.dataViewer.getControl().isDisposed()) {
            TreeNode treeNode = this.data.updateNode(string);
            this.dataViewer.refresh();
            if (treeNode != null) {
                TreeNode treeNode2;
                TreeNode treeNode3 = (TreeNode)this.dataViewer.getInput();
                int n = 0;
                while (n < treeNode3.getChildCount()) {
                    treeNode2 = (DefaultMutableTreeNode)treeNode3.getChildAt(n);
                    if (!((DefaultMutableTreeNode)treeNode2).getUserObject().equals(string)) {
                        this.dataViewer.setChecked((Object)treeNode2, false);
                        this.dataViewer.setSubtreeChecked((Object)treeNode2, false);
                    }
                    ++n;
                }
                this.dataViewer.setChecked((Object)treeNode, true);
                this.dataViewer.setExpandedElements(new Object[]{treeNode});
                this.dataViewer.setSubtreeChecked((Object)treeNode, true);
                IdentityList identityList = new IdentityList();
                treeNode2 = treeNode;
                int n2 = 0;
                while (n2 < treeNode2.getChildCount()) {
                    identityList.add((AbstractDataset)((DefaultMutableTreeNode)treeNode2.getChildAt(n2)).getUserObject());
                    ++n2;
                }
                this.fireDatasetListeners((List<AbstractDataset>)identityList);
            }
        }
    }

    public void clear() {
        this.dataViewer.collapseAll();
        this.dataViewer.setAllChecked(false);
    }

    public ColumnViewer getViewer() {
        return this.dataViewer;
    }

    protected void setPlot(String string, String ... stringArray) {
        if (this.selections == null) {
            this.selections = new IdentityList();
        }
        this.selections.clear();
        this.updateSelection();
        List<String> list = Arrays.asList(stringArray);
        Collection collection = this.data.getSets(string);
        for (AbstractDataset abstractDataset : collection) {
            if (!list.contains(abstractDataset.getName())) continue;
            this.selections.add(abstractDataset);
        }
        this.updateSelection();
    }
}

