/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.console;

import fr.esrf.TangoApi.ConnectionFailed;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.dawb.common.ui.DawbUtils;
import org.dawb.common.util.io.IOCollectionUtils;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.dawb.tango.extensions.factory.TangoConnectionListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TangoSpecPartitioner
implements IConsoleDocumentPartitioner,
TangoConnectionListener {
    protected static final String PROMPT_CATEGORY = "org.dawb.tango.extensions.console.PROMPT";
    protected static final String COMMENT_CATEGORY = "org.dawb.tango.extensions.console.COMMENT";
    protected static final String SCAN_CATEGORY = "org.dawb.tango.extensions.console.SCAN_NUMBERS";
    protected static final String COMMAND_CATEGORY = "org.dawb.tango.extensions.console.COMMAND";
    private static Logger logger = LoggerFactory.getLogger(TangoSpecPartitioner.class);
    private transient TangoConnection tangoConnection;
    private transient TextViewer textViewer;
    private Color green;
    private Color darkGrey;
    private Color blue;
    private Color bg;
    private Color darkBlue;
    private Color black;
    private IDocument document;
    private String specName;
    private int count = 0;
    private int prompt = 0;
    private List<String> undoStack;
    private ListIterator<String> stackNavigation;
    private Pattern promptPattern;

    public TangoSpecPartitioner(String string) {
        this.specName = string.toUpperCase();
        this.promptPattern = Pattern.compile("\\d+\\." + string + ">");
        this.black = Display.getCurrent().getSystemColor(2);
        this.green = Display.getCurrent().getSystemColor(5);
        this.darkBlue = Display.getCurrent().getSystemColor(10);
        this.darkGrey = Display.getCurrent().getSystemColor(15);
        this.blue = Display.getCurrent().getSystemColor(9);
        this.bg = Display.getCurrent().getSystemColor(1);
        this.undoStack = new Vector<String>(31);
        try {
            List list = (List)IOCollectionUtils.readCollection((String)(String.valueOf(DawbUtils.getDawbHome()) + string + ".collection"));
            this.undoStack.addAll(list);
        }
        catch (Throwable throwable) {}
    }

    public void connect(IDocument iDocument) {
        this.document = iDocument;
    }

    public void connectSpec() throws Exception {
        if (this.tangoConnection != null) {
            return;
        }
        String string = TangoUtils.getSpecCommandAddress();
        this.textViewer.setEditable(true);
        try {
            this.tangoConnection = TangoConnectionFactory.openMonitoredCommandConnection(string, "Output");
            this.tangoConnection.addTangoConnectionListener(this);
            this.document.set(this.getStartingText());
            this.updateStartConsolePosition();
        }
        catch (Exception exception) {
            this.document.set(exception.getMessage());
            this.textViewer.setEditable(false);
            logger.error("Failed to connect to spec-tango " + string, (Throwable)exception);
            throw exception;
        }
    }

    public void disconnect() {
        try {
            if (this.tangoConnection != null) {
                this.tangoConnection.removeTangoConnectionListener(this);
                this.tangoConnection.dispose();
            }
        }
        catch (Exception exception) {
            logger.error("Failed to disconnect from tango!", (Throwable)exception);
        }
        this.textViewer = null;
        this.tangoConnection = null;
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public boolean documentChanged(DocumentEvent documentEvent) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runCommand() {
        if (this.document == null) {
            return false;
        }
        String string = "";
        try {
            string = this.document.get(this.prompt, this.document.getLength() - this.prompt);
            string = string.replace("\n", "");
            if ("".equals(string)) {
                this.printNextSpecPrompt(false);
                return false;
            }
            this.addUndoableCommand(string);
            if (!this.isCommandValid(string)) {
                this.printNextSpecPrompt(false);
                return false;
            }
            this.tangoConnection.executeCommand("ExecuteCmd", string, true);
            this.setEditable(false);
            return false;
        }
        catch (ConnectionFailed connectionFailed) {
            if (connectionFailed.errors != null && connectionFailed.errors.length > 0) {
                this.printMessage("\n+" + connectionFailed.errors[0].desc);
            } else {
                this.printMessage("\nAn error occurred sending command: \"" + string + "\". It has not been run.\n" + connectionFailed.getMessage());
            }
            this.printNextSpecPrompt(false);
            return false;
        }
        catch (Exception exception) {
            logger.error("Cannot connect to tango spec server!", (Throwable)exception);
            this.printMessage("\nAn error occurred sending command: \"" + string + "\". It has not been run.\n" + exception.getMessage());
            this.printNextSpecPrompt(false);
        }
        return false;
    }

    private boolean isCommandValid(String string) {
        if ("help".equals(string)) {
            this.printMessage("\nApologies, the help menu is not available via remote spec terminal.\nA later version of spec remote terminal will have a help web page.");
            return false;
        }
        if ("config".equals(string)) {
            this.printMessage("\nThe 'config' command is not supported via remote spec terminal.\nPlease contact your beamline support to change hardware configuration.");
            return false;
        }
        return true;
    }

    @Override
    public void tangoEventPerformed(TangoConnectionEvent tangoConnectionEvent) {
        if (tangoConnectionEvent.isFinishedEvent()) {
            this.setEditable(true);
            if (tangoConnectionEvent.getErrorMessage() != null) {
                this.printMessage("\n" + tangoConnectionEvent.getErrorMessage());
            }
            this.printNextSpecPrompt(true);
        } else {
            try {
                String string = tangoConnectionEvent.getValue().extractString().trim();
                if ("".equals(string)) {
                    return;
                }
                if (this.promptPattern.matcher(string).matches() && !this.isEditable()) {
                    this.setEditable(true);
                    this.printNextSpecPrompt(true);
                    return;
                }
                this.printMessage("\n" + string);
                this.setCaretLocation(true);
                this.setEditable(false);
            }
            catch (Exception exception) {
                logger.error("Problem reading value from " + tangoConnectionEvent, (Throwable)exception);
            }
        }
    }

    private void addUndoableCommand(String string) throws Exception {
        try {
            if (this.undoStack.isEmpty()) {
                this.undoStack.add(0, string);
                IOCollectionUtils.saveCollection((String)(String.valueOf(DawbUtils.getDawbHome()) + this.specName + ".collection"), this.undoStack);
            } else if (!this.undoStack.get(0).equals(string)) {
                this.undoStack.add(0, string);
                IOCollectionUtils.saveCollection((String)(String.valueOf(DawbUtils.getDawbHome()) + this.specName + ".collection"), this.undoStack);
            }
            while (this.undoStack.size() > 100) {
                this.undoStack.remove(100);
            }
        }
        finally {
            this.resetCommandPosition();
        }
    }

    private void printNextSpecPrompt(boolean bl) {
        String string = this.getNextSpecPrompt(bl);
        this.safeAppend(string);
        this.setCaretLocation(true);
        this.resetCommandPosition();
    }

    private void clearCommand() {
        int n = this.document.getLength() - this.prompt;
        if (n < 0) {
            n = 0;
        }
        this.safeReplace(this.prompt, n, "");
    }

    private void printMessage(String string) {
        this.safeAppend(string);
    }

    private void safeAppend(String string) {
        this.safeReplace(this.document.getLength(), 0, string);
    }

    private void safeReplace(final int n, final int n2, final String string) {
        if (this.textViewer == null) {
            return;
        }
        if (this.textViewer.getTextWidget() == null) {
            return;
        }
        if (this.textViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (this.textViewer.getTextWidget().getDisplay().getThread() == null) {
            return;
        }
        if (Thread.currentThread() != this.textViewer.getTextWidget().getDisplay().getThread()) {
            this.textViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TangoSpecPartitioner.this.document.replace(n, n2, string);
                        TangoSpecPartitioner.this.textViewer.getTextWidget().setSelection(n, n);
                        int n3 = TangoSpecPartitioner.this.document.get().lastIndexOf("\n");
                        TangoSpecPartitioner.this.textViewer.getTextWidget().redrawRange(n3, TangoSpecPartitioner.this.document.getLength() - n3, false);
                    }
                    catch (BadLocationException badLocationException) {
                        logger.error("Cannot insert tango error", (Throwable)badLocationException);
                    }
                }
            });
        } else {
            try {
                this.document.replace(n, n2, string);
                this.textViewer.getTextWidget().setSelection(n, n);
                int n3 = this.document.get().lastIndexOf("\n");
                this.textViewer.getTextWidget().redrawRange(n3, this.document.getLength() - n3, false);
            }
            catch (BadLocationException badLocationException) {
                logger.error("Cannot insert tango error", (Throwable)badLocationException);
            }
        }
    }

    private void setEditable(final boolean bl) {
        if (this.textViewer == null) {
            return;
        }
        if (this.textViewer.getTextWidget() == null) {
            return;
        }
        if (this.textViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (this.textViewer.getTextWidget().getDisplay().getThread() == null) {
            return;
        }
        if (Thread.currentThread() != this.textViewer.getTextWidget().getDisplay().getThread()) {
            this.textViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TangoSpecPartitioner.this.textViewer.getTextWidget().setEditable(bl);
                }
            });
        } else {
            this.textViewer.getTextWidget().setEditable(bl);
        }
    }

    private boolean isEditable() {
        if (this.textViewer == null) {
            return false;
        }
        if (this.textViewer.getTextWidget() == null) {
            return false;
        }
        if (this.textViewer.getTextWidget().isDisposed()) {
            return false;
        }
        if (this.textViewer.getTextWidget().getDisplay().getThread() == null) {
            return false;
        }
        final ArrayList<Boolean> arrayList = new ArrayList<Boolean>(1);
        if (Thread.currentThread() != this.textViewer.getTextWidget().getDisplay().getThread()) {
            this.textViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    arrayList.add(TangoSpecPartitioner.this.textViewer.isEditable());
                }
            });
        } else {
            arrayList.add(this.textViewer.isEditable());
        }
        return (Boolean)arrayList.get(0);
    }

    private String getNextSpecPrompt(boolean bl) {
        if (bl) {
            ++this.count;
        }
        return "\n" + this.count + "." + this.specName + "> ";
    }

    public String[] getLegalContentTypes() {
        return new String[]{"__dftl_partition_content_type"};
    }

    public String getContentType(int n) {
        return "__dftl_partition_content_type";
    }

    public ITypedRegion[] computePartitioning(int n, int n2) {
        return new TypedRegion[]{new TypedRegion(n, n2, "__dftl_partition_content_type")};
    }

    public ITypedRegion getPartition(int n) {
        return new TypedRegion(n, 1, "__dftl_partition_content_type");
    }

    public boolean isReadOnly(int n) {
        if (this.document == null) {
            return false;
        }
        return this.document.getLength() == n;
    }

    public StyleRange[] getStyleRanges(int n, int n2) {
        try {
            Position position;
            int n3;
            int n4;
            Position[] positionArray;
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
            Position[] positionArray2 = null;
            positionArray2 = this.document.getPositions(COMMENT_CATEGORY);
            if (positionArray2 != null) {
                positionArray = positionArray2;
                n4 = positionArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    position = positionArray[n3];
                    if (position.overlapsWith(n, n2)) {
                        arrayList.add(new StyleRange(position.offset, position.length, this.darkGrey, this.bg));
                    }
                    ++n3;
                }
            }
            if ((positionArray2 = this.document.getPositions(SCAN_CATEGORY)) != null) {
                positionArray = positionArray2;
                n4 = positionArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    position = positionArray[n3];
                    if (position.overlapsWith(n, n2)) {
                        arrayList.add(new StyleRange(position.offset, position.length, this.blue, this.bg));
                    }
                    ++n3;
                }
            }
            if ((positionArray2 = this.document.getPositions(COMMAND_CATEGORY)) != null) {
                positionArray = positionArray2;
                n4 = positionArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    position = positionArray[n3];
                    if (position.overlapsWith(n, n2)) {
                        arrayList.add(new StyleRange(position.offset, position.length, this.darkBlue, this.bg));
                    }
                    ++n3;
                }
            }
            if ((positionArray2 = this.document.getPositions(PROMPT_CATEGORY)) != null) {
                positionArray = positionArray2;
                n4 = positionArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    position = positionArray[n3];
                    if (position.overlapsWith(n, n2)) {
                        arrayList.add(new StyleRange(position.offset, position.length, this.green, this.bg));
                    }
                    ++n3;
                }
            }
            return arrayList.toArray(new StyleRange[arrayList.size()]);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            logger.error("Cannot create styled ranges", (Throwable)badPositionCategoryException);
            return new StyleRange[0];
        }
    }

    private String getStartingText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\tWelcome to \"spec\" Remote Console - Beta\n");
        stringBuilder.append(this.getNextSpecPrompt(true));
        return stringBuilder.toString();
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    public void setTextViewer(TextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public int getPromptLocation() {
        return this.prompt;
    }

    private void updateStartConsolePosition() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Position thread interupted.");
                }
                TangoSpecPartitioner.this.setCaretLocation(true);
            }
        }, "Init position console");
        thread.start();
    }

    private void setCaretLocation(final boolean bl) {
        if (this.textViewer == null) {
            return;
        }
        if (this.textViewer.getTextWidget() == null) {
            return;
        }
        if (this.textViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (this.textViewer.getTextWidget().getDisplay().getThread() == null) {
            return;
        }
        this.textViewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                int n = TangoSpecPartitioner.this.document.getLength();
                TangoSpecPartitioner.this.textViewer.getTextWidget().setCaretOffset(n);
                TangoSpecPartitioner.this.textViewer.getTextWidget().setSelection(n, n);
                if (bl) {
                    TangoSpecPartitioner.this.prompt = n;
                }
            }
        });
    }

    public void resetCommandPosition() {
        this.stackNavigation = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void moveCommand(int n) {
        if (this.undoStack.isEmpty()) {
            return;
        }
        if (this.stackNavigation == null) {
            this.stackNavigation = this.undoStack.listIterator();
        }
        try {
            String string = "";
            if (n == -1) {
                if (!this.stackNavigation.hasNext()) return;
                string = this.stackNavigation.next();
            } else if (this.stackNavigation.hasPrevious()) {
                string = this.stackNavigation.previous();
            }
            this.clearCommand();
            this.safeAppend(string);
            this.setCaretLocation(false);
            return;
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.stackNavigation = null;
        }
    }
}

