/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.console;

import org.dawb.common.ui.views.monitor.actions.TangoPreferencesAction;
import org.dawb.tango.extensions.console.TangoSpecPartitioner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TangoSpecConsolePage
extends TextConsolePage {
    private static Logger logger = LoggerFactory.getLogger(TangoSpecConsolePage.class);
    private TangoSpecPartitioner partitioner;
    private static boolean isShowingError = false;

    public TangoSpecConsolePage(TextConsole textConsole, IConsoleView iConsoleView) {
        super(textConsole, iConsoleView);
    }

    protected TextConsoleViewer createViewer(Composite composite) {
        final TextConsoleViewer textConsoleViewer = super.createViewer(composite);
        this.partitioner.setTextViewer((TextViewer)textConsoleViewer);
        textConsoleViewer.getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (!textConsoleViewer.isEditable()) {
                    verifyEvent.doit = false;
                    return;
                }
                StyledText styledText = (StyledText)verifyEvent.getSource();
                if ("".equals(verifyEvent.text)) {
                    if (styledText.getCaretOffset() <= TangoSpecConsolePage.this.partitioner.getPromptLocation()) {
                        verifyEvent.doit = false;
                    }
                    return;
                }
                if (styledText.getCaretOffset() >= TangoSpecConsolePage.this.partitioner.getPromptLocation()) {
                    return;
                }
                verifyEvent.doit = false;
                try {
                    textConsoleViewer.getDocument().replace(textConsoleViewer.getDocument().getLength(), 0, verifyEvent.text);
                    styledText.setCaretOffset(textConsoleViewer.getDocument().getLength());
                    styledText.setSelection(textConsoleViewer.getDocument().getLength(), textConsoleViewer.getDocument().getLength());
                    int n = textConsoleViewer.getDocument().get().lastIndexOf("\n");
                    styledText.redrawRange(n, textConsoleViewer.getDocument().getLength() - n, false);
                }
                catch (BadLocationException badLocationException) {
                    logger.error("Cannot append text to document", (Throwable)badLocationException);
                }
            }
        });
        textConsoleViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                if (!textConsoleViewer.isEditable()) {
                    verifyEvent.doit = false;
                    return;
                }
                if (verifyEvent.keyCode == 13) {
                    TangoSpecConsolePage.this.partitioner.runCommand();
                    verifyEvent.doit = false;
                    return;
                }
                if (verifyEvent.keyCode == 0x1000001) {
                    TangoSpecConsolePage.this.partitioner.moveCommand(-1);
                    verifyEvent.doit = false;
                    return;
                }
                if (verifyEvent.keyCode == 0x1000002) {
                    TangoSpecConsolePage.this.partitioner.moveCommand(1);
                    verifyEvent.doit = false;
                    return;
                }
                if (verifyEvent.keyCode == 0x1000003) {
                    StyledText styledText = (StyledText)verifyEvent.getSource();
                    if (styledText.getCaretOffset() <= TangoSpecConsolePage.this.partitioner.getPromptLocation()) {
                        verifyEvent.doit = false;
                    }
                    return;
                }
                if (verifyEvent.keyCode == 0x1000004) {
                    return;
                }
                TangoSpecConsolePage.this.partitioner.resetCommandPosition();
            }
        });
        try {
            this.partitioner.connectSpec();
        }
        catch (Exception exception) {
            if (isShowingError) {
                return textConsoleViewer;
            }
            isShowingError = true;
            try {
                boolean bl = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Cannot Connect", (String)"Cannot connect through tango to spec with the current settings.\n\nWould you like to open the Tango Preferences and configure the connection?");
                if (bl) {
                    try {
                        new TangoPreferencesAction().execute(null);
                    }
                    catch (Exception exception2) {
                        logger.error("Cannot open Tango Preferences!", (Throwable)exception2);
                    }
                }
            }
            finally {
                isShowingError = false;
            }
            {
            }
        }
        return textConsoleViewer;
    }

    public TangoSpecPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(TangoSpecPartitioner tangoSpecPartitioner) {
        this.partitioner = tangoSpecPartitioner;
    }
}

