/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.console;

import org.dawb.common.ui.views.monitor.actions.TangoPreferencesAction;
import org.dawb.tango.extensions.Activator;
import org.dawb.tango.extensions.console.TangoSpecConsolePage;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class TangoSpecConsoleActions
implements IConsolePageParticipant {
    private Action preferences;
    private Action stop;
    private IActionBars bars;
    private TangoSpecConsolePage page;

    public void init(IPageBookViewPage iPageBookViewPage, final IConsole iConsole) {
        if (!(iPageBookViewPage instanceof TangoSpecConsolePage)) {
            return;
        }
        this.page = (TangoSpecConsolePage)iPageBookViewPage;
        this.bars = iPageBookViewPage.getSite().getActionBars();
        this.preferences = new Action("Tango Preferences...", Activator.imageDescriptorFromPlugin("icons/tango_preferences.gif")){

            public void run() {
                try {
                    new TangoPreferencesAction().execute(null);
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        };
        this.stop = new Action("Stop spec session", Activator.imageDescriptorFromPlugin("icons/stop_spec_console.gif")){

            public void run() {
                IConsoleManager iConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
                iConsoleManager.removeConsoles(new IConsole[]{iConsole});
            }
        };
        this.bars.getMenuManager().add((IContributionItem)new Separator());
        this.bars.getMenuManager().add((IAction)this.preferences);
        IToolBarManager iToolBarManager = this.bars.getToolBarManager();
        iToolBarManager.appendToGroup("launchGroup", (IAction)this.stop);
        iToolBarManager.appendToGroup("launchGroup", (IAction)this.preferences);
        this.bars.updateActionBars();
    }

    public void dispose() {
        this.preferences = null;
        this.stop = null;
        this.bars = null;
        this.page = null;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public void activated() {
        this.updateVis();
    }

    public void deactivated() {
        this.updateVis();
    }

    private void updateVis() {
        if (this.page == null) {
            return;
        }
        boolean bl = this.page.getViewer().getTextWidget().isFocusControl();
        this.stop.setEnabled(bl);
        this.preferences.setEnabled(bl);
        this.bars.updateActionBars();
    }
}

