/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions.console;

import org.dawb.gda.extensions.spec.SpecSyntax;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.console.TangoSpecConsolePage;
import org.dawb.tango.extensions.console.TangoSpecPartitioner;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TangoSpecConsole
extends TextConsole {
    private static Logger logger = LoggerFactory.getLogger(TangoSpecConsole.class);
    public static final String ID = "org.dawb.tango.extensions.TangoSpecConsole";
    private TangoSpecPartitioner partitioner = new TangoSpecPartitioner(TangoUtils.getSpecName());

    public TangoSpecConsole(String string, ImageDescriptor imageDescriptor, boolean bl) {
        super(string, TangoSpecConsole.class.getName(), imageDescriptor, bl);
        this.getDocument().addPositionCategory("org.dawb.tango.extensions.console.PROMPT");
        this.getDocument().addPositionCategory("org.dawb.tango.extensions.console.COMMENT");
        this.getDocument().addPositionCategory("org.dawb.tango.extensions.console.SCAN_NUMBERS");
        this.getDocument().addPositionCategory("org.dawb.tango.extensions.console.COMMAND");
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
        String string2 = "\\d+\\." + TangoUtils.getSpecName().toUpperCase() + ">";
        this.addPatternMatchListener(new RegExListener(string2, "org.dawb.tango.extensions.console.PROMPT"));
        this.addPatternMatchListener(new RegExListener(SpecSyntax.COMMENT.pattern(), "org.dawb.tango.extensions.console.COMMENT"));
        this.addPatternMatchListener(new RegExListener(SpecSyntax.SCAN_LINE.pattern(), "org.dawb.tango.extensions.console.SCAN_NUMBERS"));
        this.addPatternMatchListener(new RegExListener(SpecSyntax.CMD.pattern(), "org.dawb.tango.extensions.console.COMMAND"));
    }

    public IPageBookViewPage createPage(IConsoleView iConsoleView) {
        TangoSpecConsolePage tangoSpecConsolePage = new TangoSpecConsolePage(this, iConsoleView);
        tangoSpecConsolePage.setPartitioner(this.partitioner);
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.dawb.common.ui");
        scopedPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.dawb.remote.session.mock")) {
                    IConsoleManager iConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
                    iConsoleManager.removeConsoles(new IConsole[]{TangoSpecConsole.this});
                }
            }
        });
        return tangoSpecConsolePage;
    }

    public void dispose() {
        super.dispose();
        this.partitioner.disconnect();
    }

    public void init() {
        super.init();
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public class RegExListener
    implements IPatternMatchListener {
        private String regex;
        private String category;
        private int stagger;

        public RegExListener(String string, String string2) {
            this(string, string2, 0);
        }

        public RegExListener(String string, String string2, int n) {
            this.regex = string;
            this.category = string2;
            this.stagger = n;
        }

        public void matchFound(PatternMatchEvent patternMatchEvent) {
            try {
                Position position = new Position(patternMatchEvent.getOffset() + this.stagger, patternMatchEvent.getLength() - this.stagger);
                TangoSpecConsole.this.getDocument().addPosition(this.category, position);
            }
            catch (Exception exception) {
                logger.error("Cannot add position", (Throwable)exception);
            }
        }

        public String getPattern() {
            return this.regex;
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return null;
        }

        public void connect(TextConsole textConsole) {
        }

        public void disconnect() {
        }
    }
}

