/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.tango.extensions;

import fr.esrf.TangoApi.ConnectionFailed;
import java.util.regex.Matcher;
import org.dawb.common.ui.Activator;
import org.dawb.gda.extensions.spec.SpecSyntax;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TangoUtils {
    public static String getHardwareAddress(String string) {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        StringBuffer stringBuffer = new StringBuffer("//");
        stringBuffer.append(iPreferenceStore.getString("org.dawb.server.name"));
        stringBuffer.append(":");
        stringBuffer.append(iPreferenceStore.getInt("org.dawb.server.port"));
        stringBuffer.append("/");
        stringBuffer.append(iPreferenceStore.getString("org.dawb.beamline.name"));
        stringBuffer.append("/");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getBracketedCommand(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.startsWith("eval('")) {
            stringBuilder.append("eval('");
        }
        stringBuilder.append(string);
        if (!string.startsWith("eval('") && !string.endsWith("')")) {
            stringBuilder.append("')");
        }
        return stringBuilder.toString();
    }

    public static Matcher getBracketedMatcher(String string) {
        Matcher matcher = SpecSyntax.CMD.matcher(string);
        if (matcher.matches()) {
            return matcher;
        }
        return null;
    }

    public static String getSpecName() {
        String string;
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.dawb.common.ui");
        boolean bl = scopedPreferenceStore.getBoolean("org.dawb.remote.session.mock");
        if (bl) {
            string = "SPEC_mock";
        } else {
            string = scopedPreferenceStore.getString("org.dawb.spec.session.name");
            string = string.toUpperCase();
        }
        return string;
    }

    public static String getSpecCommandAddress() {
        return TangoUtils.getHardwareAddress("spec/" + TangoUtils.getSpecName().toLowerCase());
    }

    public static String getMessageFromException(String string, Exception exception) {
        if (exception instanceof ConnectionFailed) {
            ConnectionFailed connectionFailed = (ConnectionFailed)exception;
            if (connectionFailed.errors != null && connectionFailed.errors.length > 0) {
                return connectionFailed.errors[0].desc;
            }
            return "An error occurred sending command: \"" + string + "\". It has not been run.\n" + connectionFailed.getMessage();
        }
        return exception.getMessage();
    }
}

