/*
 * Decompiled with CFR 0.152.
 */
package diva.util.xml;

import com.microstar.xml.XmlParser;
import diva.util.LoggableOp;
import diva.util.xml.XmlDocument;
import diva.util.xml.XmlElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;

public class XmlWriter
extends LoggableOp {
    private String _xmlVersion = "1.0";
    private XmlParser _parser;

    public void setXMLVersion(String v) {
        this._xmlVersion = v;
    }

    public void write(XmlDocument document) throws IOException {
        FileWriter out;
        URL url = document.getURL();
        if (url != null) {
            if (!url.getProtocol().equals("file")) {
                throw new IOException("XmlWriter can only write to file:/ URLs");
            }
            out = new FileWriter(url.getFile());
        } else {
            File file = document.getFile();
            if (file != null) {
                out = new FileWriter(file);
            } else {
                throw new IOException("XmlDocument has no URL or File");
            }
        }
        this.write(document, out);
    }

    public void write(XmlDocument document, Writer out) throws IOException {
        out.write("<?xml version=\"" + this._xmlVersion + "\" standalone=\"no\"?>");
        out.write("\n");
        out.write("<!DOCTYPE " + document.getRoot().getType());
        String pubid = document.getDTDPublicID();
        String sysid = document.getDTDSystemID();
        if (pubid == null) {
            if (sysid == null) {
                if (document.getDTD() != null) {
                    out.write(" [\n" + document.getDTD() + "\n]");
                }
            } else {
                out.write(" SYSTEM \"" + sysid + "\"");
            }
        } else {
            out.write(" PUBLIC \"" + pubid + "\"\n\t\"" + sysid + "\"");
        }
        out.write(">\n\n");
        this.write(document.getRoot(), out, "");
        out.flush();
    }

    public void write(XmlElement e, Writer out, String prefix) throws IOException {
        e.writeXML(out, prefix);
    }

    public void writeDTD(XmlDocument document, Writer out) throws IOException {
        String dtd = document.getDTD();
        if (dtd != null) {
            out.write(dtd);
            return;
        }
        this._parser = document._parser;
        this.writeDTDNotations(out);
        this.writeDTDEntities(out);
        this.writeDTDElements(out);
        out.flush();
    }

    public void writeDTDNotations(Writer out) throws IOException {
        Enumeration notationNames = this._parser.declaredNotations();
        while (notationNames.hasMoreElements()) {
            String nname = (String)notationNames.nextElement();
            String extId = this.makeExternalIdentifiers(this._parser.getNotationPublicId(nname), this._parser.getNotationSystemId(nname));
            out.write("<!NOTATION " + nname + 32 + extId + ">\n");
        }
    }

    public void writeDTDEntities(Writer out) throws IOException {
        Enumeration entityNames = this._parser.declaredEntities();
        while (entityNames.hasMoreElements()) {
            String ename = (String)entityNames.nextElement();
            if (ename.startsWith("%")) continue;
            String value = null;
            switch (this._parser.getEntityType(ename)) {
                case 1: {
                    value = this.makeLiteral(this._parser.getEntityValue(ename));
                    break;
                }
                case 2: {
                    value = String.valueOf(this.makeExternalIdentifiers(this._parser.getEntityPublicId(ename), this._parser.getEntitySystemId(ename))) + "NDATA " + this._parser.getEntityNotationName(ename);
                    break;
                }
                case 3: {
                    value = this.makeExternalIdentifiers(this._parser.getEntityPublicId(ename), this._parser.getEntitySystemId(ename));
                }
            }
            out.write("<!ENTITY " + ename + ' ' + value + ">\n");
        }
    }

    public void writeDTDElements(Writer out) throws IOException {
        Enumeration elementNames = this._parser.declaredElements();
        while (elementNames.hasMoreElements()) {
            String contentSpec = "ANY";
            String elname = (String)elementNames.nextElement();
            switch (this._parser.getElementContentType(elname)) {
                case 2: {
                    contentSpec = "EMPTY";
                    break;
                }
                case 1: {
                    contentSpec = "ANY";
                    break;
                }
                case 3: 
                case 4: {
                    contentSpec = this._parser.getElementContentModel(elname);
                }
            }
            out.write("\n<!ELEMENT " + elname + ' ' + contentSpec + ">\n");
            this.writeDTDAttributes(elname, out);
            out.write("");
        }
    }

    void writeDTDAttributes(String elname, Writer out) throws IOException {
        Enumeration attributeNames = this._parser.declaredAttributes(elname);
        if (attributeNames == null) {
            return;
        }
        out.write("<!ATTLIST " + elname);
        while (attributeNames.hasMoreElements()) {
            String aname = (String)attributeNames.nextElement();
            String type = this.makeAttributeType(elname, aname);
            String value = this.makeAttributeValue(elname, aname);
            out.write("\n          " + aname + ' ' + type + ' ' + value);
        }
        out.write(">\n");
    }

    String makeAttributeType(String elname, String aname) {
        switch (this._parser.getAttributeType(elname, aname)) {
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 9: {
                return this._parser.getAttributeEnumeration(elname, aname);
            }
            case 10: {
                return "NOTATION " + this._parser.getAttributeEnumeration(elname, aname);
            }
        }
        return null;
    }

    String makeAttributeValue(String elname, String aname) {
        switch (this._parser.getAttributeDefaultValueType(elname, aname)) {
            case 2: {
                return "#IMPLIED";
            }
            case 1: {
                return this.makeLiteral(this._parser.getAttributeDefaultValue(elname, aname));
            }
            case 3: {
                return "#REQUIRED";
            }
            case 4: {
                return "#FIXED " + this.makeLiteral(this._parser.getAttributeDefaultValue(elname, aname));
            }
        }
        return null;
    }

    String makeExternalIdentifiers(String pubid, String sysid) {
        String extId = "";
        if (pubid != null) {
            extId = "PUBLIC " + this.makeLiteral(pubid);
            if (sysid != null) {
                extId = String.valueOf(extId) + ' ' + this.makeLiteral(sysid);
            }
        } else {
            extId = "SYSTEM " + this.makeLiteral(sysid);
        }
        return extId;
    }

    String makeLiteral(String data) {
        char[] ch = data.toCharArray();
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int i = 0;
        while (i < ch.length) {
            if (ch[i] == '\"') {
                buf.append("&#22;");
            } else if (ch[i] > '\u007f') {
                buf.append("&#" + ch[i] + ";");
            } else {
                buf.append(ch[i]);
            }
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }
}

