/*
 * Decompiled with CFR 0.152.
 */
package diva.util.jester;

import diva.util.jester.TestFailedException;

public abstract class TestCase {
    private String _name;
    private long _startTime = 0L;
    private long _stopTime = 0L;

    public TestCase(String name) {
        this._name = name;
    }

    public abstract void check() throws TestFailedException;

    public void assertExpr(boolean passed, String msg) throws TestFailedException {
        if (!passed) {
            throw new TestFailedException(msg);
        }
    }

    public void assertEquals(Object first, Object second, String msg) throws TestFailedException {
        if (!first.equals(second)) {
            throw new TestFailedException(msg, first, second);
        }
    }

    public void fail(String msg) throws TestFailedException {
        throw new TestFailedException(msg);
    }

    public int getExecutionTime() {
        int diff = (int)(this._stopTime - this._startTime);
        if (this._startTime != 0L && diff == 0) {
            return 1;
        }
        return diff;
    }

    public String getName() {
        return this._name;
    }

    public void init() throws Exception {
    }

    public abstract void run() throws Exception;

    public void startTimer() {
        this._startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        this._stopTime = System.currentTimeMillis();
    }
}

