/*
 * Decompiled with CFR 0.152.
 */
package diva.util;

import java.io.PrintStream;

public class LoggableOp {
    private PrintStream _err = System.err;
    protected boolean _verbose = false;
    private int _warnCount;
    private int _errCount;
    private int _indent = 0;
    private String _tab = "    ";

    public int getErrorCount() {
        return this._errCount;
    }

    public PrintStream getErrorStream() {
        return this._err;
    }

    public int getWarningCount() {
        return this._warnCount;
    }

    public int getLineNumber() {
        return -1;
    }

    public void logError(String msg) {
        this.logError("ERROR", msg, null);
    }

    public void logError(String id, String msg) {
        this.logError(id, msg, null);
    }

    public void logError(String id, String msg, String detail) {
        int linenum = this.getLineNumber();
        this._err.print(String.valueOf(id) + ":");
        if (linenum >= 0) {
            this._err.print(String.valueOf(linenum) + ":");
        }
        this._err.println(" " + msg);
        if (detail != null) {
            this._err.println("                " + detail + "\n");
        }
        ++this._errCount;
    }

    public void logInfo(String msg) {
        this.logInfo(null, msg);
    }

    public void logInfo(String id, String msg) {
        int linenum;
        int i = this._indent;
        while (i > 0) {
            this._err.print(this._tab);
            --i;
        }
        if (id != null) {
            this._err.print(String.valueOf(id) + ":");
        }
        if ((linenum = this.getLineNumber()) >= 0) {
            this._err.print(String.valueOf(linenum) + ":");
        }
        this._err.println(" " + msg);
    }

    public void indent() {
        ++this._indent;
    }

    public final boolean isVerbose() {
        return this._verbose;
    }

    public void reset() {
        this._indent = 0;
        this._errCount = 0;
        this._warnCount = 0;
    }

    public void setErrorStream(PrintStream err) {
        this._err = err;
    }

    public void setVerbose(boolean v) {
        this._verbose = v;
    }

    public void unindent() {
        --this._indent;
    }

    public void logWarning(String msg) {
        this.logWarning("Warning", msg, null);
    }

    public void logWarning(String id, String msg) {
        this.logWarning(id, msg, null);
    }

    public void logWarning(String id, String msg, String detail) {
        int linenum = this.getLineNumber();
        this._err.print(String.valueOf(id) + ":");
        if (linenum >= 0) {
            this._err.print(String.valueOf(linenum) + ":");
        }
        this._err.println(" " + msg);
        if (detail != null) {
            this._err.println("                " + detail + "\n");
        }
        ++this._warnCount;
    }
}

