/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import diva.gui.BasicPage;
import diva.gui.MultipageModel;
import diva.gui.Page;
import diva.util.ModelParser;
import java.io.CharArrayReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;

public class MultipageParser
extends HandlerBase {
    public static final String PUBLIC_ID = "-//UC Berkeley//DTD multipage 1//EN";
    public static final String DTD_URL = "http://www.gigascale.org/diva/dtd/multipage.dtd";
    public static final String DTD_1 = "<!ELEMENT multipage (page*)> <!ATTLIST multipage title CDATA #REQUIRED> <!ELEMENT page (#PCDATA)> <!ATTLIST page title CDATA #REQUIRED num CDATA #REQUIRED>";
    public static final String TITLE_TAG = "title";
    public static final String MULTIPAGE_TAG = "multipage";
    public static final String PAGE_TAG = "page";
    public static final String PAGE_TITLE_TAG = "title";
    public static final String PAGE_NUM_TAG = "num";
    private ModelParser _modelParser;
    private XmlParser _parser;
    private MultipageModel _multi;
    private Page _currentPage;
    private HashMap _currentAttributes = new HashMap();

    public MultipageParser(ModelParser pageParser) {
        this._modelParser = pageParser;
    }

    public void attribute(String name, String value, boolean isSpecified) throws Exception {
        this._currentAttributes.put(name, value);
    }

    public void charData(char[] chars, int offset, int length) throws Exception {
        Object model = this._modelParser.parse(new CharArrayReader(chars, offset, length));
        this._currentPage.setModel(model);
    }

    public void endElement(String name) throws Exception {
        if (name.equalsIgnoreCase(PAGE_TAG)) {
            this._multi.addPage(this._currentPage);
            this._currentPage = null;
        } else if (!name.equalsIgnoreCase(MULTIPAGE_TAG)) {
            String err = "Error: unknown end element \"" + name + "\"";
            throw new RuntimeException(err);
        }
    }

    public void startElement(String name) throws Exception {
        if (!name.equalsIgnoreCase(MULTIPAGE_TAG)) {
            if (name.equalsIgnoreCase(PAGE_TAG)) {
                String label = (String)this._currentAttributes.get("title");
                this._currentPage = new BasicPage(this._multi, label);
            } else {
                String err = "Error: unknown start element \"" + name + "\"";
                throw new RuntimeException(err);
            }
        }
    }

    public Object resolveEntity(String publicID, String systemID) {
        if (publicID != null && publicID.equals(PUBLIC_ID)) {
            return new StringReader(DTD_1);
        }
        return null;
    }

    public void parse(Reader reader, MultipageModel multi) throws Exception {
        this._multi = multi;
        this._parser = new XmlParser();
        this._parser.setHandler((XmlHandler)this);
        this._parser.parse(null, null, reader);
    }
}

