/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.toolbox;

import diva.graph.GraphEvent;
import diva.graph.GraphListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GraphEventMulticaster
implements GraphListener {
    private List _listeners = new LinkedList();

    public void add(GraphListener l) {
        this._listeners.add(l);
    }

    public void dispatchEvent(GraphEvent e) {
        switch (e.getID()) {
            case 11: {
                this.edgeHeadChanged(e);
                break;
            }
            case 12: {
                this.edgeTailChanged(e);
                break;
            }
            case 20: {
                this.nodeAdded(e);
                break;
            }
            case 21: {
                this.nodeRemoved(e);
                break;
            }
            case 30: {
                this.structureChanged(e);
            }
        }
    }

    public void edgeHeadChanged(GraphEvent e) {
        Iterator i = this.listeners();
        while (i.hasNext()) {
            GraphListener l = (GraphListener)i.next();
            l.edgeHeadChanged(e);
        }
    }

    public void edgeTailChanged(GraphEvent e) {
        Iterator i = this.listeners();
        while (i.hasNext()) {
            GraphListener l = (GraphListener)i.next();
            l.edgeTailChanged(e);
        }
    }

    public Iterator listeners() {
        return this._listeners.iterator();
    }

    public void nodeAdded(GraphEvent e) {
        Iterator i = this.listeners();
        while (i.hasNext()) {
            GraphListener l = (GraphListener)i.next();
            l.nodeAdded(e);
        }
    }

    public void nodeRemoved(GraphEvent e) {
        Iterator i = this.listeners();
        while (i.hasNext()) {
            GraphListener l = (GraphListener)i.next();
            l.nodeRemoved(e);
        }
    }

    public void remove(GraphListener l) {
        this._listeners.remove(l);
    }

    public void structureChanged(GraphEvent e) {
        Iterator i = this.listeners();
        while (i.hasNext()) {
            GraphListener l = (GraphListener)i.next();
            l.structureChanged(e);
        }
    }
}

