/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.modular;

import diva.graph.GraphEvent;
import diva.graph.GraphUtilities;
import diva.graph.MutableGraphModel;
import diva.graph.modular.ModularGraphModel;
import diva.graph.modular.MutableEdgeModel;
import diva.graph.modular.MutableNodeModel;
import java.util.Iterator;

public abstract class MutableModularGraphModel
extends ModularGraphModel
implements MutableGraphModel {
    public MutableModularGraphModel(Object root) {
        super(root);
    }

    public boolean acceptHead(Object edge, Object node) {
        return this.getMutableEdgeModel(edge).acceptHead(edge, node);
    }

    public boolean acceptTail(Object edge, Object node) {
        return this.getMutableEdgeModel(edge).acceptTail(edge, node);
    }

    public void addNode(Object eventSource, Object node, Object parent) {
        Object prevParent = this.getMutableNodeModel(node).getParent(node);
        this.getMutableNodeModel(node).setParent(node, parent);
        GraphEvent e = new GraphEvent(eventSource, 20, node, prevParent);
        this.dispatchGraphEvent(e);
    }

    public void connectEdge(Object eventSource, Object edge, Object tailNode, Object headNode) {
        Object prevTail = this.getMutableEdgeModel(edge).getTail(edge);
        Object prevHead = this.getMutableEdgeModel(edge).getHead(edge);
        this.getMutableEdgeModel(edge).setHead(edge, headNode);
        this.getMutableEdgeModel(edge).setTail(edge, tailNode);
        GraphEvent e1 = new GraphEvent(eventSource, 11, edge, prevHead);
        this.dispatchGraphEvent(e1);
        GraphEvent e2 = new GraphEvent(eventSource, 12, edge, prevTail);
        this.dispatchGraphEvent(e2);
    }

    public void disconnectEdge(Object eventSource, Object edge) {
        GraphEvent e;
        MutableEdgeModel model = this.getMutableEdgeModel(edge);
        Object head = model.getHead(edge);
        Object tail = model.getTail(edge);
        model.setTail(edge, null);
        model.setHead(edge, null);
        if (head != null) {
            e = new GraphEvent(eventSource, 11, edge, head);
            this.dispatchGraphEvent(e);
        }
        if (tail != null) {
            e = new GraphEvent(eventSource, 12, edge, tail);
            this.dispatchGraphEvent(e);
        }
    }

    public MutableEdgeModel getMutableEdgeModel(Object edge) {
        return (MutableEdgeModel)this.getEdgeModel(edge);
    }

    public MutableNodeModel getMutableNodeModel(Object node) {
        return (MutableNodeModel)this.getNodeModel(node);
    }

    public void removeNode(Object eventSource, Object node) {
        Object edge;
        Iterator i = GraphUtilities.partiallyContainedEdges(node, this);
        while (i.hasNext()) {
            edge = i.next();
            this.disconnectEdge(eventSource, edge);
        }
        i = this.outEdges(node);
        while (i.hasNext()) {
            edge = i.next();
            this.disconnectEdge(eventSource, edge);
        }
        i = this.inEdges(node);
        while (i.hasNext()) {
            edge = i.next();
            this.disconnectEdge(eventSource, edge);
        }
        Object prevParent = this.getMutableNodeModel(node).getParent(node);
        this.getMutableNodeModel(node).setParent(node, null);
        GraphEvent e = new GraphEvent(eventSource, 21, node, prevParent);
        this.dispatchGraphEvent(e);
    }

    public void setEdgeHead(Object eventSource, Object edge, Object head) {
        Object prevHead = this.getMutableEdgeModel(edge).getHead(edge);
        this.getMutableEdgeModel(edge).setHead(edge, head);
        GraphEvent e = new GraphEvent(eventSource, 11, edge, prevHead);
        this.dispatchGraphEvent(e);
    }

    public void setEdgeTail(Object eventSource, Object edge, Object tail) {
        Object prevTail = this.getMutableEdgeModel(edge).getTail(edge);
        this.getMutableEdgeModel(edge).setTail(edge, tail);
        GraphEvent e = new GraphEvent(eventSource, 12, edge, prevTail);
        this.dispatchGraphEvent(e);
    }
}

