/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.modular;

import diva.graph.AbstractGraphModel;
import diva.graph.modular.CompositeModel;
import diva.graph.modular.EdgeModel;
import diva.graph.modular.NodeModel;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class ModularGraphModel
extends AbstractGraphModel {
    private Object _root = null;

    public ModularGraphModel(Object root) {
        this._root = root;
    }

    public boolean containsNode(Object composite, Object node) {
        return composite.equals(this.getNodeModel(node).getParent(node));
    }

    public abstract CompositeModel getCompositeModel(Object var1);

    public abstract EdgeModel getEdgeModel(Object var1);

    public Object getHead(Object edge) {
        return this.getEdgeModel(edge).getHead(edge);
    }

    public int getNodeCount(Object composite) {
        return this.getCompositeModel(composite).getNodeCount(composite);
    }

    public abstract NodeModel getNodeModel(Object var1);

    public Object getParent(Object node) {
        NodeModel model;
        if (node != this._root && (model = this.getNodeModel(node)) != null) {
            return model.getParent(node);
        }
        return null;
    }

    public abstract Object getProperty(Object var1, String var2);

    public Object getRoot() {
        return this._root;
    }

    public abstract Object getSemanticObject(Object var1);

    public Object getTail(Object edge) {
        return this.getEdgeModel(edge).getTail(edge);
    }

    public boolean isDirected(Object edge) {
        return this.getEdgeModel(edge).isDirected(edge);
    }

    public boolean isComposite(Object o) {
        return this.getCompositeModel(o) != null;
    }

    public boolean isEdge(Object o) {
        return this.getEdgeModel(o) != null;
    }

    public boolean isNode(Object o) {
        return this.getNodeModel(o) != null;
    }

    public Iterator nodes(Object composite) {
        return this.getCompositeModel(composite).nodes(composite);
    }

    public Iterator nodesBeforeEdges(Object composite) {
        return this.getCompositeModel(composite).nodesBeforeEdges(composite);
    }

    public Iterator nodesAfterEdges(Object composite) {
        return this.getCompositeModel(composite).nodesAfterEdges(composite);
    }

    public Iterator inEdges(Object node) {
        NodeModel model = this.getNodeModel(node);
        if (model != null) {
            return model.inEdges(node);
        }
        return new LinkedList().iterator();
    }

    public Iterator outEdges(Object node) {
        NodeModel model = this.getNodeModel(node);
        if (model != null) {
            return model.outEdges(node);
        }
        return new LinkedList().iterator();
    }

    public abstract void setProperty(Object var1, String var2, Object var3);

    public abstract void setSemanticObject(Object var1, Object var2);
}

