/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasUtilities;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.canvas.FigureLayer;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionModel;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphViewEvent;
import diva.graph.MutableGraphModel;
import diva.graph.NodeController;
import diva.graph.NodeInteractor;
import diva.graph.NodeRenderer;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class BasicNodeController
implements NodeController {
    private Interactor _interactor;
    private NodeRenderer _renderer;
    private GraphController _controller;

    public BasicNodeController(GraphController controller) {
        this._controller = controller;
        SelectionModel sm = controller.getSelectionModel();
        this._interactor = new NodeInteractor(controller, sm);
    }

    public void addNode(Object node) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        model.addNode(this._controller, node, model.getRoot());
        this.drawNode(node);
    }

    public void addNode(Object node, double x, double y) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        model.addNode(this._controller, node, model.getRoot());
        Figure nf = this.drawNode(node);
        CanvasUtilities.translateTo(nf, x, y);
    }

    public void addNode(Object node, Object parent) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        model.addNode(this._controller, node, parent);
        this.drawNode(node, parent);
    }

    public void addNode(Object node, Object parent, double x, double y) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        model.addNode(this._controller, node, parent);
        Figure nf = this.drawNode(node, parent);
        CanvasUtilities.translateTo(nf, x, y);
    }

    public void clearNode(Object node) {
        Object edge;
        GraphModel model = this._controller.getGraphModel();
        Iterator i = model.outEdges(node);
        while (i.hasNext()) {
            edge = i.next();
            this._controller.clearEdge(edge);
        }
        i = model.inEdges(node);
        while (i.hasNext()) {
            edge = i.next();
            this._controller.clearEdge(edge);
        }
        Figure f = this._controller.getFigure(node);
        if (f != null) {
            CanvasComponent container = f.getParent();
            f.setUserObject(null);
            this._controller.setFigure(node, null);
            while (container instanceof FigureDecorator) {
                FigureDecorator decorator = (FigureDecorator)container;
                container = container.getParent();
                ((FigureContainer)container).undecorate(decorator);
            }
            if (container instanceof FigureLayer) {
                ((FigureLayer)container).remove(f);
            } else if (container instanceof CompositeFigure) {
                ((CompositeFigure)container).remove(f);
            }
        }
    }

    public Figure drawNode(Object node) {
        Point2D center;
        Figure oldFigure = this._controller.getFigure(node);
        if (oldFigure != null) {
            center = oldFigure.getOrigin();
            this.clearNode(node);
        } else {
            center = null;
        }
        Figure newFigure = this._renderNode(node);
        this._controller.getGraphPane().getForegroundLayer().add(newFigure);
        this._drawChildren(node);
        if (center != null) {
            CanvasUtilities.translateTo(newFigure, center.getX(), center.getY());
        }
        this._controller.dispatch(new GraphViewEvent(this, 20, node));
        return newFigure;
    }

    public Figure drawNode(Object node, Object parent) {
        Figure newFigure = this._renderNode(node);
        CompositeFigure cf = (CompositeFigure)this._controller.getFigure(parent);
        cf.add(newFigure);
        this._drawChildren(node);
        this._controller.dispatch(new GraphViewEvent(this, 20, node));
        return newFigure;
    }

    public GraphController getController() {
        return this._controller;
    }

    public Interactor getNodeInteractor() {
        return this._interactor;
    }

    public NodeRenderer getNodeRenderer() {
        return this._renderer;
    }

    public void removeNode(Object node) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        if (model.isComposite(node)) {
            Iterator i = model.nodes(node);
            while (i.hasNext()) {
                Object insideNode = i.next();
                this._controller.clearNode(insideNode);
            }
        }
        this.clearNode(node);
        model.removeNode(this._controller, node);
        this._controller.getGraphPane().repaint();
    }

    public void setNodeInteractor(Interactor interactor) {
        this._interactor = interactor;
    }

    public void setNodeRenderer(NodeRenderer renderer) {
        this._renderer = renderer;
    }

    protected Figure _renderNode(Object node) {
        Figure newFigure = this.getNodeRenderer().render(node);
        newFigure.setInteractor(this.getNodeInteractor());
        newFigure.setUserObject(node);
        this._controller.setFigure(node, newFigure);
        return newFigure;
    }

    protected void _drawChildren(Object node) {
        GraphModel model = this.getController().getGraphModel();
        if (model.isComposite(node)) {
            Iterator children = model.nodes(node);
            while (children.hasNext()) {
                Object child = children.next();
                this._controller.drawNode(child, node);
            }
        }
    }
}

