/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.graph.GraphEvent;
import diva.graph.GraphListener;
import diva.graph.GraphModel;
import diva.graph.toolbox.GraphEventMulticaster;
import javax.swing.SwingUtilities;

public abstract class AbstractGraphModel
implements GraphModel {
    private boolean _dispatch = true;
    protected GraphEventMulticaster _graphListeners = new GraphEventMulticaster();

    public void addGraphListener(GraphListener l) {
        this._graphListeners.add(l);
    }

    public void dispatchGraphEvent(final GraphEvent e) {
        if (this._dispatch) {
            if (SwingUtilities.isEventDispatchThread()) {
                this._graphListeners.dispatchEvent(e);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractGraphModel.this._graphListeners.dispatchEvent(e);
                    }
                });
            }
        }
    }

    public void removeGraphListener(GraphListener l) {
        this._graphListeners.remove(l);
    }

    public void setDispatchEnabled(boolean val) {
        this._dispatch = val;
    }
}

