/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.Figure;
import diva.canvas.interactor.BasicSelectionModel;
import diva.canvas.interactor.SelectionModel;
import diva.graph.EdgeController;
import diva.graph.GraphController;
import diva.graph.GraphEvent;
import diva.graph.GraphListener;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.GraphUtilities;
import diva.graph.GraphViewEvent;
import diva.graph.GraphViewListener;
import diva.graph.NodeController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractGraphController
implements GraphController {
    private HashMap _map = new HashMap();
    private GraphPane _pane;
    private GraphModel _model;
    private SelectionModel _selectionModel = new BasicSelectionModel();
    private ChangeListener _localListener = new ChangeListener();
    private List _graphViewListenerList = new LinkedList();

    public void addEdge(Object edge, Object node, int end, double x, double y) {
        this.getEdgeController(edge).addEdge(edge, node, end, x, y);
    }

    public void addEdge(Object edge, Object tail, Object head) {
        this.getEdgeController(edge).addEdge(edge, tail, head);
    }

    public void addGraphViewListener(GraphViewListener l) {
        this._graphViewListenerList.add(l);
    }

    public void addNode(Object node) {
        NodeController nc = this.getNodeController(node);
        nc.addNode(node);
    }

    public void addNode(Object node, double x, double y) {
        NodeController nc = this.getNodeController(node);
        nc.addNode(node, x, y);
    }

    public void addNode(Object node, Object parent) {
        NodeController nc = this.getNodeController(node);
        nc.addNode(node, parent);
    }

    public void addNode(Object node, Object parent, double x, double y) {
        NodeController nc = this.getNodeController(node);
        nc.addNode(node, parent, x, y);
    }

    public void clear() {
    }

    public void clearEdge(Object edge) {
        EdgeController ec = this.getEdgeController(edge);
        ec.clearEdge(edge);
    }

    public void clearNode(Object node) {
        NodeController nc = this.getNodeController(node);
        nc.clearNode(node);
    }

    public Figure drawEdge(Object edge) {
        EdgeController ec = this.getEdgeController(edge);
        Figure f = ec.drawEdge(edge);
        return f;
    }

    public Figure drawNode(Object node) {
        NodeController nc = this.getNodeController(node);
        Figure f = nc.drawNode(node);
        return f;
    }

    public Figure drawNode(Object node, Object parent) {
        NodeController nc = this.getNodeController(node);
        Figure f = nc.drawNode(node, parent);
        return f;
    }

    public abstract EdgeController getEdgeController(Object var1);

    public abstract NodeController getNodeController(Object var1);

    public GraphModel getGraphModel() {
        return this._model;
    }

    public GraphPane getGraphPane() {
        return this._pane;
    }

    public Figure getFigure(Object semanticObj) {
        return (Figure)this._map.get(semanticObj);
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void removeEdge(Object edge) {
        this.getEdgeController(edge).removeEdge(edge);
    }

    public void removeGraphViewListener(GraphViewListener l) {
        this._graphViewListenerList.remove(l);
    }

    public void removeNode(Object node) {
        this.getNodeController(node).removeNode(node);
    }

    public void rerender() {
        Object node2;
        Object object;
        LinkedList selectedEdges = new LinkedList();
        LinkedList selectedNodes = new LinkedList();
        for (Figure figure : new HashSet(this._map.values())) {
            object = figure.getUserObject();
            if (!this._model.isEdge(object) || GraphUtilities.isPartiallyContainedEdge(object, this._model.getRoot(), this._model)) continue;
            if (this._selectionModel.containsSelection(figure)) {
                this._selectionModel.removeSelection(figure);
            }
            this.clearEdge(object);
            this._map.remove(object);
        }
        for (Figure figure : new HashSet(this._map.values())) {
            object = figure.getUserObject();
            if (!this._model.isNode(object) || GraphUtilities.isContainedNode(object, this._model.getRoot(), this._model)) continue;
            if (this._selectionModel.containsSelection(figure)) {
                this._selectionModel.removeSelection(figure);
            }
            this.clearNode(object);
            this._map.remove(object);
        }
        Iterator edges = GraphUtilities.totallyContainedEdges(this._model.getRoot(), this._model);
        while (edges.hasNext()) {
            Object edge = edges.next();
            Figure oldFigure = this.getFigure(edge);
            boolean selected = this._selectionModel.containsSelection(oldFigure);
            if (!selected) continue;
            selectedEdges.add(edge);
        }
        for (Object node2 : GraphUtilities.nodeSet(this._model.getRoot(), this._model)) {
            Figure oldFigure = this.getFigure(node2);
            boolean selected = this._selectionModel.containsSelection(oldFigure);
            if (!selected) continue;
            selectedNodes.add(node2);
        }
        this._selectionModel.clearSelection();
        Iterator nodes = this._model.nodesBeforeEdges(this._model.getRoot());
        while (nodes.hasNext()) {
            node2 = nodes.next();
            this.drawNode(node2);
        }
        edges = GraphUtilities.partiallyContainedEdges(this._model.getRoot(), this._model);
        while (edges.hasNext()) {
            Object edge = edges.next();
            this.drawEdge(edge);
            if (!selectedEdges.contains(edge)) continue;
            this._selectionModel.addSelection(this.getFigure(edge));
        }
        nodes = this._model.nodesAfterEdges(this._model.getRoot());
        while (nodes.hasNext()) {
            node2 = nodes.next();
            this.drawNode(node2);
        }
        for (Object node2 : GraphUtilities.nodeSet(this._model.getRoot(), this._model)) {
            if (!selectedNodes.contains(node2)) continue;
            this._selectionModel.addSelection(this.getFigure(node2));
        }
    }

    public void rerenderEdge(Object edge) {
        this.rerender();
    }

    public void rerenderNode(Object node) {
        this.rerender();
    }

    public void setGraphModel(GraphModel model) {
        Object root;
        if (this._model != null) {
            root = this._model.getRoot();
            if (this._model.getNodeCount(root) != 0) {
                Iterator i = this._model.nodes(root);
                while (i.hasNext()) {
                    this.clearNode(i.next());
                }
                i = GraphUtilities.totallyContainedEdges(root, this._model);
                while (i.hasNext()) {
                    this.clearEdge(i.next());
                }
            }
            this._model.removeGraphListener(this._localListener);
        }
        this._model = model;
        if (this._model != null) {
            this._model.addGraphListener(this._localListener);
            root = this._model.getRoot();
            GraphEvent evt = new GraphEvent(new Object(), 30, root);
            this._localListener.structureChanged(evt);
        }
    }

    public void setFigure(Object semanticObj, Figure f) {
        if (f == null) {
            this._map.remove(semanticObj);
        } else {
            this._map.put(semanticObj, f);
        }
    }

    public void setGraphPane(GraphPane pane) {
        this._pane = pane;
        this.initializeInteraction();
    }

    public void setSelectionModel(SelectionModel m) {
        this._selectionModel = m;
    }

    public void dispatch(GraphViewEvent e) {
        for (GraphViewListener l : this._graphViewListenerList) {
            switch (e.getID()) {
                case 11: {
                    l.nodeMoved(e);
                    break;
                }
                case 12: {
                    l.edgeRouted(e);
                    break;
                }
                case 20: {
                    l.nodeDrawn(e);
                    break;
                }
                case 21: {
                    l.edgeDrawn(e);
                }
            }
        }
    }

    protected abstract void initializeInteraction();

    private class ChangeListener
    implements GraphListener {
        private ChangeListener() {
        }

        public void edgeHeadChanged(GraphEvent e) {
            if (e.getSource() != AbstractGraphController.this) {
                AbstractGraphController.this.rerenderEdge(e.getTarget());
            }
        }

        public void edgeTailChanged(GraphEvent e) {
            if (e.getSource() != AbstractGraphController.this) {
                AbstractGraphController.this.rerenderEdge(e.getTarget());
            }
        }

        public void nodeAdded(GraphEvent e) {
            if (e.getSource() != AbstractGraphController.this) {
                AbstractGraphController.this.drawNode(e.getTarget());
            }
        }

        public void nodeRemoved(GraphEvent e) {
            if (e.getSource() != AbstractGraphController.this) {
                AbstractGraphController.this.clearNode(e.getTarget());
            }
        }

        public void structureChanged(GraphEvent e) {
            if (e.getSource() != AbstractGraphController.this) {
                AbstractGraphController.this.rerender();
            }
        }
    }
}

