/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.Figure;
import diva.canvas.TransformContext;
import diva.util.java2d.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class VectorFigure
extends AbstractFigure {
    static final int FILLMODE = 87;
    static final int LINEMODE = 143;
    private ArrayList _objects = new ArrayList();
    private TransformContext _transformContext = new TransformContext(this);
    private Shape _shape;
    private Shape _cachedShape;
    private Rectangle2D _bounds;
    private Rectangle2D _cachedBounds;

    public void add(Shape s) {
        this._objects.add(s);
        this._bounds = null;
        this._cachedBounds = null;
    }

    public void add(Figure f) {
        this._objects.add(f);
        this._bounds = null;
        this._cachedBounds = null;
    }

    public void add(Composite c) {
        this._objects.add(c);
    }

    public void add(Paint p) {
        this._objects.add(p);
    }

    public void add(Stroke s) {
        this._objects.add(s);
    }

    public void fillMode() {
        this._objects.add(new CtrlObj(87));
    }

    public Rectangle2D getBounds() {
        if (this._bounds == null) {
            Iterator i = this._objects.iterator();
            Rectangle2D bounds = null;
            boolean fillMode = false;
            Stroke stroke = new BasicStroke(1.0f);
            while (i.hasNext()) {
                Object obj = i.next();
                Rectangle2D b = null;
                if (obj instanceof CtrlObj) {
                    switch (((CtrlObj)obj).code) {
                        case 87: {
                            fillMode = true;
                            break;
                        }
                        case 143: {
                            fillMode = false;
                        }
                    }
                } else if (obj instanceof Shape) {
                    b = fillMode ? ((Shape)obj).getBounds2D() : ShapeUtilities.computeStrokedBounds((Shape)obj, stroke);
                } else if (obj instanceof Figure) {
                    b = ((Figure)obj).getBounds();
                } else if (obj instanceof Stroke) {
                    stroke = (Stroke)obj;
                }
                if (b == null) continue;
                if (bounds == null) {
                    bounds = b;
                    continue;
                }
                Rectangle2D.union(bounds, b, bounds);
            }
            if (bounds != null) {
                this._bounds = bounds;
            }
        }
        if (this._cachedBounds == null) {
            AffineTransform at = this._transformContext.getTransform();
            this._cachedBounds = ShapeUtilities.transformBounds(this._bounds, at);
        }
        return this._cachedBounds;
    }

    public Shape getShape() {
        if (this._shape == null) {
            return this.getBounds();
        }
        if (this._cachedShape == null) {
            AffineTransform at = this._transformContext.getTransform();
            this._cachedShape = at.createTransformedShape(this._shape);
        }
        return this._cachedShape;
    }

    public void lineMode() {
        this._objects.add(new CtrlObj(143));
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        this._transformContext.push(g);
        boolean fillMode = false;
        for (Object obj : this._objects) {
            if (obj instanceof CtrlObj) {
                switch (((CtrlObj)obj).code) {
                    case 87: {
                        fillMode = true;
                        break;
                    }
                    case 143: {
                        fillMode = false;
                    }
                }
                continue;
            }
            if (obj instanceof Shape) {
                if (fillMode) {
                    g.fill((Shape)obj);
                    continue;
                }
                g.draw((Shape)obj);
                continue;
            }
            if (obj instanceof Figure) {
                ((Figure)obj).paint(g);
                continue;
            }
            if (obj instanceof Color) {
                g.setPaint((Paint)obj);
                continue;
            }
            if (obj instanceof Stroke) {
                g.setStroke((Stroke)obj);
                continue;
            }
            if (!(obj instanceof Composite)) continue;
            g.setComposite((Composite)obj);
        }
        this._transformContext.pop(g);
    }

    public void setShape(Shape s) {
        this._shape = s;
        this._cachedShape = null;
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._cachedBounds = null;
        this._cachedShape = null;
        this._transformContext.preConcatenate(at);
        this.repaint();
    }

    private static class CtrlObj {
        private int code = 0;

        private CtrlObj(int i) {
            this.code = i;
        }
    }
}

