/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import diva.canvas.TransformContext;
import diva.util.java2d.ShapeUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;

public class LabelFigure
extends AbstractFigure {
    private int _anchor = 0;
    private Rectangle2D _bounds = null;
    private Rectangle2D _cachedBounds = null;
    private static Font _defaultFont = new Font("Serif", 0, 16);
    private Paint _fillPaint = Color.black;
    private Font _font;
    private double _padding = 4.0;
    private Shape _shape;
    private String _string;
    private TransformContext _transformContext;
    private static int[] _anchors = new int[]{5, 1, 7, 3, 6, 4, 8, 2};

    public LabelFigure() {
        this("", _defaultFont);
    }

    public LabelFigure(String s) {
        this(s, _defaultFont);
    }

    public LabelFigure(String s, String face, int style, int size) {
        this(s, new Font(face, style, size));
    }

    public LabelFigure(String s, Font f) {
        this._string = s;
        this._font = f;
        this._transformContext = new TransformContext(this);
    }

    public LabelFigure(String s, Font font, double padding, int anchor) {
        this(s, font);
        this._padding = padding;
        this._anchor = anchor;
    }

    public void autoAnchor(Shape s) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setRect(this.getBounds());
        Point2D location = this.getAnchorPoint();
        int i = 0;
        while (i < _anchors.length) {
            Point2D pt = CanvasUtilities.getLocation(r, _anchors[i]);
            CanvasUtilities.translate(pt, this._padding, _anchors[i]);
            r.x += location.getX() - pt.getX();
            r.y += location.getY() - pt.getY();
            if (!s.intersects(r)) {
                this.setAnchor(_anchors[i]);
                break;
            }
            ++i;
        }
    }

    public int getAnchor() {
        return this._anchor;
    }

    public Point2D getAnchorPoint() {
        Rectangle2D bounds = this.getBounds();
        Point2D pt = CanvasUtilities.getLocation(bounds, this._anchor);
        if (this._anchor != 0) {
            CanvasUtilities.translate(pt, this._padding, this._anchor);
        }
        return pt;
    }

    public Rectangle2D getBounds() {
        if (this._cachedBounds == null) {
            if (this._shape == null) {
                this._update();
            }
            AffineTransform at = this._transformContext.getTransform();
            this._cachedBounds = ShapeUtilities.transformBounds(this._bounds, at);
        }
        return this._cachedBounds;
    }

    public Font getFont() {
        return this._font;
    }

    public Paint getFillPaint() {
        return this._fillPaint;
    }

    public Point2D getOrigin() {
        return this.getAnchorPoint();
    }

    public double getPadding() {
        return this._padding;
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public String getString() {
        return this._string;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this._cachedBounds == null) {
            this.getBounds();
        }
        if (this._string != null) {
            this._transformContext.push(g);
            g.setPaint(this._fillPaint);
            g.fill(this._shape);
            this._transformContext.pop(g);
        }
    }

    public void setAnchor(int anchor) {
        if (this._bounds == null) {
            this._anchor = anchor;
        } else {
            Point2D oldpt = this.getAnchorPoint();
            this._anchor = anchor;
            Point2D newpt = this.getAnchorPoint();
            this.repaint();
            this.translate(oldpt.getX() - newpt.getX(), oldpt.getY() - newpt.getY());
            this.repaint();
        }
    }

    public void setFillPaint(Paint p) {
        this._fillPaint = p;
        this.repaint();
    }

    public void setFont(Font f) {
        if (this._cachedBounds == null) {
            this._font = f;
        } else {
            Point2D pt = this.getAnchorPoint();
            this._font = f;
            this._update();
            this.translateTo(pt);
        }
    }

    public void setPadding(double padding) {
        this._padding = padding;
        this.setAnchor(this._anchor);
    }

    public void setString(String s) {
        if (this._cachedBounds == null) {
            this._string = s;
        } else {
            this.repaint();
            Point2D pt = this.getAnchorPoint();
            this._string = s;
            this._update();
            Point2D badpt = this.getAnchorPoint();
            this.translate(pt.getX() - badpt.getX(), pt.getY() - badpt.getY());
            this.repaint();
        }
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._cachedBounds = null;
        this._transformContext.preConcatenate(at);
        this.repaint();
    }

    public void translateTo(double x, double y) {
        this.repaint();
        Point2D pt = this.getAnchorPoint();
        this.translate(x - pt.getX(), y - pt.getY());
        this.repaint();
    }

    public void translateTo(Point2D pt) {
        this.translateTo(pt.getX(), pt.getY());
    }

    private void _update() {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        if (this._string.indexOf(10) < 0) {
            GlyphVector gv = this._font.createGlyphVector(frc, this._string);
            this._shape = gv.getOutline();
            this._bounds = this._string.trim().equals("") ? new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f) : this._shape.getBounds2D();
        } else {
            double dy = this._font.getMaxCharBounds(frc).getHeight();
            StringTokenizer lines = new StringTokenizer(this._string, "\n", true);
            this._shape = null;
            int count = 0;
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                if (line.equals("\n")) {
                    ++count;
                    continue;
                }
                if (line.trim().equals("")) continue;
                GlyphVector gv = this._font.createGlyphVector(frc, line);
                Shape s = gv.getOutline();
                if (this._shape == null) {
                    this._shape = s;
                    continue;
                }
                s = ShapeUtilities.translateModify(s, 0.0, (double)count * dy);
                ((GeneralPath)this._shape).append(s, false);
            }
            this._bounds = this._shape.getBounds2D();
        }
        this._cachedBounds = null;
    }
}

