/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.BasicSelectionModel;
import diva.canvas.interactor.BasicSelectionRenderer;
import diva.canvas.interactor.CompositeInteractor;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.Manipulator;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.interactor.SelectionRenderer;
import java.util.Iterator;

public class SelectionInteractor
extends CompositeInteractor {
    private SelectionModel _selection;
    private SelectionRenderer _renderer;
    private MouseFilter _selectionFilter = MouseFilter.selectionFilter;
    private MouseFilter _toggleFilter = MouseFilter.alternateSelectionFilter;

    public SelectionInteractor() {
        this.setSelectionRenderer(new BasicSelectionRenderer());
        this.setSelectionModel(new BasicSelectionModel());
    }

    public SelectionInteractor(SelectionModel model) {
        this.setSelectionRenderer(new BasicSelectionRenderer());
        this.setSelectionModel(model);
    }

    public boolean accept(LayerEvent e) {
        return this._selectionFilter.accept(e) || this._toggleFilter.accept(e) || super.accept(e);
    }

    public MouseFilter getSelectionFilter() {
        return this._selectionFilter;
    }

    public SelectionModel getSelectionModel() {
        return this._selection;
    }

    public SelectionRenderer getSelectionRenderer() {
        return this._renderer;
    }

    public MouseFilter getToggleFilter() {
        return this._toggleFilter;
    }

    public static boolean isSelected(LayerEvent e) {
        Figure f = e.getFigureSource();
        if (f.getInteractor() instanceof SelectionInteractor) {
            SelectionInteractor i = (SelectionInteractor)f.getInteractor();
            return i.getSelectionModel().containsSelection(f);
        }
        return false;
    }

    public void mousePressed(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Figure figure = event.getFigureSource();
        boolean isChanged = false;
        if (this._selectionFilter.accept(event)) {
            if (!this._selection.containsSelection(figure)) {
                this._selection.clearSelection();
                this._selection.addSelection(figure);
                isChanged = true;
            }
        } else if (this._toggleFilter.accept(event)) {
            if (this._selection.containsSelection(figure)) {
                this._selection.removeSelection(figure);
            } else {
                this._selection.addSelection(figure);
            }
            isChanged = true;
        }
        if (this._selection.getSelectionCount() > 0 && this._selection.containsSelection(figure)) {
            Object[] target = this._selection.getSelectionAsArray();
            Iterator i = this.interactors();
            while (i.hasNext()) {
                Interactor interactor = (Interactor)i.next();
                if (!(interactor instanceof DragInteractor)) continue;
                ((DragInteractor)interactor).setTargetArray(target);
            }
        }
        super.mousePressed(event);
        if (isChanged) {
            event.consume();
        }
    }

    public void setConsuming(boolean flag) {
        super.setConsuming(flag);
    }

    public void setSelectionModel(SelectionModel model) {
        if (this._selection != null) {
            this._selection.clearSelection();
        }
        this._selection = model;
    }

    public void setSelectionFilter(MouseFilter f) {
        this._selectionFilter = f;
    }

    public void setPrototypeDecorator(FigureDecorator decorator) {
        this._renderer = new BasicSelectionRenderer(decorator);
    }

    public void setSelectionManipulator(Manipulator manipulator) {
        this._renderer = new BasicSelectionRenderer(manipulator);
    }

    public void setSelectionRenderer(SelectionRenderer r) {
        this._renderer = r;
    }

    public void setToggleFilter(MouseFilter f) {
        this._toggleFilter = f;
    }
}

