/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.Figure;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerEventMulticaster;
import diva.canvas.event.LayerListener;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.interactor.PointConstraint;
import diva.canvas.interactor.SelectionInteractor;
import diva.util.ArrayIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class DragInteractor
extends AbstractInteractor {
    private ArrayList _constraints;
    private transient Object[] _targetArray;
    private transient LayerListener _layerListener;
    private double _prevX = 0.0;
    private double _prevY = 0.0;
    private boolean _selectiveEnabled;

    public void addLayerListener(LayerListener l) {
        this._layerListener = LayerEventMulticaster.add(this._layerListener, l);
    }

    public void appendConstraint(PointConstraint constraint) {
        if (this._constraints == null) {
            this._constraints = new ArrayList();
        }
        this._constraints.add(constraint);
    }

    public void constrainPoint(Point2D p) {
        if (this._constraints != null) {
            for (PointConstraint c : this._constraints) {
                c.constrain(p);
            }
        }
    }

    public void fireLayerEvent(LayerEvent event) {
        if (this._layerListener != null) {
            int id = event.getID();
            switch (id) {
                case 501: {
                    this._layerListener.mousePressed(event);
                    break;
                }
                case 506: {
                    this._layerListener.mouseDragged(event);
                    break;
                }
                case 502: {
                    this._layerListener.mouseReleased(event);
                }
            }
        }
    }

    public boolean getSelectiveEnabled() {
        return this._selectiveEnabled;
    }

    public Object[] getTargetArray() {
        return this._targetArray;
    }

    public double getX() {
        return this._prevX;
    }

    public double getY() {
        return this._prevY;
    }

    public void mouseDragged(LayerEvent e) {
        if (!this.isEnabled() || this._selectiveEnabled && !SelectionInteractor.isSelected(e)) {
            return;
        }
        if (this.getMouseFilter() == null || this.getMouseFilter().accept(e)) {
            Point2D p = e.getLayerPoint();
            this.constrainPoint(p);
            double x = p.getX();
            double y = p.getY();
            double deltaX = x - this._prevX;
            double deltaY = y - this._prevY;
            if (deltaX != 0.0 || deltaY != 0.0) {
                this.translate(e, deltaX, deltaY);
                this.fireLayerEvent(e);
            }
            this._prevX = x;
            this._prevY = y;
            if (this.isConsuming()) {
                e.consume();
            }
        }
    }

    public void mousePressed(LayerEvent e) {
        if (!this.isEnabled() || this._selectiveEnabled && !SelectionInteractor.isSelected(e)) {
            return;
        }
        if (this.getMouseFilter() == null || this.getMouseFilter().accept(e)) {
            if (this._targetArray == null) {
                this._targetArray = new Object[1];
                this._targetArray[0] = e.getFigureSource();
            }
            this.setup(e);
            Point2D p = e.getLayerPoint();
            this._prevX = p.getX();
            this._prevY = p.getY();
            this.fireLayerEvent(e);
            if (this.isConsuming()) {
                e.consume();
            }
        }
    }

    public void mouseReleased(LayerEvent e) {
        if (!this.isEnabled() || this._selectiveEnabled && !SelectionInteractor.isSelected(e)) {
            return;
        }
        if (this.getMouseFilter() == null || this.getMouseFilter().accept(e)) {
            this.fireLayerEvent(e);
            this._targetArray = null;
            if (this.isConsuming()) {
                e.consume();
            }
        }
    }

    public void prependConstraint(PointConstraint constraint) {
        if (this._constraints == null) {
            this._constraints = new ArrayList();
        }
        this._constraints.add(0, constraint);
    }

    public void removeLayerListener(LayerListener l) {
        this._layerListener = LayerEventMulticaster.remove(this._layerListener, l);
    }

    public boolean setSelectiveEnabled(boolean s) {
        this._selectiveEnabled = s;
        return this._selectiveEnabled;
    }

    public void setTargetArray(Object[] arr) {
        this._targetArray = arr;
    }

    public void setup(LayerEvent e) {
    }

    public Iterator targets() {
        return new ArrayIterator(this._targetArray);
    }

    public void translate(LayerEvent e, double x, double y) {
        Iterator i = this.targets();
        while (i.hasNext()) {
            Figure t = (Figure)i.next();
            t.translate(x, y);
        }
    }
}

