/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.connector.AbstractConnector;
import diva.canvas.connector.ArcMidpointSite;
import diva.canvas.toolbox.LabelFigure;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class ArcConnector
extends AbstractConnector {
    private static double MINSELFLOOPANGLE = 1.8849555921538759;
    private Arc2D _arc = new Arc2D.Double();
    private boolean _selfloop;
    private double _exitAngle = 0.6283185307179586;
    private double _previousAngle = 2.356194490192345;
    private double _centerX;
    private double _centerY;
    private double _radius;
    private double _startAngle;
    private double _extentAngle;
    private double _gamma = 0.0;
    protected static final double _CLOSE_THRESHOLD = 5.0;
    private ArcMidpointSite _midpointSite;

    public ArcConnector(Site tail, Site head) {
        super(tail, head);
        this.setShape(this._arc);
        this.route();
    }

    public double getAngle() {
        return this._exitAngle;
    }

    public double getGamma() {
        return this._gamma;
    }

    public Point2D getArcMidpoint() {
        return new Point2D.Double(this._centerX + this._radius * Math.sin(this._startAngle + this._extentAngle / 2.0 + 1.5707963267948966), this._centerY + this._radius * Math.cos(this._startAngle + this._extentAngle / 2.0 + 1.5707963267948966));
    }

    public Site getMidpointSite() {
        if (this._midpointSite == null) {
            this._midpointSite = new ArcMidpointSite(this, 0);
        }
        return this._midpointSite;
    }

    public boolean getSelfLoop() {
        return this._selfloop;
    }

    public void repositionLabel() {
        LabelFigure label = this.getLabelFigure();
        if (label != null) {
            Point2D pt = this.getArcMidpoint();
            label.translateTo(pt);
            label.autoAnchor(this._arc);
        }
    }

    public void route() {
        Point2D headPt;
        Point2D tailPt;
        this.repaint();
        TransformContext currentContext = this.getTransformContext();
        Site headSite = this.getHeadSite();
        Site tailSite = this.getTailSite();
        Figure tailFigure = tailSite.getFigure();
        Figure headFigure = headSite.getFigure();
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        Point2D tailCenter = tailFigure != null ? CanvasUtilities.getCenterPoint(tailFigure, currentContext) : tailPt;
        Point2D headCenter = headFigure != null ? CanvasUtilities.getCenterPoint(headFigure, currentContext) : headPt;
        boolean selfloop = this._selfloop;
        if (tailFigure != null && headFigure != null) {
            boolean bl = selfloop = tailFigure == headFigure;
        }
        if (selfloop && !this._selfloop) {
            this.setSelfLoop(true);
        } else if (!selfloop && this._selfloop) {
            this.setSelfLoop(false);
        }
        double x = headCenter.getX() - tailCenter.getX();
        double y = headCenter.getY() - tailCenter.getY();
        double gamma = this._selfloop ? this._gamma : Math.atan2(y, x);
        double alpha = this._exitAngle;
        double beta = 1.5707963267948966 - alpha;
        double headNormal = gamma - alpha - Math.PI;
        double tailNormal = gamma + alpha;
        tailSite.setNormal(tailNormal);
        headSite.setNormal(headNormal);
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        if (this.getHeadEnd() != null) {
            this.getHeadEnd().setNormal(headNormal);
            this.getHeadEnd().setOrigin(headPt.getX(), headPt.getY());
            this.getHeadEnd().getConnection(headPt);
        }
        if (this.getTailEnd() != null) {
            this.getTailEnd().setNormal(tailNormal);
            this.getTailEnd().setOrigin(tailPt.getX(), tailPt.getY());
            this.getTailEnd().getConnection(tailPt);
        }
        x = headPt.getX() - tailPt.getX();
        y = headPt.getY() - tailPt.getY();
        if (this._selfloop && tailFigure != null && headFigure != null) {
            this._gamma = gamma;
            gamma = Math.atan2(y, x);
        } else {
            this._gamma = gamma = Math.atan2(y, x);
        }
        double dx = Math.sqrt(x * x + y * y) / 2.0;
        double dy = -dx * Math.tan(beta);
        double dxdash = dx * Math.cos(gamma) - dy * Math.sin(gamma);
        double dydash = dx * Math.sin(gamma) + dy * Math.cos(gamma);
        double centerX = tailPt.getX() + dxdash;
        double centerY = tailPt.getY() + dydash;
        double radius = Math.sqrt(dx * dx + dy * dy);
        this._centerX = centerX;
        this._centerY = centerY;
        this._radius = radius;
        this._startAngle = 4.71238898038469 - alpha - gamma;
        if (this._exitAngle < 0.0) {
            this._startAngle += Math.PI;
        }
        this._extentAngle = 2.0 * alpha;
        this._arc.setArcByCenter(centerX, centerY, radius, this._startAngle / Math.PI * 180.0, this._extentAngle / Math.PI * 180.0, 0);
        this.repositionLabel();
        this.repaint();
    }

    public void setAngle(double angle) {
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        this._exitAngle = angle;
    }

    public void setGamma(double gamma) {
        this._gamma = gamma;
    }

    public void setSelfLoop(boolean selfloop) {
        double temp = this._exitAngle;
        if (selfloop) {
            if (this._exitAngle > 0.0 && this._exitAngle < MINSELFLOOPANGLE) {
                this.setAngle(Math.max(this._previousAngle, MINSELFLOOPANGLE));
            } else if (this._exitAngle < 0.0 && this._exitAngle > -MINSELFLOOPANGLE) {
                this.setAngle(Math.min(-this._previousAngle, -MINSELFLOOPANGLE));
            }
        } else if (this._previousAngle < MINSELFLOOPANGLE) {
            this.setAngle(this._previousAngle);
        }
        this._previousAngle = temp;
        this._selfloop = selfloop;
    }

    public void translate(double x, double y) {
        Rectangle bounds = this._arc.getBounds();
        this.repaint();
        this._arc.setFrame(((RectangularShape)bounds).getX() + x, ((RectangularShape)bounds).getY() + y, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
        if (this.getLabelFigure() != null) {
            this.getLabelFigure().translate(x, y);
        }
        this.repaint();
    }

    public void translateMidpoint(double dx, double dy) {
        double newangle;
        Point2D headPt;
        Point2D tailPt;
        TransformContext currentContext = this.getTransformContext();
        Site headSite = this.getHeadSite();
        Site tailSite = this.getTailSite();
        Figure tailFigure = tailSite.getFigure();
        Figure headFigure = headSite.getFigure();
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        Point2D tailCenter = tailFigure != null ? CanvasUtilities.getCenterPoint(tailFigure, currentContext) : tailPt;
        Point2D headCenter = headFigure != null ? CanvasUtilities.getCenterPoint(headFigure, currentContext) : headPt;
        double x = headCenter.getX() - tailCenter.getX();
        double y = headCenter.getY() - tailCenter.getY();
        double gamma = this._selfloop ? this._gamma : Math.atan2(y, x);
        double beta = Math.atan2(dy, dx);
        double magnitude = Math.sqrt(dx * dx + dy * dy);
        double shift = -magnitude * Math.sin(gamma - beta);
        double rotate = magnitude * Math.cos(gamma - beta);
        double absangle = Math.abs(this._exitAngle);
        if (!this._selfloop) {
            double delta = absangle < 0.7853981633974483 ? shift / 75.0 : (absangle < 1.5707963267948966 ? shift / 120.0 : (absangle < 2.0420352248333655 ? shift / 400.0 : (absangle < 2.5132741228718345 ? shift / 1000.0 : (absangle < 2.827433388230814 ? shift / 4000.0 : shift / 10000.0))));
            newangle = this._exitAngle + delta;
        } else {
            double delta = absangle < 2.356194490192345 ? shift / 100.0 : (absangle < 2.670353755551324 ? shift / 300.0 : (absangle < 2.827433388230814 ? shift / 1000.0 : (absangle < 2.9845130209103035 ? shift / 4000.0 : shift / 10000.0)));
            newangle = this._exitAngle + delta;
            if (newangle > 0.0 && newangle < 1.8849555921538759) {
                newangle = 1.8849555921538759;
            } else if (newangle < 0.0 && newangle > -1.8849555921538759) {
                newangle = -1.8849555921538759;
            }
            if (tailFigure != null && headFigure != null) {
                double phi = rotate / this._radius / 2.0;
                this._gamma = newangle < 0.0 ? (this._gamma += phi) : (this._gamma -= phi);
            }
        }
        this.setAngle(newangle);
    }
}

