/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasComponent;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public class TransformContext {
    private boolean _cacheValid = false;
    private int _version = 0;
    private CanvasComponent _component;
    private AffineTransform _graphicsTransform;
    private AffineTransform _transform = new AffineTransform();
    private AffineTransform _inverseTransform;
    private AffineTransform _screenTransform;

    public TransformContext(CanvasComponent component) {
        this._component = component;
    }

    public void checkCacheValid(TransformContext ancestor) {
        TransformContext c = this;
        while (c != ancestor && c != null) {
            c.invalidateCache();
            c = c.getParent();
        }
    }

    public void concatenate(AffineTransform at) {
        this._transform.concatenate(at);
        this.invalidateCache();
    }

    public CanvasComponent getComponent() {
        return this._component;
    }

    public AffineTransform getInverseTransform() {
        if (this._inverseTransform == null) {
            try {
                this._inverseTransform = this._transform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        return this._inverseTransform;
    }

    public TransformContext getParent() {
        if (this._component.getParent() == null) {
            return null;
        }
        return this._component.getParent().getTransformContext();
    }

    public AffineTransform getScreenTransform() {
        if (!this._cacheValid) {
            this.validateCache();
        }
        return this._screenTransform;
    }

    public AffineTransform getTransform() {
        return this._transform;
    }

    public AffineTransform getTransform(TransformContext context) {
        if (context == this) {
            return new AffineTransform();
        }
        TransformContext parentContext = this._component.getParent().getTransformContext();
        AffineTransform transform = this._transform;
        if (parentContext == context) {
            transform = new AffineTransform(transform);
            transform.preConcatenate(parentContext.getTransform(context));
        }
        return transform;
    }

    public int getVersion() {
        return this._version;
    }

    public void invalidateCache() {
        ++this._version;
        this._cacheValid = false;
        this._inverseTransform = null;
    }

    public boolean isCacheValid() {
        return this._cacheValid;
    }

    public void push(Graphics2D g) {
        this._graphicsTransform = g.getTransform();
        g.transform(this._transform);
    }

    public void pop(Graphics2D g) {
        g.setTransform(this._graphicsTransform);
    }

    public void preConcatenate(AffineTransform at) {
        this._transform.preConcatenate(at);
        this.invalidateCache();
    }

    public void setTransform(AffineTransform at) {
        this._transform = at;
        this.invalidateCache();
    }

    public void translate(double x, double y) {
        AffineTransform at = new AffineTransform();
        at.translate(x, y);
        this._transform.preConcatenate(at);
        this.invalidateCache();
    }

    private void validateCache() {
        if (this._component.getParent() == null) {
            this._screenTransform = this._transform;
        } else {
            CanvasComponent p = this._component.getParent();
            this._screenTransform = new AffineTransform(p.getTransformContext().getScreenTransform());
            this._screenTransform.concatenate(this._transform);
        }
        this._cacheValid = true;
    }
}

